/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.search.indexEngine.DateFormatter;
import org.silverpeas.search.indexEngine.model.FieldDescription;
import org.silverpeas.search.indexEngine.model.FileDescription;
import org.silverpeas.search.indexEngine.model.IndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;
import org.silverpeas.search.indexEngine.model.TextDescription;

public class FullIndexEntry
extends IndexEntry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4955524385769457730L;
    private List<TextDescription> textList = null;
    private List<FileDescription> fileList = null;
    private List<FileDescription> linkedFileList = null;
    private List<FieldDescription> fields = null;
    private Set<String> linkedFileIdsList = null;

    public FullIndexEntry(String space, String component, String objectType, String objectId) {
        super(component, objectType, objectId);
    }

    public FullIndexEntry(String component, String objectType, String objectId) {
        super(component, objectType, objectId);
    }

    public FullIndexEntry(IndexEntryPK pk) {
        super(pk);
    }

    public void addTextContent(String text) {
        this.addTextContent(text, null);
    }

    public void addTextContent(String text, String language) {
        this.getTextList().add(new TextDescription(text, language));
    }

    public void addFileContent(String path, String encoding, String format, String lang) {
        if (path != null) {
            FileDescription fd = new FileDescription(path, encoding, format, lang);
            if (!this.getFileList().contains(fd)) {
                this.getFileList().add(fd);
            }
        }
    }

    public void addLinkedFileId(String fileId) {
        this.getLinkedFileIdsSet().add(fileId);
    }

    public void addLinkedFileContent(String path, String encoding, String format, String lang) {
        if (path != null) {
            this.getLinkedFileList().add(new FileDescription(path, encoding, format, lang));
        }
    }

    public void addXMLField(String fieldName, String value) {
        this.addXMLField(fieldName, value, null);
    }

    public void addXMLField(String fieldName, String value, String language) {
        this.getFields().add(new FieldDescription(fieldName, value, language, false));
    }

    public void addField(String fieldName, String value) {
        this.addField(fieldName, value, null, false);
    }

    public void addField(String fieldName, String value, String language, boolean stored) {
        this.getFields().add(new FieldDescription(fieldName, value, language, stored));
    }

    public void addField(String fieldName, Date value) {
        this.addField(fieldName, value, null);
    }

    public void addField(String fieldName, Date value, String language) {
        this.getFields().add(new FieldDescription(fieldName, DateFormatter.date2IndexFormat(value), language, false));
    }

    public List<TextDescription> getTextContentList() {
        return this.getTextList();
    }

    public List<FileDescription> getFileContentList() {
        return this.getFileList();
    }

    public List<FileDescription> getLinkedFileContentList() {
        return this.getLinkedFileList();
    }

    public List<FieldDescription> getXmlFields() {
        return this.getFields();
    }

    private List<TextDescription> getTextList() {
        if (this.textList == null) {
            this.textList = new ArrayList<TextDescription>();
        }
        return this.textList;
    }

    private List<FileDescription> getFileList() {
        if (this.fileList == null) {
            this.fileList = new ArrayList<FileDescription>();
        }
        return this.fileList;
    }

    private List<FileDescription> getLinkedFileList() {
        if (this.linkedFileList == null) {
            this.linkedFileList = new ArrayList<FileDescription>();
        }
        return this.linkedFileList;
    }

    public Set<String> getLinkedFileIdsSet() {
        if (this.linkedFileIdsList == null) {
            this.linkedFileIdsList = new HashSet<String>();
        }
        return this.linkedFileIdsList;
    }

    public List<FieldDescription> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDescription>();
        }
        return this.fields;
    }

    @Override
    public FullIndexEntry clone() {
        return (FullIndexEntry)super.clone();
    }
}

