/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.parser;

import com.silverpeas.util.ArrayUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.silverpeas.search.indexEngine.parser.Parser;
import org.silverpeas.search.indexEngine.parser.tika.TikaParser;

public final class ParserManager {
    private static final Map<String, Parser> parserMap = new HashMap<String, Parser>();
    private static final Parser defaultParser = new TikaParser();

    private ParserManager() {
    }

    public static Parser getParser(String format) {
        Parser parser = parserMap.get(format);
        if (parser == null) {
            return defaultParser;
        }
        return parser;
    }

    private static void init() {
        try {
            ResourceLocator parsersConfiguration = new ResourceLocator("org.silverpeas.search.indexEngine.Parser", "");
            Enumeration<String> formatNames = parsersConfiguration.getKeys();
            while (formatNames.hasMoreElements()) {
                String name = formatNames.nextElement();
                String newCall = parsersConfiguration.getString(name);
                if ("ignored".equals(newCall) || newCall.isEmpty()) continue;
                String className = ParserManager.getClassName(newCall);
                try {
                    Class<?> classe = Class.forName(className);
                    Class[] parametersClass = ParserManager.getParametersClass(newCall);
                    Constructor<?> constructor = classe.getConstructor(parametersClass);
                    Object[] parameters = ParserManager.getParameters(newCall);
                    Parser parser = (Parser)constructor.newInstance(parameters);
                    parserMap.put(name, parser);
                    SilverTrace.debug("indexEngine", "ParserManager", "indexEngine.MSG_INIT_PARSER", name + ", " + newCall);
                }
                catch (ClassNotFoundException e) {
                    SilverTrace.error("indexEngine", "ParserManager", "indexEngine.MSG_UNKNOWN_PARSER_CLASS", name + ", " + className);
                }
                catch (Exception e) {
                    SilverTrace.fatal("indexEngine", "ParserManager", "indexEngine.MSG_PARSER_INITIALIZATION_FAILED", name);
                }
            }
        }
        catch (MissingResourceException e) {
            SilverTrace.fatal("indexEngine", "ParserManager", "indexEngine.MSG_MISSING_PARSER_PROPERTIES");
        }
    }

    private static String getClassName(String newCall) {
        int par = newCall.indexOf(40);
        if (par == -1) {
            return newCall.trim();
        }
        return newCall.substring(0, par).trim();
    }

    private static Object[] getParameters(String newCall) {
        int lPar = newCall.indexOf(40);
        int rPar = newCall.indexOf(41);
        if (lPar == -1 || rPar == -1 || lPar + 1 >= rPar) {
            return new Object[0];
        }
        String argsString = newCall.substring(lPar + 1, rPar);
        StringTokenizer st = new StringTokenizer(argsString, ",", false);
        ArrayList<String> args = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            args.add(st.nextToken().trim());
        }
        return args.toArray();
    }

    private static Class[] getParametersClass(String newCall) {
        int lPar = newCall.indexOf(40);
        int rPar = newCall.indexOf(41);
        if (lPar == -1 || rPar == -1 || lPar + 1 >= rPar) {
            return ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        String argsString = newCall.substring(lPar + 1, rPar);
        StringTokenizer st = new StringTokenizer(argsString, ",", false);
        ArrayList args = new ArrayList(st.countTokens());
        while (st.hasMoreTokens()) {
            args.add(st.nextToken().getClass());
        }
        return args.toArray(new Class[args.size()]);
    }

    static {
        ParserManager.init();
    }
}

