/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.parser;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import org.silverpeas.search.indexEngine.parser.Parser;

public abstract class PipedParser
implements Parser {
    protected abstract void outPutContent(Writer var1, String var2, String var3) throws IOException;

    @Override
    public Reader getReader(String path, String encoding) {
        PipedReader pipeIn = null;
        PipedWriter pipeOut = null;
        try {
            pipeIn = new PipedReader();
            pipeOut = new PipedWriter(pipeIn);
            new ParserThread(pipeOut, path, encoding).start();
        }
        catch (IOException e) {
            SilverTrace.error("indexEngine", "PipedParser", "indexEngine.MSG_PIPE_CREATION_FAILED", path, e);
            try {
                if (pipeIn != null) {
                    pipeIn.close();
                }
                if (pipeOut != null) {
                    pipeOut.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            pipeIn = null;
        }
        return pipeIn;
    }

    private class ParserThread
    extends Thread {
        private final Writer out;
        private final String path;
        private final String encoding;

        public ParserThread(Writer out, String path, String encoding) {
            this.out = out;
            this.path = path;
            this.encoding = encoding;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.out != null) {
                try {
                    PipedParser.this.outPutContent(this.out, this.path, this.encoding);
                }
                catch (IOException e) {
                    SilverTrace.info("indexEngine", "PipedParser", "indexEngine.MSG_IO_ERROR_WHILE_PARSING", this.path, e);
                }
                finally {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

