/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.upload;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.MetaData;
import com.silverpeas.util.MetadataExtractor;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.util.AttachmentSettings;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.upload.UploadSession;

public class UploadedFile {
    private UploadSession uploadSession;
    private File file;
    private String title;
    private String description;
    private String uploader;

    public static UploadedFile from(HttpServletRequest request, String uploadSessionId, UserDetail uploader) {
        UploadSession uploadSession = UploadSession.from(uploadSessionId);
        return new UploadedFile(uploadSession, UploadedFile.getUploadedFile(uploadSession), request.getParameter(uploadSessionId + "-title"), request.getParameter(uploadSessionId + "-description"), uploader.getId());
    }

    private UploadedFile(UploadSession uploadSession, File file, String title, String description, String uploader) {
        this.uploadSession = uploadSession;
        this.file = file;
        this.title = title;
        this.description = description;
        this.uploader = uploader;
    }

    public UploadSession getUploadSession() {
        return this.uploadSession;
    }

    public File getFile() {
        return this.file;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    private void markAsProcessed() {
        this.uploadSession.clear();
    }

    public void registerAttachment(WAPrimaryKey resourcePk, String contributionLanguage) {
        this.registerAttachment(resourcePk, contributionLanguage, true);
    }

    public void registerAttachment(WAPrimaryKey resourcePk, String contributionLanguage, boolean indexIt) {
        SimpleDocument document = this.retrieveSimpleDocument(resourcePk, contributionLanguage);
        AttachmentServiceFactory.getAttachmentService().createAttachment(document, this.getFile(), indexIt, false);
        this.markAsProcessed();
    }

    public SimpleDocument retrieveSimpleDocument(WAPrimaryKey resourcePk, String contributionLanguage) {
        String lang = I18NHelper.checkLanguage(contributionLanguage);
        String title = StringUtil.defaultStringIfNotDefined(this.getTitle());
        String description = StringUtil.defaultStringIfNotDefined(this.getDescription());
        if (AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled() && !StringUtil.isDefined(title)) {
            MetadataExtractor extractor = MetadataExtractor.getInstance();
            MetaData metadata = extractor.extractMetadata(this.getFile());
            if (StringUtil.isDefined(metadata.getTitle())) {
                title = metadata.getTitle();
            }
            if (!StringUtil.isDefined(description) && StringUtil.isDefined(metadata.getSubject())) {
                description = metadata.getSubject();
            }
        }
        SimpleDocumentPK pk = new SimpleDocumentPK(null, resourcePk);
        SimpleDocument document = new SimpleDocument(pk, resourcePk.getId(), 0, false, null, new SimpleAttachment(this.getFile().getName(), lang, title, description, this.getFile().length(), FileUtil.getMimeType(this.getFile().getPath()), this.uploader, DateUtil.getNow(), null));
        boolean versioningActive = StringUtil.getBooleanValue(OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(resourcePk.getComponentName(), "versionControl"));
        if (versioningActive) {
            document = new HistorisedDocument(document);
            document.setPublicDocument(true);
        }
        document.setLanguage(lang);
        document.setTitle(title);
        document.setDescription(description);
        document.setSize(this.getFile().length());
        return document;
    }

    private static File getUploadedFile(UploadSession uploadSession) {
        File[] files = uploadSession.getRootFolderFiles();
        if (files.length != 1) {
            return new File(FileRepositoryManager.getTemporaryPath(), "unexistingFile");
        }
        return files[0];
    }
}

