/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import com.silverpeas.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringDataExtractor {
    private final String source;
    private final List<ExtractorDirective> directives = new ArrayList<ExtractorDirective>();

    public static StringDataExtractor from(String source) {
        return new StringDataExtractor(source);
    }

    private StringDataExtractor(String source) {
        this.source = source;
    }

    public StringDataExtractor withDirective(ExtractorDirective directive) {
        this.directives.add(directive);
        return this;
    }

    public StringDataExtractor withDirectives(List<? extends ExtractorDirective> directives) {
        for (ExtractorDirective extractorDirective : directives) {
            this.withDirective(extractorDirective);
        }
        return this;
    }

    public List<String> extract() {
        LinkedHashSet<String> data = new LinkedHashSet<String>();
        for (ExtractorDirective directive : this.directives) {
            data.addAll(directive.extract(this.source));
        }
        return new ArrayList<String>(data);
    }

    public String extractUnique() throws IllegalStateException {
        List<String> data = this.extract();
        if (data.size() > 1) {
            throw new IllegalStateException("Several values behind the extraction directive whereas an unique value is expected.");
        }
        return data.isEmpty() ? "" : data.get(0);
    }

    public static class RegexpPatternDirective
    implements ExtractorDirective {
        private final Pattern pattern;
        private final int[] groupIndexesToExtract;

        public static RegexpPatternDirective regexp(Pattern pattern, int ... groupIndexesToExtract) {
            return new RegexpPatternDirective(pattern, groupIndexesToExtract);
        }

        public static List<RegexpPatternDirective> regexps(List<Pattern> patterns, int ... groupIndexesToExtract) {
            ArrayList<RegexpPatternDirective> regexpPatternDirectives = new ArrayList<RegexpPatternDirective>();
            for (Pattern pattern : patterns) {
                regexpPatternDirectives.add(RegexpPatternDirective.regexp(pattern, groupIndexesToExtract));
            }
            return regexpPatternDirectives;
        }

        public static RegexpPatternDirective regexp(String pattern, int ... groupIndexesToExtract) {
            return RegexpPatternDirective.regexp(Pattern.compile(pattern), groupIndexesToExtract);
        }

        private RegexpPatternDirective(Pattern pattern, int ... groupIndexesToExtract) {
            this.pattern = pattern;
            this.groupIndexesToExtract = groupIndexesToExtract;
        }

        @Override
        public Set<String> extract(String source) {
            LinkedHashSet<String> data = new LinkedHashSet<String>();
            if (StringUtil.isDefined(source)) {
                int[] nArray;
                if (this.groupIndexesToExtract.length == 0) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    nArray = this.groupIndexesToExtract;
                }
                int[] groupIndexesToExtract = nArray;
                Matcher matcher = this.pattern.matcher(source);
                while (matcher.find()) {
                    int[] arr$ = groupIndexesToExtract;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Integer groupIndex = arr$[i$];
                        String extractData = matcher.group(groupIndex);
                        if (!StringUtil.isDefined(extractData)) continue;
                        data.add(extractData);
                    }
                }
            }
            return data;
        }
    }

    public static interface ExtractorDirective {
        public Set<String> extract(String var1);
    }
}

