/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.crypto.BlowfishKey;
import org.silverpeas.util.crypto.Cipher;
import org.silverpeas.util.crypto.CipherKey;
import org.silverpeas.util.crypto.CryptoException;
import org.silverpeas.util.crypto.CryptographicAlgorithmName;

public class BlowfishCipher
implements Cipher {
    private final javax.crypto.Cipher cipher;
    private BlowfishKey blowfishKey = new BlowfishKey();

    protected BlowfishCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        this.cipher = javax.crypto.Cipher.getInstance(CryptographicAlgorithmName.Blowfish.name());
    }

    @Override
    public CryptographicAlgorithmName getAlgorithmName() {
        return CryptographicAlgorithmName.Blowfish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(String data, CipherKey keyCode) throws CryptoException {
        byte[] cipherText;
        SilverTrace.info("util", "BlowfishCipher.encrypt", "root.MSG_GEN_ENTER_METHOD", "stringUnCrypted = " + data);
        try {
            byte[] cipherBytes = data.getBytes();
            BlowfishKey key = keyCode == null ? this.getSymmetricKey() : new BlowfishKey(keyCode.getRawKey());
            javax.crypto.Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(1, key);
                cipherText = this.cipher.doFinal(cipherBytes);
            }
        }
        catch (Exception e) {
            throw new CryptoException("The encryption failed!", e);
        }
        SilverTrace.info("util", "BlowfishCipher.encrypt", "root.MSG_GEN_EXIT_METHOD", "cipherText = " + Arrays.toString(cipherText));
        return cipherText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(byte[] cipher, CipherKey keyCode) throws CryptoException {
        String uncrypted;
        SilverTrace.info("util", "BlowfishCipher.decrypt", "root.MSG_GEN_ENTER_METHOD");
        try {
            BlowfishKey key = keyCode == null ? this.getSymmetricKey() : new BlowfishKey(keyCode.getRawKey());
            byte[] byArray = cipher;
            synchronized (cipher) {
                this.cipher.init(2, key);
                byte[] newPlainText = this.cipher.doFinal(cipher);
                // ** MonitorExit[var6_5] (shouldn't be in output)
                uncrypted = new String(newPlainText, Charsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new CryptoException("The decryption failed!", e);
        }
        {
            SilverTrace.info("util", "BlowfishCipher.decrypt", "root.MSG_GEN_EXIT_METHOD", "uncrypted = " + uncrypted);
            return uncrypted;
        }
    }

    private BlowfishKey getSymmetricKey() {
        return this.blowfishKey;
    }

    @Override
    public CipherKey generateCipherKey() throws CryptoException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(CryptographicAlgorithmName.Blowfish.name());
            SecretKey key = keyGenerator.generateKey();
            return CipherKey.aKeyFromBinary(key.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException("The generation of a cipher key failed!", ex);
        }
    }
}

