/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.silverpeas.util.crypto.AESCipher;
import org.silverpeas.util.crypto.BlowfishCipher;
import org.silverpeas.util.crypto.CAST5Cipher;
import org.silverpeas.util.crypto.CMSCipher;
import org.silverpeas.util.crypto.Cipher;
import org.silverpeas.util.crypto.CryptographicAlgorithmName;

public class CipherFactory {
    private static final CipherFactory instance = new CipherFactory();
    private static final Map<CryptographicAlgorithmName, Cipher> ciphers = new EnumMap<CryptographicAlgorithmName, Cipher>(CryptographicAlgorithmName.class);

    public static CipherFactory getFactory() {
        return instance;
    }

    public Cipher getCipher(CryptographicAlgorithmName cipherName) {
        return ciphers.get((Object)cipherName);
    }

    static {
        try {
            ciphers.put(CryptographicAlgorithmName.Blowfish, new BlowfishCipher());
        }
        catch (Exception ex) {
            Logger.getLogger(CipherFactory.class.getSimpleName()).log(Level.SEVERE, ex.getMessage());
        }
        ciphers.put(CryptographicAlgorithmName.CMS, new CMSCipher());
        ciphers.put(CryptographicAlgorithmName.CAST5, new CAST5Cipher());
        ciphers.put(CryptographicAlgorithmName.AES, new AESCipher());
    }
}

