/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.jcr;

import com.silverpeas.admin.components.InstanciationException;
import com.silverpeas.jcrutil.BasicDaoFactory;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class ComponentHelper {
    public static void deleteComponent(String componentId) throws InstanciationException {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            if (session.getRootNode().hasNode(componentId)) {
                Node componentNode = session.getRootNode().getNode(componentId);
                componentNode.remove();
            }
            session.save();
        }
        catch (RepositoryException rex) {
            throw new InstanciationException("ComponentHelper.deleteComponent()", 4, "root.EX_RECORD_DELETION_FAILED", "Node name = " + componentId, (Exception)((Object)rex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    public static void createForumComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:forum");
    }

    public static void createKmeliaComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:kmelia");
    }

    public static void createBlogComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:blog");
    }

    public static void createQuickInfoComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:quickInfo");
    }

    public static final void createAttachmentFolder(String componentId) throws InstanciationException {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            if (!session.getRootNode().hasNode(componentId)) {
                session.getRootNode().addNode(componentId, "nt:folder");
            }
            session.save();
        }
        catch (RepositoryException rex) {
            throw new InstanciationException("ComponentHelper.createComponentNode()", 4, "root.EX_RECORD_INSERTION_FAILED", "Node name = " + componentId + "/" + "nt:folder", (Exception)((Object)rex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    protected static final void createComponentNode(String componentId, String componentType) throws InstanciationException {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            if (session.getRootNode().hasNode(componentId)) {
                throw new InstanciationException("ComponentHelper.createComponentNode()", 4, "root.EX_RECORD_INSERTION_FAILED", "Node name = " + componentId + "/" + componentType + " already exists");
            }
            session.getRootNode().addNode(componentId, componentType);
            session.save();
        }
        catch (RepositoryException rex) {
            throw new InstanciationException("ComponentHelper.createComponentNode()", 4, "root.EX_RECORD_INSERTION_FAILED", "Node name = " + componentId + "/" + componentType, (Exception)((Object)rex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    public static void createNewsEditoComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:newsEdito");
    }

    public static void createGalleryComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:gallery");
    }

    public static void createQuestionReplyComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:questionReply");
    }

    public static void createWebSitesComponent(String componentId) throws InstanciationException {
        ComponentHelper.createComponentNode(componentId, "slv:webSites");
    }
}

