/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.mail;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.util.mail.EMLExtractor;
import org.silverpeas.util.mail.ExtractorException;
import org.silverpeas.util.mail.MSGExtractor;
import org.silverpeas.util.mail.MailExtractor;

public class Extractor {
    public static MailExtractor getExtractor(File file) throws ExtractorException {
        if (!file.exists() || file.isDirectory()) {
            throw new ExtractorException("Extractor.getExtractor", 4, "file not found");
        }
        if (FilenameUtils.isExtension((String)file.getName(), (String)"eml")) {
            return new EMLExtractor(file);
        }
        if (FilenameUtils.isExtension((String)file.getName(), (String)"msg")) {
            return new MSGExtractor(file);
        }
        throw new ExtractorException("Extractor.getExtractor", 4, "Extension not supported");
    }
}

