/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.security;

import com.stratelia.webactiv.util.ResourceLocator;

public class SecuritySettings {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.util.security", "");

    private static boolean isWebProtectionEnabled() {
        return settings.getBoolean("security.web.protection", false);
    }

    public static boolean isWebSqlInjectionSecurityEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.injection.sql", false);
    }

    public static String skippedParametersAboutWebSqlInjectionSecurity() {
        return settings.getString("security.web.protection.injection.sql.skipped.parameters", "");
    }

    public static boolean isWebXssInjectionSecurityEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.injection.xss", false);
    }

    public static String skippedParametersAboutWebXssInjectionSecurity() {
        return settings.getString("security.web.protection.injection.xss.skipped.parameters", "");
    }

    public static boolean isWebSecurityByTokensEnabled() {
        return SecuritySettings.isWebProtectionEnabled() && settings.getBoolean("security.web.protection.token", false);
    }

    public static boolean isSessionTokenRenewEnabled() {
        return SecuritySettings.isWebSecurityByTokensEnabled() && settings.getBoolean("security.web.protection.sessiontoken.renew", false);
    }
}

