/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.exec.CommandLine;
import org.silverpeas.exec.ExternalExecution;

@Named(value="swfToolManager")
@Singleton
public class SwfToolManager {
    private static boolean isActivated = false;
    private static boolean isSwfRenderActivated = false;

    @PostConstruct
    public void initialize() throws Exception {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            CommandLine commandLine;
            if (!"path".equals(entry.getKey().toLowerCase())) continue;
            try {
                commandLine = new CommandLine("pdf2swf");
                commandLine.addArgument("--version");
                ExternalExecution.exec(commandLine);
                isActivated = true;
            }
            catch (Exception e) {
                System.err.println("pdf2swf is not installed");
            }
            try {
                commandLine = new CommandLine("swfrender");
                commandLine.addArgument("--help");
                ExternalExecution.exec(commandLine, ExternalExecution.Config.init().successfulExitStatusValueIs(1).doNotDisplayErrorTrace());
                isSwfRenderActivated = true;
            }
            catch (Exception e) {
                System.err.println("swfrender is not installed");
            }
        }
    }

    public static boolean isActivated() {
        return isActivated;
    }

    public static boolean isSwfRenderActivated() {
        return isSwfRenderActivated;
    }
}

