/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.calendar;

import com.silverpeas.calendar.Datable;
import com.silverpeas.calendar.DayOfWeek;
import com.silverpeas.calendar.DayOfWeekOccurrence;
import com.silverpeas.calendar.RecurrencePeriod;
import com.silverpeas.calendar.TimeUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CalendarEventRecurrence {
    public static final CalendarEventRecurrence NO_RECURRENCE = null;
    public static final int NO_RECURRENCE_COUNT = 0;
    public static final Datable<?> NO_RECURRENCE_END_DATE = null;
    private RecurrencePeriod frequency;
    private int count = 0;
    private Datable<?> endDate = NO_RECURRENCE_END_DATE;
    private List<DayOfWeekOccurrence> daysOfWeek = new ArrayList<DayOfWeekOccurrence>();
    private List<Datable<?>> exceptionDates = new ArrayList();

    public static CalendarEventRecurrence every(TimeUnit frequencyUnit) {
        return new CalendarEventRecurrence(RecurrencePeriod.every(1, frequencyUnit));
    }

    public static CalendarEventRecurrence every(int frequencyValue, TimeUnit frequencyUnit) {
        return new CalendarEventRecurrence(RecurrencePeriod.every(frequencyValue, frequencyUnit));
    }

    public static CalendarEventRecurrence anEventRecurrence(RecurrencePeriod period) {
        return new CalendarEventRecurrence(period);
    }

    public CalendarEventRecurrence excludeEventOccurrencesStartingAt(Datable<?> ... datables) {
        this.exceptionDates.addAll(Arrays.asList(datables));
        return this;
    }

    public CalendarEventRecurrence on(DayOfWeek ... days) {
        ArrayList<DayOfWeekOccurrence> dayOccurrences = new ArrayList<DayOfWeekOccurrence>();
        for (DayOfWeek dayOfWeek : days) {
            dayOccurrences.add(DayOfWeekOccurrence.nthOccurrence(0, dayOfWeek));
        }
        this.daysOfWeek.clear();
        this.daysOfWeek.addAll(dayOccurrences);
        return this;
    }

    public CalendarEventRecurrence on(DayOfWeekOccurrence ... days) {
        return this.on(Arrays.asList(days));
    }

    public CalendarEventRecurrence on(List<DayOfWeekOccurrence> days) {
        if (this.frequency.getUnit() == TimeUnit.WEEK) {
            for (DayOfWeekOccurrence dayOfWeekOccurrence : days) {
                if (dayOfWeekOccurrence.nth() == 1 || dayOfWeekOccurrence.nth() == 0) continue;
                throw new IllegalArgumentException("The occurrence of the day of week " + dayOfWeekOccurrence.dayOfWeek().name() + " cannot be possible with a weekly " + "recurrence");
            }
        }
        this.daysOfWeek.clear();
        this.daysOfWeek.addAll(days);
        return this;
    }

    public CalendarEventRecurrence upTo(int recurrenceCount) {
        if (recurrenceCount <= 0) {
            throw new IllegalArgumentException("The number of time the event has to recur should be a positive value");
        }
        this.endDate = null;
        this.count = recurrenceCount;
        return this;
    }

    public CalendarEventRecurrence upTo(Datable<?> endDate) {
        this.count = 0;
        this.endDate = endDate.clone();
        return this;
    }

    public RecurrencePeriod getFrequency() {
        return this.frequency;
    }

    public int getRecurrenceCount() {
        return this.count;
    }

    public Datable<?> getEndDate() {
        Datable<?> date = NO_RECURRENCE_END_DATE;
        if (this.endDate != NO_RECURRENCE_END_DATE) {
            date = this.endDate.clone();
        }
        return date;
    }

    public List<DayOfWeekOccurrence> getDaysOfWeek() {
        return Collections.unmodifiableList(this.daysOfWeek);
    }

    public List<Datable<?>> getExceptionDates() {
        return Collections.unmodifiableList(this.exceptionDates);
    }

    private CalendarEventRecurrence(RecurrencePeriod period) {
        this.frequency = period;
    }
}

