/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.GalleryHelper;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RenderingContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFileFieldDisplayer;
import com.silverpeas.form.fieldType.FileField;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.wysiwyg.control.WysiwygController;

public class ImageFieldDisplayer
extends AbstractFileFieldDisplayer {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.lookAndFeel.generalLook", "");

    @Override
    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        SimpleDocumentPK attachmentPk;
        SilverTrace.info("form", "ImageFieldDisplayer.display", "root.MSG_GEN_ENTER_METHOD", "fieldName = " + template.getFieldName() + ", value = " + field.getAttachmentId() + ", fieldType = " + field.getTypeName());
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        String language = pageContext.getLanguage();
        AbstractFileFieldDisplayer.Operation originalOperation = AbstractFileFieldDisplayer.Operation.ADD;
        String componentId = pageContext.getComponentId();
        String attachmentId = field.getAttachmentId();
        if (StringUtil.isLong(attachmentId)) {
            attachmentPk = new SimpleDocumentPK(null, componentId);
            attachmentPk.setOldSilverpeasId(Long.parseLong(attachmentId));
        } else {
            attachmentPk = new SimpleDocumentPK(attachmentId, componentId);
        }
        SimpleDocument attachment = null;
        String imageURL = null;
        if (StringUtil.isDefined(attachmentId)) {
            if (attachmentId.startsWith("/")) {
                imageURL = attachmentId;
                originalOperation = AbstractFileFieldDisplayer.Operation.UPDATE;
            } else {
                attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(attachmentPk, language);
                if (attachment != null) {
                    originalOperation = AbstractFileFieldDisplayer.Operation.UPDATE;
                    imageURL = pageContext.getRenderingContext() == RenderingContext.EXPORT ? "file:" + attachment.getAttachmentPath() : (pageContext.isSharingContext() ? pageContext.getSharingContext().getSharedUriOf(attachment).toString() : URLManager.getApplicationURL() + attachment.getAttachmentURL());
                }
            }
        } else {
            attachmentId = "";
        }
        Map<String, String> parameters = template.getParameters(language);
        if (template.isReadOnly() && !template.isHidden()) {
            if (imageURL != null) {
                this.displayImage(parameters, imageURL, out, pageContext.isSharingContext());
            }
        } else if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            String displayCSS = "display:none";
            if (imageURL != null) {
                displayCSS = "display:block";
            }
            String deleteImg = Util.getIcon("delete");
            String deleteLab = Util.getString("removeImage", language);
            String size = settings.getString("image.size.xmlform.thumbnail");
            if (!StringUtil.isDefined(size)) {
                size = "x50";
            }
            String thumbnailURL = imageURL;
            if (imageURL != null) {
                thumbnailURL = FileServerUtils.getImageURL(imageURL, size);
            }
            out.println("<div id=\"" + fieldName + "ThumbnailArea\" style=\"" + displayCSS + "\">");
            out.println("<a id=\"" + fieldName + "ThumbnailLink\" href=\"" + imageURL + "\" target=\"_blank\">");
            out.println("<img alt=\"\" align=\"top\" src=\"" + thumbnailURL + "\" id=\"" + fieldName + "Thumbnail\"/>&nbsp;");
            out.println("</a>");
            out.println("&nbsp;<a href=\"#\" onclick=\"javascript:document.getElementById('" + fieldName + "ThumbnailArea').style.display='none';" + "document." + pageContext.getFormName() + "." + fieldName + "Operation" + ".value='" + AbstractFileFieldDisplayer.Operation.DELETION.name() + "';return false;" + "\">");
            out.println("<img src=\"" + deleteImg + "\" width=\"15\" height=\"15\" alt=\"" + deleteLab + "\" align=\"top\" title=\"" + deleteLab + "\"/></a>");
            out.println("</div>");
            out.println("<div id=\"" + fieldName + "SelectionArea\">");
            out.print("<input type=\"file\" size=\"50\" id=\"");
            out.print(fieldName);
            out.print("\" name=\"");
            out.print(fieldName);
            out.println("\"/>");
            out.println("<input type=\"hidden\" name=\"" + fieldName + "$$id" + "\" id=\"" + fieldName + "_id" + "\" value=\"" + attachmentId + "\"/>");
            out.println("<input type=\"hidden\" id=\"" + fieldName + "Operation" + "\" name=\"" + fieldName + "Operation" + "\" value=\"" + originalOperation.name() + "\"/>");
            boolean useGalleries = Util.getBooleanValue(parameters, "galleries");
            if (useGalleries) {
                this.renderGalleries(originalOperation, fieldName, language, out);
            }
            if (template.isMandatory() && pageContext.useMandatory()) {
                out.println(Util.getMandatorySnippet());
            }
            out.println("</div>");
        }
    }

    private void displayImage(Map<String, String> parameters, String imageURL, PrintWriter out, boolean useOriginalDimension) {
        if (!useOriginalDimension) {
            String height = parameters.containsKey("height") ? parameters.get("height") : "";
            String width = parameters.containsKey("width") ? parameters.get("width") : "";
            String size = width + "x" + height;
            if (size.length() <= 1) {
                size = settings.getString("image.size.xmlform");
            }
            if (StringUtil.isDefined(size)) {
                imageURL = FileServerUtils.getImageURL(imageURL, size);
            }
        }
        out.print("<img alt=\"\" src=\"");
        out.print(imageURL);
        out.print("\"");
        out.print("/>");
    }

    private void renderGalleries(AbstractFileFieldDisplayer.Operation originalOperation, String fieldName, String language, PrintWriter out) {
        String fieldNameFunction = FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'));
        List<ComponentInstLight> galleries = WysiwygController.getGalleries();
        if (galleries != null && !galleries.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ").append(Util.getString("GML.or", language)).append(" ");
            stringBuilder.append("<select id=\"galleryFile_").append(fieldName).append("\" name=\"galleryFile\" onchange=\"openGalleryFileManager").append(fieldNameFunction).append("();this.selectedIndex=0\">");
            stringBuilder.append("<option value=\"\">");
            stringBuilder.append(Util.getString("GML.galleries", language));
            stringBuilder.append("</option>");
            for (ComponentInstLight component : galleries) {
                stringBuilder.append("<option value=\"").append(component.getId()).append("\">").append(component.getLabel(language)).append("</option>");
            }
            stringBuilder.append("</select>");
            out.println(stringBuilder.toString());
            out.println("<script type=\"text/javascript\">");
            GalleryHelper.getJavaScript(fieldNameFunction, fieldName, language, out);
            out.println("function choixImageInGallery" + fieldNameFunction + "(url){");
            out.println("$(\"#" + fieldName + "ThumbnailArea\").css(\"display\", \"block\");");
            out.println("$(\"#" + fieldName + "Thumbnail\").attr(\"src\", url);");
            out.println("$(\"#" + fieldName + "ThumbnailLink\").attr(\"href\", url);");
            out.println("$(\"#" + fieldName + "_id" + "\").attr(\"value\", url);");
            out.println("$(\"#" + fieldName + "Operation" + "\").attr(\"value\", \"" + originalOperation.name() + "\");");
            out.println("}");
            out.println("</script>");
        }
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }
}

