/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.JdbcRefField;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.A;
import org.apache.ecs.html.IMG;
import org.apache.ecs.html.Input;

public class JdbcRefFieldDisplayer
extends AbstractFieldDisplayer<JdbcRefField> {
    @Override
    public void display(PrintWriter out, JdbcRefField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        if (!"jdbcRef".equals(field.getTypeName())) {
            SilverTrace.info("form", "JdbcRefFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "jdbcRef");
        }
        ElementContainer container = new ElementContainer();
        Input input2 = new Input();
        input2.setName(fieldName);
        input2.setID(fieldName);
        input2.setValue(EncodeHelper.javaStringToHtmlString(!field.isNull() ? field.getValue(language) : ""));
        input2.setType("text");
        input2.setSize(50);
        if (template.isDisabled()) {
            input2.setDisabled(true);
        } else if (template.isReadOnly()) {
            input2.setReadOnly(true);
        }
        container.addElement((Element)input2);
        if (template.isMandatory()) {
            container.addElement("&nbsp;");
            IMG img2 = new IMG();
            img2.setSrc(Util.getIcon("mandatoryField"));
            img2.setWidth(5);
            img2.setHeight(5);
            img2.setBorder(0);
            container.addElement((Element)img2);
        }
        container.addElement("&nbsp;");
        A link = new A();
        link.setHref("#");
        StringBuilder onclick = new StringBuilder(200).append("javascript:SP_openWindow('").append(URLManager.getApplicationURL()).append("/RselectionPeas/jsp/Main").append("?SelectionType=JdbcConnector").append("&formIndex=").append(pagesContext.getFormIndex());
        String[] parametersKeys = new String[]{"beanName", "componentId", "method", "tableName"};
        Map<String, String> parameters = template.getParameters(language);
        int n = parametersKeys.length;
        for (int i = 0; i < n; ++i) {
            if (!parameters.containsKey(parametersKeys[i])) continue;
            onclick.append("&").append(parametersKeys[i]).append("=").append(parameters.get(parametersKeys[i]));
        }
        StringTokenizer columnsNamesSt = new StringTokenizer(parameters.get("columnsNames"), "#");
        StringTokenizer fieldsNamesSt = new StringTokenizer(parameters.get("fieldsNames"), "#");
        int index = 0;
        while (columnsNamesSt.hasMoreTokens()) {
            onclick.append("&columnName").append(index).append("=").append(columnsNamesSt.nextToken()).append("&fieldName").append(index).append("=").append(fieldsNamesSt.nextToken());
            ++index;
        }
        onclick.append("', 'win_").append(fieldName).append("', 800, 600, 'scrollbars=yes');");
        link.setOnClick(onclick.toString());
        IMG linkImg = new IMG();
        linkImg.setSrc(Util.getIcon("jdbc"));
        linkImg.setWidth(15);
        linkImg.setHeight(15);
        linkImg.setBorder(0);
        String selectLabel = Util.getString("SelectValue", language);
        linkImg.setAlt(selectLabel);
        linkImg.setTitle(selectLabel);
        linkImg.setAlign("absmiddle");
        link.addElement((Element)linkImg);
        container.addElement((Element)link);
        out.println(container.toString());
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        String label = template.getLabel(language);
        if (!template.getTypeName().equals("jdbcRef")) {
            SilverTrace.info("form", "JdbcRefFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "jdbcRef");
        }
        if (template.isMandatory()) {
            out.println("   if (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("     errorMsg += \"  - '" + label + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";");
            out.println("     errorNb++;");
            out.println("   }");
        }
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public List<String> update(String value, JdbcRefField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"jdbcRef".equals(field.getTypeName())) {
            throw new FormException("JdbcRefFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "jdbcRef");
        }
        if (!field.acceptValue(value, pagesContext.getLanguage())) {
            throw new FormException("JdbcRefFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "jdbcRef");
        }
        field.setValue(value, pagesContext.getLanguage());
        return new ArrayList<String>();
    }
}

