/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.GalleryHelper;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.wysiwyg.dynamicvalue.control.DynamicValueReplacement;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Source;
import org.apache.commons.io.FileUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.util.SimpleDocumentList;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.util.Charsets;
import org.silverpeas.wysiwyg.control.WysiwygContentTransformer;
import org.silverpeas.wysiwyg.control.WysiwygController;

public class WysiwygFCKFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public static final String dbKey = "xmlWysiwygField_";
    public static final String dir = "xmlWysiwyg";
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.wysiwyg.settings.wysiwygSettings", "");

    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
        String fieldName = template.getFieldName();
        String language = PagesContext2.getLanguage();
        if (!"text".equals(template.getTypeName())) {
            SilverTrace.info("form", "WysiwygFCKFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (!template.isReadOnly()) {
            out.println("var oEditor = CKEDITOR.instances." + fieldName + ";");
            out.println("var thecode = oEditor.getData();");
            if (template.isMandatory() && PagesContext2.useMandatory()) {
                out.println(" if (isWhitespace(stripInitialWhitespace(thecode)) || thecode == \"<P>&nbsp;</P>\") {");
                out.println(" errorMsg+=\" - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";");
                out.println(" errorNb++;");
                out.println(" }");
            }
            Util.getJavascriptChecker(template.getFieldName(), PagesContext2, out);
        }
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "WysiwygFCKFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String contentLanguage = I18NHelper.checkLanguage(pageContext.getContentLanguage());
        String code = this.getContent(pageContext.getComponentId(), pageContext.getObjectId(), template.getFieldName(), "useless", contentLanguage);
        if (code == null) {
            ArrayList<String> languages = new ArrayList<String>(I18NHelper.getAllSupportedLanguages());
            languages.remove(contentLanguage);
            for (String lang : languages) {
                code = this.getContent(pageContext.getComponentId(), pageContext.getObjectId(), template.getFieldName(), "useless", lang);
                if (code == null) continue;
                break;
            }
        }
        if (pageContext.isSharingContext()) {
            code = pageContext.getSharingContext().applyOn(code);
        }
        if (template.isDisabled() || template.isReadOnly()) {
            code = WysiwygContentTransformer.on(code).modifyImageUrlAccordingToHtmlSizeDirective().transform();
            if (DynamicValueReplacement.isActivate()) {
                DynamicValueReplacement replacement = new DynamicValueReplacement();
                code = replacement.replaceKeyByValue(code);
            }
            out.println(code);
        } else {
            out.println("<table>");
            if (DynamicValueReplacement.isActivate()) {
                out.println("<tr class=\"TB_Expand\"><td class=\"TB_Expand\" align=\"center\">");
                out.println(DynamicValueReplacement.buildHTMLSelect(pageContext.getLanguage(), fieldName, fieldName));
                out.println("</td></tr>");
            }
            String fieldNameFunction = FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'));
            ResourceLocator resources = new ResourceLocator("org.silverpeas.wysiwyg.multilang.wysiwygBundle", contentLanguage);
            StringBuilder stringBuilder = new StringBuilder();
            List<ComponentInstLight> fileStorage = null;
            boolean showFileStorages = true;
            if (parameters.containsKey("fileStorages")) {
                showFileStorages = StringUtil.getBooleanValue(parameters.get("fileStorages"));
            }
            if (showFileStorages && !(fileStorage = WysiwygController.getStorageFile()).isEmpty()) {
                out.println("<tr class=\"TB_Expand\"><td class=\"TB_Expand\">");
                stringBuilder = new StringBuilder();
                stringBuilder.append("<select id=\"storageFile_").append(fieldName).append("\" name=\"storageFile\" onchange=\"openStorageFileManager").append(FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'))).append("();this.selectedIndex=0\">");
                stringBuilder.append("<option value=\"\">").append(resources.getString("storageFile.select.title")).append("</option>");
                for (ComponentInstLight component : fileStorage) {
                    stringBuilder.append("<option value=\"").append(component.getId()).append("\">").append(component.getLabel(contentLanguage)).append("</option>");
                }
                stringBuilder.append("</select>");
                out.println(stringBuilder.toString());
            }
            List<SimpleDocument> listImages = null;
            if (pageContext.getObjectId() != null && !"useless".equals(pageContext.getComponentId()) && !(listImages = WysiwygController.getImages(pageContext.getObjectId(), pageContext.getComponentId())).isEmpty()) {
                if (fileStorage == null || fileStorage.isEmpty()) {
                    out.println("<tr class=\"TB_Expand\"><td class=\"TB_Expand\">");
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append("<select id=\"images_").append(fieldName).append("\" name=\"images\" onchange=\"choixImage").append(FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'))).append("();this.selectedIndex=0\">");
                stringBuilder.append("<option value=\"\">").append(resources.getString("Image")).append("</option>");
                for (SimpleDocument image : listImages) {
                    stringBuilder.append("<option value=\"").append(URLManager.getApplicationURL() + image.getAttachmentURL()).append("\">").append(image.getFilename()).append("</option>");
                }
                stringBuilder.append("</select>");
                out.println(stringBuilder.toString());
            }
            List<ComponentInstLight> galleries = null;
            boolean showGalleries = true;
            if (parameters.containsKey("galleries")) {
                showGalleries = StringUtil.getBooleanValue(parameters.get("galleries"));
            }
            if (showGalleries && !(galleries = WysiwygController.getGalleries()).isEmpty()) {
                if ((fileStorage == null || fileStorage.isEmpty()) && (listImages == null || listImages.isEmpty())) {
                    out.println("<tr class=\"TB_Expand\"><td class=\"TB_Expand\">");
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append("<select id=\"galleryFile_").append(fieldName).append("\" name=\"galleryFile\" onchange=\"openGalleryFileManager").append(fieldNameFunction).append("();this.selectedIndex=0\">");
                stringBuilder.append("<option value=\"\">").append(Util.getString("GML.galleries", contentLanguage)).append("</option>");
                for (ComponentInstLight component : galleries) {
                    stringBuilder.append("<option value=\"").append(component.getId()).append("\">").append(component.getLabel(contentLanguage)).append("</option>");
                }
                stringBuilder.append("</select>");
                out.println(stringBuilder.toString());
            }
            if (fileStorage != null && !fileStorage.isEmpty() || listImages != null && !listImages.isEmpty() || galleries != null && !galleries.isEmpty()) {
                out.println("</td></tr>");
            }
            out.println("<tr>");
            int editorWidth = 600;
            int editorHeight = 300;
            if (parameters.containsKey("width")) {
                editorWidth = Integer.parseInt(parameters.get("width"));
            }
            if (parameters.containsKey("height")) {
                editorHeight = Integer.parseInt(parameters.get("height"));
            }
            out.println("<td valign=\"top\">");
            out.println("<textarea id=\"" + fieldName + "\" name=\"" + fieldName + "\" rows=\"10\" cols=\"10\">" + code + "</textarea>");
            out.println("<script type=\"text/javascript\">");
            stringBuilder = new StringBuilder();
            String configFile = settings.getString("configFile", URLManager.getApplicationURL() + "/wysiwyg/jsp/ckeditor/silverconfig.js");
            stringBuilder.append("CKEDITOR.replace('").append(fieldName).append("', {\n");
            stringBuilder.append("width : '").append(editorWidth).append("',\n");
            stringBuilder.append("height : ").append(editorHeight).append(",\n");
            stringBuilder.append("language : '").append(pageContext.getLanguage()).append("',\n");
            String basehref = settings.getString("baseHref", pageContext.getServerURL());
            if (StringUtil.isDefined(basehref)) {
                stringBuilder.append("baseHref : '").append(basehref).append("',\n");
            }
            String fileBrowserUrl = Util.getPath() + "/wysiwyg/jsp/uploadFile.jsp?ComponentId=" + pageContext.getComponentId() + "&ObjectId=" + pageContext.getObjectId() + "&Context=" + fieldName;
            stringBuilder.append("filebrowserImageBrowseUrl : '").append(fileBrowserUrl).append("',\n");
            stringBuilder.append("filebrowserFlashBrowseUrl : '").append(fileBrowserUrl).append("',\n");
            stringBuilder.append("filebrowserBrowseUrl : '").append(fileBrowserUrl).append("',\n");
            stringBuilder.append("toolbarStartupExpanded : ").append("false").append(",\n");
            stringBuilder.append("customConfig : '").append(configFile).append("',\n");
            stringBuilder.append("toolbar : '").append("XMLForm").append("',\n");
            String skin = settings.getString("skin");
            if (StringUtil.isDefined(skin)) {
                stringBuilder.append("skin : '").append(skin).append("'\n");
            }
            stringBuilder.append("});");
            out.println(stringBuilder.toString());
            if (DynamicValueReplacement.isActivate()) {
                out.println("function chooseDynamicValues" + fieldNameFunction + "(){");
                out.println(" var oEditor = CKEDITOR.instances['" + fieldName + "'];");
                out.println(" var focusManager = new CKEDITOR.focusManager( oEditor );");
                out.println(" focusManager.focus();");
                out.println("index = document.getElementById(\"dynamicValues_" + fieldName + "\").selectedIndex;");
                out.println("var str = document.getElementById(\"dynamicValues_" + fieldName + "\").options[index].value;");
                out.println("if (index != 0 && str != null){");
                out.println("oEditor.insertHtml('(%'+str+'%)');");
                out.println("} }");
            }
            if (fileStorage != null && !fileStorage.isEmpty()) {
                out.println("var storageFileWindow=window;");
                out.println("function openStorageFileManager" + fieldNameFunction + "(){");
                out.println("index = document.getElementById(\"storageFile_" + fieldName + "\").selectedIndex;");
                out.println("var componentId = document.getElementById(\"storageFile_" + fieldName + "\").options[index].value;");
                out.println("if (index != 0){ ");
                out.println("url = \"" + URLManager.getApplicationURL() + "/kmelia/jsp/attachmentLinkManagement.jsp?key=\"+componentId+\"&ntype=COMPONENT&fieldname=" + fieldNameFunction + "\";");
                out.println("windowName = \"StorageFileWindow\";");
                out.println("width = \"750\";");
                out.println("height = \"580\";");
                out.println("windowParams = \"scrollbars=1,directories=0,menubar=0,toolbar=0, alwaysRaised\";");
                out.println("if (!storageFileWindow.closed && storageFileWindow.name==windowName)");
                out.println("storageFileWindow.close();");
                out.println("storageFileWindow = SP_openWindow(url, windowName, width, height, windowParams);");
                out.println("}}");
                out.println("function insertAttachmentLink" + fieldNameFunction + "(url,img,label){");
                out.println(" var oEditor = CKEDITOR.instances['" + fieldName + "'];");
                out.println(" var focusManager = new CKEDITOR.focusManager( oEditor );");
                out.println(" focusManager.focus();");
                out.println("oEditor.insertHtml('<a href=\"'+url+'\"> <img src=\"'+img+'\" width=\"20\" border=\"0\" alt=\"\"/> '+label+'</a> ');");
                out.println("}");
            }
            if (listImages != null && !listImages.isEmpty()) {
                out.println("function choixImage" + fieldNameFunction + "() {");
                out.println(" var oEditor = CKEDITOR.instances['" + fieldName + "'];");
                out.println(" var focusManager = new CKEDITOR.focusManager( oEditor );");
                out.println(" focusManager.focus();");
                out.println(" var index = document.getElementById(\"images_" + fieldName + "\").selectedIndex;");
                out.println(" var str = document.getElementById(\"images_" + fieldName + "\").options[index].value;");
                out.println(" if (index != 0 && str != null) {");
                out.println("   oEditor.insertHtml('<img border=\"0\" src=\"'+str+'\" alt=\"\"/>');");
                out.println(" }");
                out.println("}");
            }
            if (galleries != null && !galleries.isEmpty()) {
                GalleryHelper.getJavaScript(fieldNameFunction, fieldName, contentLanguage, out);
                out.println("function choixImageInGallery" + fieldNameFunction + "(url){");
                out.println(" var oEditor = CKEDITOR.instances['" + fieldName + "'];");
                out.println(" var focusManager = new CKEDITOR.focusManager( oEditor );");
                out.println(" focusManager.focus();");
                out.println("oEditor.insertHtml('<img src=\"'+url+'\" border=\"0\" alt=\"\"/>');");
                out.println("}");
            }
            out.println("</script>");
            if (template.isMandatory() && pageContext.useMandatory()) {
                out.println(Util.getMandatorySnippet());
            }
            out.println("</td>");
            out.println("</tr>");
            out.println("</table>");
        }
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if (!field.getTypeName().equals("text")) {
            throw new FormException("WysiwygFCKFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (field.acceptValue(newValue, pageContext.getLanguage())) {
            try {
                String contentLanguage = I18NHelper.checkLanguage(pageContext.getContentLanguage());
                String fileName = this.setContentIntoFile(pageContext.getComponentId(), pageContext.getObjectId(), template.getFieldName(), newValue, contentLanguage);
                field.setValue(dbKey + fileName, contentLanguage);
            }
            catch (FormException e) {
                throw new FormException("WysiwygFCKFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", e);
            }
        } else {
            throw new FormException("WysiwygFCKFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }

    @Override
    public void index(FullIndexEntry indexEntry, String key, String fieldName, TextField field, String language, boolean store) {
        String fieldValue = field.getValue();
        String fieldValueIndex = "";
        if (StringUtil.isDefined(fieldValue)) {
            if (fieldValue.startsWith(dbKey)) {
                String file = WysiwygFCKFieldDisplayer.getFile(indexEntry.getComponent(), indexEntry.getObjectId(), fieldName, language);
                try {
                    Source source = new Source((InputStream)new FileInputStream(file));
                    fieldValueIndex = source.getTextExtractor().toString();
                }
                catch (IOException ioex) {
                    SilverTrace.warn("form", "WysiwygFCKFieldDisplayer.index", "form.incorrect_data", "File not found " + file + " " + ioex.getMessage(), ioex);
                }
                indexEntry.addTextContent(fieldValueIndex, language);
            } else {
                indexEntry.addTextContent(fieldValue.trim(), language);
                fieldValueIndex = fieldValue.trim().replaceAll("##", " ");
            }
            indexEntry.addField(key, fieldValueIndex, language, false);
            try {
                String content = WysiwygFCKFieldDisplayer.getContentFromFile(indexEntry.getComponent(), indexEntry.getObjectId(), fieldName, language);
                List<String> embeddedAttachmentIds = WysiwygController.getEmbeddedAttachmentIds(content);
                WysiwygController.indexEmbeddedLinkedFiles(indexEntry, embeddedAttachmentIds);
            }
            catch (UtilException e) {
                SilverTrace.warn("form", "WysiwygFCKFieldDisplayer.index", "form.incorrect_data", "Unable to extract linkes files from object" + indexEntry.getObjectId(), e);
            }
        }
    }

    public String duplicateContent(Field field, FieldTemplate template, ForeignPK from, ForeignPK to, String language) throws FormException {
        String code = field.getStringValue();
        code = this.getContent(from.getInstanceId(), from.getId(), template.getFieldName(), code, language);
        String fileName = this.setContentIntoFile(to.getInstanceId(), to.getId(), template.getFieldName(), code, language);
        return dbKey + fileName;
    }

    public void duplicateContent(Field field, FieldTemplate template, PagesContext pageContext, String newObjectId) throws FormException {
        String contentLanguage = I18NHelper.checkLanguage(pageContext.getContentLanguage());
        String code = field.getStringValue();
        code = this.getContent(pageContext.getComponentId(), pageContext.getObjectId(), template.getFieldName(), code, contentLanguage);
        String fileName = this.setContentIntoFile(pageContext.getComponentId(), newObjectId, template.getFieldName(), code, contentLanguage);
        field.setValue(dbKey + fileName, pageContext.getLanguage());
    }

    private String getContent(String componentId, String objectId, String fieldName, String code, String language) throws FormException {
        try {
            code = WysiwygFCKFieldDisplayer.getContentFromFile(componentId, objectId, fieldName, language);
        }
        catch (UtilException e) {
            throw new FormException("WysiwygFCKFieldDisplayer.getContent", e.getMessage(), e);
        }
        return code;
    }

    private String setContentIntoFile(String componentId, String objectId, String fieldName, String code, String language) {
        try {
            FileRepositoryManager.createAbsolutePath(componentId, dir);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String path = WysiwygFCKFieldDisplayer.getPath(componentId);
        String fileName = WysiwygFCKFieldDisplayer.getFileName(fieldName, objectId, language);
        try {
            FileFolderManager.createFile(path, fileName, code);
        }
        catch (UtilException e) {
            // empty catch block
        }
        return fileName;
    }

    public static String getContentFromFile(String componentId, String objectId, String fieldName) throws UtilException {
        return WysiwygFCKFieldDisplayer.getContentFromFile(componentId, objectId, fieldName, null);
    }

    public static String getContentFromFile(String componentId, String objectId, String fieldName, String language) throws UtilException {
        String fileName = WysiwygFCKFieldDisplayer.getFileName(fieldName, objectId, language);
        String path = WysiwygFCKFieldDisplayer.getPath(componentId);
        return FileFolderManager.getCode(path, fileName);
    }

    private static String getFileName(String fieldName, String objectId) {
        return WysiwygFCKFieldDisplayer.getFileName(fieldName, objectId, null);
    }

    private static String getFileName(String fieldName, String objectId, String language) {
        if (language == null || I18NHelper.isDefaultLanguage(language)) {
            return objectId + "_" + fieldName;
        }
        return objectId + "_" + language + "_" + fieldName;
    }

    public void move(ForeignPK fromPK, ForeignPK toPK) throws IOException {
        this.moveOrCopy(fromPK, toPK, false, null);
    }

    private void moveOrCopy(ForeignPK fromPK, ForeignPK toPK, boolean copy, Map<String, String> oldAndNewFileIds) throws IOException {
        String fromPath = WysiwygFCKFieldDisplayer.getPath(fromPK.getInstanceId());
        String toPath = WysiwygFCKFieldDisplayer.getPath(toPK.getInstanceId());
        File from = new File(fromPath);
        if (from.exists()) {
            List files = (List)FileFolderManager.getAllFile(fromPath);
            for (File file : files) {
                String fileName = file.getName();
                if (!fileName.startsWith(fromPK.getId() + "_")) continue;
                String fieldName = fileName.substring(fromPK.getId().length() + 1);
                File srcFile = new File(fromPath, file.getName());
                File destFile = new File(toPath, WysiwygFCKFieldDisplayer.getFileName(fieldName, toPK.getId()));
                if (copy) {
                    FileUtils.copyFile((File)srcFile, (File)destFile);
                    this.changeImagePath(destFile, fromPK.getInstanceId(), toPK.getInstanceId(), oldAndNewFileIds);
                } else {
                    FileUtils.moveFile((File)srcFile, (File)destFile);
                    this.changeInstanceId(destFile, fromPK.getInstanceId(), toPK.getInstanceId());
                }
                Iterator<String> languages = I18NHelper.getLanguages();
                while (languages.hasNext()) {
                    String language = languages.next();
                    if (!fieldName.startsWith(language + "_")) continue;
                    fieldName = fieldName.substring(3);
                    srcFile = new File(fromPath, file.getName());
                    destFile = new File(toPath, WysiwygFCKFieldDisplayer.getFileName(fieldName, toPK.getId(), language));
                    if (copy) {
                        FileUtils.copyFile((File)srcFile, (File)destFile);
                        this.changeImagePath(destFile, fromPK.getInstanceId(), toPK.getInstanceId(), oldAndNewFileIds);
                        continue;
                    }
                    FileUtils.moveFile((File)srcFile, (File)destFile);
                    this.changeInstanceId(destFile, fromPK.getInstanceId(), toPK.getInstanceId());
                }
            }
        }
    }

    private void changeInstanceId(File file, String from, String to) throws IOException {
        String content = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        String changed = content.replaceAll("/" + from + "/", "/" + to + "/");
        FileUtils.writeStringToFile((File)file, (String)changed, (Charset)Charsets.UTF_8);
    }

    private void changeImagePath(File file, String from, String to, Map<String, String> oldAndNewFileIds) throws IOException {
        String content = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        ForeignPK fromPK = new ForeignPK("unknown", from);
        ForeignPK toPK = new ForeignPK("unknown", to);
        for (String oldId : oldAndNewFileIds.keySet()) {
            fromPK.setId(oldId);
            toPK.setId(oldAndNewFileIds.get(oldId));
            content = this.replaceInternalImageId(content, fromPK, toPK);
        }
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)Charsets.UTF_8);
    }

    private String replaceInternalImageId(String content, ForeignPK oldPK, ForeignPK newPK) {
        String from = "/componentId/" + oldPK.getInstanceId() + "/attachmentId/" + oldPK.getId() + "/";
        String to = "/componentId/" + newPK.getInstanceId() + "/attachmentId/" + newPK.getId() + "/";
        return content.replaceAll(from, to);
    }

    public void cloneContents(ForeignPK fromPK, ForeignPK toPK, Map<String, String> oldAndNewFileIds) throws IOException {
        if (oldAndNewFileIds == null) {
            oldAndNewFileIds = new HashMap<String, String>();
        }
        SimpleDocumentList<SimpleDocument> images = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.image, null);
        for (SimpleDocument image : images) {
            SimpleDocumentPK imageCopyPk = AttachmentServiceFactory.getAttachmentService().copyDocument(image, toPK);
            oldAndNewFileIds.put(image.getId(), imageCopyPk.getId());
        }
        this.moveOrCopy(fromPK, toPK, true, oldAndNewFileIds);
    }

    public void mergeContents(String componentIdFrom, String objectIdFrom, String componentIdTo, String objectIdTo) throws UtilException, IOException {
        String fromPath = WysiwygFCKFieldDisplayer.getPath(componentIdFrom);
        File from = new File(fromPath);
        if (from.exists()) {
            String fileName;
            try {
                FileRepositoryManager.createAbsolutePath(componentIdTo, dir);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            List files = (List)FileFolderManager.getAllFile(fromPath);
            for (File file : files) {
                fileName = file.getName();
                if (!fileName.startsWith(objectIdFrom + "_")) continue;
                String fieldName = fileName.substring(objectIdFrom.length() + 1);
                String fieldContent = WysiwygFCKFieldDisplayer.getContentFromFile(componentIdFrom, objectIdFrom, fieldName);
                this.setContentIntoFile(componentIdTo, objectIdTo, fieldName, fieldContent, null);
                Iterator<String> languages = I18NHelper.getLanguages();
                while (languages.hasNext()) {
                    String language = languages.next();
                    if (!fieldName.startsWith(language + "_")) continue;
                    fieldName = fieldName.substring(3);
                    fieldContent = WysiwygFCKFieldDisplayer.getContentFromFile(componentIdFrom, objectIdFrom, fieldName, language);
                    this.setContentIntoFile(componentIdTo, objectIdTo, fieldName, fieldContent, language);
                }
            }
            for (File file : files) {
                fileName = file.getName();
                if (!fileName.startsWith(objectIdFrom + "_")) continue;
                file.delete();
            }
        }
    }

    public static String getFile(String componentId, String objectId, String fieldName, String language) {
        return WysiwygFCKFieldDisplayer.getPath(componentId) + WysiwygFCKFieldDisplayer.getFileName(fieldName, objectId, language);
    }

    public static void removeContents(ForeignPK pk, List<String> fieldNames, String language) {
        String fromPath = WysiwygFCKFieldDisplayer.getPath(pk.getInstanceId());
        File directory = new File(fromPath);
        if (directory.exists()) {
            for (String fieldName : fieldNames) {
                String filePath = WysiwygFCKFieldDisplayer.getFile(pk.getInstanceId(), pk.getId(), fieldName, language);
                File file = new File(filePath);
                if (file == null || !file.exists()) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private static String getPath(String componentId) {
        String[] dirs = new String[]{dir};
        return FileRepositoryManager.getAbsolutePath(componentId, dirs);
    }
}

