/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.silverpeas.util.Charsets;

public class EncodeHelper {
    public static String javaStringToJsString(String javastring) {
        if (!EncodeHelper.isDefined(javastring)) {
            return "";
        }
        return StringEscapeUtils.escapeEcmaScript((String)javastring);
    }

    public static String javaStringToHtmlString(String javastring) {
        if (!EncodeHelper.isDefined(javastring)) {
            return "";
        }
        return StringEscapeUtils.escapeHtml4((String)javastring).replace("\u0153", "&oelig;");
    }

    public static String javaStringToXmlString(String javastring) {
        return EncodeHelper.escapeXml(javastring);
    }

    public static String escapeXml(String javastring) {
        if (EncodeHelper.isDefined(javastring)) {
            return StringEscapeUtils.escapeXml((String)javastring);
        }
        return "";
    }

    public static String convertWhiteSpacesForHTMLDisplay(String javastring) {
        if (!EncodeHelper.isDefined(javastring)) {
            return "";
        }
        StringBuilder resSB = new StringBuilder(javastring.length() + 10);
        block5: for (int i = 0; i < javastring.length(); ++i) {
            switch (javastring.charAt(i)) {
                case '\n': {
                    resSB.append("<br/>");
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\t': {
                    resSB.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block5;
                }
                default: {
                    resSB.append(javastring.charAt(i));
                }
            }
        }
        return resSB.toString();
    }

    public static String javaStringToHtmlParagraphe(String javastring) {
        String escapedString = EncodeHelper.javaStringToHtmlString(javastring);
        return EncodeHelper.convertWhiteSpacesForHTMLDisplay(escapedString);
    }

    public static String htmlStringToJavaString(String htmlstring) {
        if (!EncodeHelper.isDefined(htmlstring)) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml4((String)htmlstring);
    }

    public static String transformHtmlCode(String text) {
        SilverTrace.info("util", "Encode.transformHtmlCode()", "root.MSG_GEN_PARAM_VALUE", " text recu " + text);
        return StringEscapeUtils.unescapeHtml4((String)text);
    }

    public static String encodeSpecialChar(String javastring) {
        if (!EncodeHelper.isDefined(javastring)) {
            return "";
        }
        return javastring;
    }

    public static String transformStringForBD(String sText) {
        if (!EncodeHelper.isDefined(sText)) {
            return "";
        }
        SilverTrace.info("util", "Encode.transformStringForBD()", "root.MSG_GEN_ENTER_METHOD", " text = " + sText);
        int nStringLength = sText.length();
        StringBuilder resSB = new StringBuilder(nStringLength + 10);
        block4: for (int i = 0; i < nStringLength; ++i) {
            switch (sText.charAt(i)) {
                case '\u20ac': {
                    resSB.append('\u20ac');
                    continue block4;
                }
                case '\u2019': {
                    resSB.append('\'');
                    continue block4;
                }
                default: {
                    resSB.append(sText.charAt(i));
                }
            }
        }
        SilverTrace.info("util", "Encode.transformStringForBD()", "root.MSG_GEN_EXIT_METHOD", " new text = " + resSB.toString());
        return resSB.toString();
    }

    public static String convertHTMLEntities(String text) {
        SilverTrace.debug("util", "Encode.convertHTMLEntities()", "root.MSG_GEN_PARAM_VALUE", " text recu " + text);
        String result = StringEscapeUtils.escapeHtml4((String)text);
        SilverTrace.debug("util", "Encode.convertHTMLEntities()", "root.MSG_GEN_PARAM_VALUE", "text sortant = " + result);
        return result;
    }

    public static String encodeFilename(String filename) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("=?UTF-8?B?");
        buffer.append(DatatypeConverter.printBase64Binary((byte[])filename.getBytes(Charsets.UTF_8)));
        buffer.append("?=");
        return buffer.toString();
    }

    private EncodeHelper() {
    }

    private static boolean isDefined(String text) {
        return text != null && !text.isEmpty();
    }
}

