/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.silverpeas.util.ConfigurationClassLoader;
import com.silverpeas.util.ConfigurationControl;
import com.silverpeas.util.ImageUtil;
import com.silverpeas.util.MetadataExtractor;
import com.silverpeas.util.MimeTypes;
import com.silverpeas.util.OsEnum;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.exception.RelativeFileAccessException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.exec.util.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.util.mail.Mail;

public class FileUtil
implements MimeTypes {
    private static final ResourceLocator MIME_TYPES_EXTENSIONS = new ResourceLocator("org.silverpeas.util.attachment.mime_types", "");
    public static final String CONTEXT_TOKEN = ",";
    public static final String BASE_CONTEXT = "Attachment";
    private static final MimetypesFileTypeMap MIME_TYPES = new MimetypesFileTypeMap();
    private static final String MIME_TYPE_CACHE_KEY_PREFIX = "FileUtil.getMimeType$$";
    private static final ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ConfigurationClassLoader>(){

        @Override
        public ConfigurationClassLoader run() {
            return new ConfigurationClassLoader(FileUtil.class.getClassLoader());
        }
    });

    public static String convertBundleName(String bundle) {
        return bundle.replace("com.silverpeas", "org.silverpeas").replace("com.stratelia.silverpeas", "org.silverpeas").replace("com.stratelia.webactiv", "org.silverpeas");
    }

    public static String convertResourceName(String resource) {
        return resource.replace("com/silverpeas", "org/silverpeas").replace("com/stratelia/silverpeas", "org/silverpeas").replace("com/stratelia/webactiv", "org/silverpeas");
    }

    public static String getMimeType(String fileName) {
        String cacheKey = MIME_TYPE_CACHE_KEY_PREFIX + fileName;
        String cachedMimeType = CacheServiceFactory.getRequestCacheService().get(cacheKey, String.class);
        if (StringUtil.isDefined(cachedMimeType)) {
            return cachedMimeType;
        }
        String mimeType = null;
        String fileExtension = FileRepositoryManager.getFileExtension(fileName).toLowerCase();
        File file = new File(fileName);
        if (file.exists()) {
            try {
                mimeType = MetadataExtractor.getInstance().detectMimeType(file);
            }
            catch (Exception ex) {
                SilverTrace.warn("attachment", "FileUtil", "attachment.MSG_MISSING_MIME_TYPES_PROPERTIES", ex.getMessage(), ex);
            }
        }
        if (!StringUtil.isDefined(mimeType)) {
            try {
                if (MIME_TYPES_EXTENSIONS != null && !fileExtension.isEmpty()) {
                    mimeType = MIME_TYPES_EXTENSIONS.getString(fileExtension);
                }
            }
            catch (MissingResourceException e) {
                SilverTrace.warn("attachment", "FileUtil", "attachment.MSG_MISSING_MIME_TYPES_PROPERTIES", null, e);
            }
        }
        if (!StringUtil.isDefined(mimeType)) {
            mimeType = MIME_TYPES.getContentType(fileName);
        }
        if ("application/xhtml+xml".equalsIgnoreCase(mimeType) || "text/html".equalsIgnoreCase(mimeType)) {
            if (fileExtension.contains("jsp")) {
                mimeType = "text/x-jsp";
            } else if (fileExtension.contains("php")) {
                mimeType = "text/x-php";
            }
        } else if ("application/x-zip-compressed".equalsIgnoreCase(mimeType) || "application/zip".equalsIgnoreCase(mimeType)) {
            if ("jar".equalsIgnoreCase(fileExtension) || "war".equalsIgnoreCase(fileExtension) || "ear".equalsIgnoreCase(fileExtension)) {
                mimeType = "application/java-archive";
            } else if ("3D".equalsIgnoreCase(fileExtension)) {
                mimeType = "application/xview3d-3d";
            }
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        CacheServiceFactory.getRequestCacheService().put(cacheKey, mimeType);
        return mimeType;
    }

    public static String[] getAttachmentContext(String context) {
        if (!StringUtil.isDefined(context)) {
            return new String[]{BASE_CONTEXT};
        }
        StringTokenizer strToken = new StringTokenizer(context, CONTEXT_TOKEN);
        ArrayList<String> folders = new ArrayList<String>(10);
        folders.add(BASE_CONTEXT);
        while (strToken.hasMoreElements()) {
            folders.add(strToken.nextToken().trim());
        }
        return folders.toArray(new String[folders.size()]);
    }

    public static byte[] readFile(File file) throws IOException {
        return FileUtils.readFileToByteArray((File)file);
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, InputStream data) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtils.copy((InputStream)data, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, Reader data) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            IOUtils.copy((Reader)data, (Writer)out);
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    public static ResourceBundle loadBundle(String bundleName, Locale locale) {
        ResourceBundle bundle;
        String name = FileUtil.convertBundleName(bundleName);
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.ROOT;
        }
        try {
            bundle = ResourceBundle.getBundle(name, loc, loader, new ConfigurationControl());
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(bundleName, loc, loader, new ConfigurationControl());
            }
        }
        catch (MissingResourceException mex) {
            bundle = ResourceBundle.getBundle(bundleName, loc, loader, new ConfigurationControl());
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties properties, String resourceName) throws IOException {
        if (StringUtil.isDefined(resourceName) && properties != null) {
            String name = FileUtil.convertResourceName(resourceName);
            InputStream in = loader.getResourceAsStream(name);
            try {
                properties.load(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public static boolean isWindows() {
        return OsEnum.getOS().isWindows();
    }

    public static boolean isSpinfireDocument(String filename) {
        return "application/xview3d-3d".equals(FileUtil.getMimeType(filename));
    }

    public static boolean isArchive(String filename) {
        return ARCHIVE_MIME_TYPES.contains(FileUtil.getMimeType(filename));
    }

    public static boolean isImage(String filename) {
        String mimeType = FileUtil.getMimeType(filename);
        if ("application/octet-stream".equals(mimeType)) {
            return FilenameUtils.isExtension((String)filename.toLowerCase(), (String[])ImageUtil.IMAGE_EXTENTIONS);
        }
        return mimeType.startsWith("image");
    }

    public static boolean isMail(String filename) {
        return FilenameUtils.isExtension((String)filename, (String[])Mail.MAIL_EXTENTIONS);
    }

    public static boolean isPdf(String filename) {
        String mimeType = FileUtil.getMimeType(filename);
        return "application/pdf".equals(mimeType);
    }

    public static boolean isOpenOfficeCompatible(String filename) {
        String mimeType = FileUtil.getMimeType(filename);
        return OPEN_OFFICE_MIME_TYPES.contains(mimeType) || FileUtil.isMsOfficeExtension(mimeType);
    }

    static boolean isMsOfficeExtension(String mimeType) {
        return mimeType.startsWith("application/vnd.ms-word") || mimeType.startsWith("application/vnd.ms-excel") || mimeType.startsWith("application/vnd.ms-powerpoint");
    }

    public static void checkPathNotRelative(String path) throws RelativeFileAccessException {
        String unixPath = FilenameUtils.separatorsToUnix((String)path);
        if (unixPath != null && (unixPath.contains("../") || unixPath.contains("/.."))) {
            throw new RelativeFileAccessException();
        }
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean recursive) {
        return FileUtils.listFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean caseSensitive, boolean recursive) {
        IOFileFilter filter;
        if (caseSensitive) {
            return FileUtil.listFiles(directory, extensions, recursive);
        }
        if (extensions == null) {
            filter = TrueFileFilter.INSTANCE;
        } else {
            String[] suffixes = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                suffixes[i] = "." + extensions[i];
            }
            filter = new SuffixFileFilter(suffixes, IOCase.INSENSITIVE);
        }
        return FileUtils.listFiles((File)directory, (IOFileFilter)filter, (IOFileFilter)(recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
    }

    public static void forceDeletion(File fileToDelete) throws IOException {
        if (fileToDelete.exists() && !fileToDelete.canWrite()) {
            fileToDelete.setWritable(true);
        }
        FileUtils.forceDelete((File)fileToDelete);
    }

    public static void moveFile(File source, File destination) throws IOException {
        if (destination.exists()) {
            FileUtils.forceDelete((File)destination);
        }
        FileUtils.moveFile((File)source, (File)destination);
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            destination.setWritable(true);
        }
        FileUtils.copyFile((File)source, (File)destination);
    }

    public static String getFilename(String fileName) {
        if (!StringUtil.isDefined(fileName)) {
            return "";
        }
        return FilenameUtils.getName((String)fileName);
    }

    private FileUtil() {
    }

    public static String convertPathToServerOS(String undeterminedOsPath) {
        if (undeterminedOsPath == null || !StringUtil.isDefined(undeterminedOsPath)) {
            return "";
        }
        String localPath = undeterminedOsPath;
        localPath = localPath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return localPath;
    }

    public static String convertFilePath(File file) {
        if (OsEnum.getOS().isWindows()) {
            return StringUtils.quoteArgument((String)file.getAbsolutePath());
        }
        String path = file.getAbsolutePath();
        path = path.replaceAll("\\\\", "\\\\\\\\");
        path = path.replaceAll("\\s", "\\\\ ");
        path = path.replaceAll("<", "\\\\<");
        path = path.replaceAll(">", "\\\\>");
        path = path.replaceAll("'", "\\\\'");
        path = path.replaceAll("\"", "\\\\\"");
        path = path.replaceAll("\\{", "\\\\{");
        path = path.replaceAll("}", "\\\\}");
        path = path.replaceAll("\\(", "\\\\(");
        path = path.replaceAll("\\)", "\\\\)");
        path = path.replaceAll("\\[", "\\\\[");
        path = path.replaceAll("\\]", "\\\\]");
        path = path.replaceAll("\\&", "\\\\&");
        path = path.replaceAll("\\|", "\\\\|");
        return path;
    }

    public static boolean deleteEmptyDir(File directory) {
        if (directory.exists() && directory.isDirectory() && directory.list() != null && directory.list().length == 0) {
            return directory.delete();
        }
        return false;
    }

    public static File[] moveAllFilesAtRootFolder(File rootFolder) throws IOException {
        return FileUtil.moveAllFilesAtRootFolder(rootFolder, true);
    }

    public static File[] moveAllFilesAtRootFolder(File rootFolder, boolean deleteFolders) throws IOException {
        File[] foldersAtRoot;
        File[] fileArray = foldersAtRoot = rootFolder != null ? rootFolder.listFiles((FileFilter)FileFilterUtils.directoryFileFilter()) : null;
        if (foldersAtRoot != null) {
            for (File folderAtRoot : foldersAtRoot) {
                for (File file : FileUtils.listFiles((File)folderAtRoot, (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.trueFileFilter())) {
                    File newFilePath = new File(rootFolder, file.getName());
                    if (newFilePath.exists()) continue;
                    FileUtils.moveFile((File)file, (File)newFilePath);
                }
                if (!deleteFolders) continue;
                FileUtils.deleteQuietly((File)folderAtRoot);
            }
        }
        return foldersAtRoot != null ? foldersAtRoot : new File[]{};
    }

    public static String validateFilename(String fileName, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File f = new File(fileName);
        String canonicalPath = f.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        throw new IllegalStateException("File is outside extraction target directory (security)");
    }

    public static boolean isFileSecure(String fileName, String intendedDir) {
        boolean result = false;
        try {
            FileUtil.validateFilename(fileName, intendedDir);
            result = true;
        }
        catch (Exception e) {
            SilverTrace.warn("fileutil", "FileUtil.isFileSecure", "Security alert on " + fileName);
        }
        return result;
    }
}

