/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class ImageUtil {
    public static final String BMP_IMAGE_EXTENSION = "bmp";
    public static final String GIF_IMAGE_EXTENSION = "gif";
    public static final String JPG_IMAGE_EXTENSION = "jpg";
    public static final String JPEG_IMAGE_EXTENSION = "jpeg";
    public static final String PCD_IMAGE_EXTENSION = "pcd";
    public static final String PNG_IMAGE_EXTENSION = "png";
    public static final String PSD_IMAGE_EXTENSION = "psd";
    public static final String TGA_IMAGE_EXTENSION = "tga";
    public static final String TIF_IMAGE_EXTENSION = "tif";
    public static final String[] IMAGE_EXTENTIONS = new String[]{"bmp", "gif", "jpg", "jpeg", "pcd", "png", "tga", "tif"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWidthAndHeightByWidth(File image, int widthParam) {
        String[] result = new String[2];
        if (image != null && image.isFile()) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(image));
                String[] stringArray = ImageUtil.getWidthAndHeightByWidth(in, widthParam);
                IOUtils.closeQuietly((InputStream)in);
                return stringArray;
            }
            catch (Exception e) {
                if (image != null) {
                    SilverTrace.error("util", "ImageUtil.getWidthAndHeightByWidth", "root.MSG_GEN_ERROR", "File not found : " + image.getAbsolutePath());
                }
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        result[0] = "";
        result[1] = "";
        return result;
    }

    public static String[] getWidthAndHeightByWidth(InputStream image, int widthParam) {
        String[] result = new String[2];
        try {
            double height;
            double width;
            BufferedImage inputBuf = ImageIO.read(image);
            if (inputBuf.getWidth() > widthParam) {
                double inputBufWidth = inputBuf.getWidth();
                double inputBufHeight = inputBuf.getHeight();
                width = widthParam;
                double ratio = inputBufWidth / width;
                height = inputBufHeight / ratio;
            } else {
                width = inputBuf.getWidth();
                height = inputBuf.getHeight();
            }
            String sWidth = Double.toString(width);
            String sHeight = Double.toString(height);
            result[0] = sWidth.substring(0, sWidth.indexOf(46));
            result[1] = sHeight.substring(0, sHeight.indexOf(46));
            return result;
        }
        catch (Exception e) {
            if (image != null) {
                SilverTrace.error("util", "ImageUtil.getWidthAndHeightByWidth", "root.MSG_GEN_ERROR", e);
            }
            result[0] = "";
            result[1] = "";
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWidthAndHeightByHeight(File image, int heightParam) {
        String[] result = new String[2];
        if (image != null && image.isFile()) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(image));
                String[] stringArray = ImageUtil.getWidthAndHeightByHeight(in, heightParam);
                IOUtils.closeQuietly((InputStream)in);
                return stringArray;
            }
            catch (Exception e) {
                if (image != null) {
                    SilverTrace.error("util", "ImageUtil.getWidthAndHeightByHeight", "root.MSG_GEN_ERROR", "File not found : " + image.getAbsolutePath());
                }
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        result[0] = "";
        result[1] = "";
        return result;
    }

    public static String[] getWidthAndHeightByHeight(InputStream image, int heightParam) {
        String[] result = new String[2];
        try {
            double width;
            double height;
            BufferedImage inputBuf = ImageIO.read(image);
            if (inputBuf.getHeight() > heightParam) {
                double inputBufHeight = inputBuf.getHeight();
                double inputBufWidth = inputBuf.getWidth();
                height = heightParam;
                double ratio = inputBufHeight / height;
                width = inputBufWidth / ratio;
            } else {
                height = inputBuf.getHeight();
                width = inputBuf.getWidth();
            }
            String sWidth = Double.toString(width);
            String sHeight = Double.toString(height);
            result[0] = sWidth.substring(0, sWidth.indexOf(46));
            result[1] = sHeight.substring(0, sHeight.indexOf(46));
            return result;
        }
        catch (Exception e) {
            SilverTrace.error("util", "ImageUtil.getWidthAndHeightByHeight", "root.MSG_GEN_ERROR", e);
            return result;
        }
    }

    public static String[] getWidthAndHeight(InputStream image) {
        String[] result = new String[2];
        try {
            BufferedImage inputBuf = ImageIO.read(image);
            double inputBufWidth = inputBuf.getWidth();
            double inputBufHeight = inputBuf.getHeight();
            String sWidth = Double.toString(inputBufWidth);
            String sHeight = Double.toString(inputBufHeight);
            result[0] = sWidth.substring(0, sWidth.indexOf(46));
            result[1] = sHeight.substring(0, sHeight.indexOf(46));
            return result;
        }
        catch (Exception e) {
            if (image != null) {
                SilverTrace.error("util", "ImageUtil.getWidthAndHeightByHeight", "root.MSG_GEN_ERROR", e);
            }
            result[0] = "";
            result[1] = "";
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWidthAndHeight(File image) {
        String[] result = new String[2];
        if (image != null && image.isFile()) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(image));
                String[] stringArray = ImageUtil.getWidthAndHeight(in);
                IOUtils.closeQuietly((InputStream)in);
                return stringArray;
            }
            catch (Exception e) {
                if (image != null) {
                    SilverTrace.error("util", "ImageUtil.getWidthAndHeight", "root.MSG_GEN_ERROR", "File not found : " + image.getAbsolutePath());
                }
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        result[0] = "";
        result[1] = "";
        return result;
    }
}

