/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;

public class MapUtil {
    public static <K, V> Collection<V> putAddAll(Class<? extends Collection> collectionClass, Map<K, Collection<V>> map, K key, Collection<V> values) {
        Collection<Object> result = null;
        if (values != null && !values.isEmpty()) {
            for (V value : values) {
                result = MapUtil.putAdd(collectionClass, map, key, value);
            }
        } else {
            result = MapUtil.putAdd(collectionClass, map, key, null);
        }
        return result;
    }

    public static <K, V> Collection<V> putAdd(Class<? extends Collection> collectionClass, Map<K, Collection<V>> map, K key, V value) {
        Collection result;
        if (map == null) {
            map = new LinkedHashMap<K, Collection<V>>();
        }
        if ((result = map.get(key)) == null) {
            try {
                result = collectionClass.newInstance();
            }
            catch (Exception myException) {
                throw new IllegalArgumentException(myException);
            }
            map.put(key, result);
        }
        result.add(value);
        return result;
    }

    public static <K, V> List<V> putAddAllList(Map<K, List<V>> map, K key, Collection<V> values) {
        return MapUtil.putAddAllList(ArrayList.class, map, key, values);
    }

    public static <K, V> List<V> putAddList(Map<K, List<V>> map, K key, V value) {
        return MapUtil.putAddList(ArrayList.class, map, key, value);
    }

    public static <K, V> Set<V> putAddAllSet(Map<K, Set<V>> map, K key, Collection<V> values) {
        return MapUtil.putAddAllSet(HashSet.class, map, key, values);
    }

    public static <K, V> Set<V> putAddSet(Map<K, Set<V>> map, K key, V value) {
        return MapUtil.putAddSet(HashSet.class, map, key, value);
    }

    public static <K, V> List<V> putAddAllList(Class<? extends List> listClass, Map<K, List<V>> map, K key, Collection<V> values) {
        List<Object> result = null;
        if (values != null && !values.isEmpty()) {
            for (V value : values) {
                result = MapUtil.putAddList(listClass, map, key, value);
            }
        } else {
            result = MapUtil.putAddList(listClass, map, key, null);
        }
        return result;
    }

    public static <K, V> List<V> putAddList(Class<? extends List> listClass, Map<K, List<V>> map, K key, V value) {
        List result;
        if (map == null) {
            map = new LinkedHashMap<K, List<V>>();
        }
        if ((result = map.get(key)) == null) {
            try {
                result = listClass.newInstance();
            }
            catch (Exception myException) {
                throw new IllegalArgumentException(myException);
            }
            map.put(key, result);
        }
        result.add(value);
        return result;
    }

    public static <K, V> Set<V> putAddAllSet(Class<? extends Set> setClass, Map<K, Set<V>> map, K key, Collection<V> values) {
        Set<Object> result = null;
        if (values != null && !values.isEmpty()) {
            for (V value : values) {
                result = MapUtil.putAddSet(setClass, map, key, value);
            }
        } else {
            result = MapUtil.putAddSet(setClass, map, key, null);
        }
        return result;
    }

    public static <K, V> Set<V> putAddSet(Class<? extends Set> setClass, Map<K, Set<V>> map, K key, V value) {
        Set result;
        if (map == null) {
            map = new LinkedHashMap<K, Set<V>>();
        }
        if ((result = map.get(key)) == null) {
            try {
                result = setClass.newInstance();
            }
            catch (Exception myException) {
                throw new IllegalArgumentException(myException);
            }
            map.put(key, result);
        }
        result.add(value);
        return result;
    }

    public static <K, V> List<V> removeValueList(Map<K, List<V>> map, K key, V value) {
        List<V> result = null;
        if (map != null && (result = map.get(key)) != null) {
            result.remove(value);
        }
        return result;
    }

    public static <K, V> Set<V> removeValueSet(Map<K, Set<V>> map, K key, V value) {
        Set<V> result = null;
        if (map != null && (result = map.get(key)) != null) {
            result.remove(value);
        }
        return result;
    }

    public static <K, V> boolean equals(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        HashMap<K, V> onlyOnRight = new HashMap<K, V>(right);
        for (Map.Entry<K, V> entry : left.entrySet()) {
            K leftKey = entry.getKey();
            V leftValue = entry.getValue();
            if (right.containsKey(leftKey)) {
                Object rightValue = onlyOnRight.remove(leftKey);
                if (ObjectUtils.equals(leftValue, rightValue)) continue;
                return false;
            }
            return false;
        }
        return onlyOnRight.isEmpty();
    }
}

