/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.persistence;

import com.silverpeas.util.persistence.DateParameter;
import com.silverpeas.util.persistence.ObjectParameter;
import com.silverpeas.util.persistence.TypedParameter;
import java.util.Date;
import java.util.List;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;

public class TypedParameterUtil {
    public static String addNamedParameter(List<TypedParameter<?>> parameters, String name, Object value) {
        return TypedParameterUtil.addNamedParameter(parameters, name, value, null);
    }

    public static String addNamedParameter(List<TypedParameter<?>> parameters, String name, Object value, TemporalType temporalType) {
        if (value instanceof Date && temporalType != null) {
            parameters.add(new DateParameter(name, (Date)value, temporalType));
        } else {
            parameters.add(new ObjectParameter(name, value));
        }
        return name;
    }

    public static void computeNamedParameters(TypedQuery<?> typedQuery, List<TypedParameter<?>> parameters) {
        for (TypedParameter<?> typeParameter : parameters) {
            if (typeParameter instanceof DateParameter) {
                DateParameter dateParameter = (DateParameter)typeParameter;
                typedQuery.setParameter(dateParameter.getName(), (Date)dateParameter.getValue(), dateParameter.getTemporalType());
                continue;
            }
            typedQuery.setParameter(typeParameter.getName(), typeParameter.getValue());
        }
    }
}

