/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPEntry;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPTimeStamp;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSettings;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSynchroCache;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainDriver;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import java.util.ArrayList;
import java.util.Arrays;
import org.silverpeas.admin.user.constant.UserState;

public class LDAPUser {
    LDAPSettings driverSettings = null;
    LDAPSynchroCache synchroCache = null;
    private StringBuffer synchroReport = null;
    boolean synchroInProcess = false;
    protected DomainDriver driverParent = null;

    public void init(LDAPSettings driverSettings, DomainDriver driverParent, LDAPSynchroCache synchroCache) {
        this.driverSettings = driverSettings;
        this.driverParent = driverParent;
        this.synchroCache = synchroCache;
    }

    public void beginSynchronization() throws Exception {
        this.synchroReport = new StringBuffer();
        this.synchroInProcess = true;
    }

    public String endSynchronization() throws Exception {
        this.synchroInProcess = false;
        return this.synchroReport.toString();
    }

    public UserDetail[] getAllUsers(String lds, String extraFilter) throws AdminException {
        String theFilter = extraFilter != null && extraFilter.length() > 0 ? "(&" + extraFilter + this.driverSettings.getUsersFullFilter() + ")" : this.driverSettings.getUsersFullFilter();
        SilverTrace.info("admin", "LDAPUser.getAllUsers()", "root.MSG_GEN_PARAM_VALUE", "User Search : " + this.driverSettings.getLDAPUserBaseDN() + " scope : " + Integer.toString(this.driverSettings.getScope()) + " filter : " + theFilter);
        SynchroReport.info("LDAPUser.getAllUsers()", "Recherche des utilisateurs du domaine LDAP distant...", null);
        ArrayList<UserDetail> usersVector = new ArrayList<UserDetail>();
        LDAPEntry[] theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), theFilter, this.driverSettings.getUsersLoginField(), this.driverSettings.getUserAttributes());
        for (int i = 0; i < theEntries.length; ++i) {
            SilverTrace.info("admin", "LDAPUser.getAllUsers()", "root.MSG_GEN_PARAM_VALUE", "User Found !!!");
            usersVector.add(this.translateUser(lds, theEntries[i]));
            SilverTrace.info("admin", "LDAPUser.getAllUsers()", "root.MSG_GEN_PARAM_VALUE", "User " + i + " : " + ((UserDetail)usersVector.get(i)).getLogin());
            ((UserDetail)usersVector.get(i)).traceUser();
            SynchroReport.debug("LDAPUser.getAllUsers()", "Utilisateur trouv\u00e9 no : " + i + ", login : " + ((UserDetail)usersVector.get(i)).getLogin() + ", " + ((UserDetail)usersVector.get(i)).getFirstName() + ", " + ((UserDetail)usersVector.get(i)).getLastName() + ", " + ((UserDetail)usersVector.get(i)).geteMail(), null);
        }
        SynchroReport.info("LDAPUser.getAllUsers()", "R\u00e9cup\u00e9ration de " + theEntries.length + " utilisateurs du domaine LDAP distant", null);
        return usersVector.toArray(new UserDetail[usersVector.size()]);
    }

    public UserFull getUserFull(String lds, String id, int domainId) throws AdminException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        String[] userAttributes = this.driverSettings.getUserAttributes();
        if (userAttributes != null && userAttributes.length > 0) {
            lAttrs.addAll(Arrays.asList(userAttributes));
            if (this.driverParent.getMapParameters() != null) {
                lAttrs.addAll(Arrays.asList(this.driverParent.getMapParameters()));
            }
        }
        SilverTrace.info("admin", "LDAPUser.getUser()", "root.MSG_GEN_PARAM_VALUE", "User Search : " + this.driverSettings.getLDAPUserBaseDN() + " scope : " + Integer.toString(this.driverSettings.getScope()) + " filter : " + this.driverSettings.getUsersIdFilter(id));
        LDAPEntry theEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(id), lAttrs.toArray(new String[lAttrs.size()]));
        return this.translateUserFull(lds, theEntry, domainId);
    }

    public UserDetail getUser(String lds, String id) throws AdminException {
        LDAPEntry theEntry = null;
        SilverTrace.info("admin", "LDAPUser.getUser()", "root.MSG_GEN_PARAM_VALUE", "User Search : " + this.driverSettings.getLDAPUserBaseDN() + " scope : " + Integer.toString(this.driverSettings.getScope()) + " filter : " + this.driverSettings.getUsersIdFilter(id));
        theEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(id), this.driverSettings.getUserAttributes());
        return this.translateUser(lds, theEntry);
    }

    public UserDetail getUserByLogin(String lds, String loginUser) throws AdminException {
        LDAPEntry theEntry = null;
        SilverTrace.info("admin", "LDAPUser.getUser()", "root.MSG_GEN_PARAM_VALUE", "User Search : " + this.driverSettings.getLDAPUserBaseDN() + " scope : " + Integer.toString(this.driverSettings.getScope()) + " filter : " + this.driverSettings.getUsersLoginFilter(loginUser));
        theEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersLoginFilter(loginUser), this.driverSettings.getUserAttributes());
        return this.translateUser(lds, theEntry);
    }

    private void translateCommonUserData(LDAPEntry ldapUser, UserDetail silverpeasDistantUser) {
        silverpeasDistantUser.setSpecificId(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersIdField()));
        silverpeasDistantUser.setLogin(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersLoginField()));
        silverpeasDistantUser.setFirstName(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersFirstNameField()));
        silverpeasDistantUser.setLastName(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersLastNameField()));
        silverpeasDistantUser.seteMail(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersEmailField()));
        silverpeasDistantUser.setAccessLevel(null);
        String userAccountControlAttribute = this.driverSettings.getUsersAccountControl();
        String disabledUserAccountFlag = this.driverSettings.getUsersDisabledAccountFlag();
        if (StringUtil.isDefined(userAccountControlAttribute) && StringUtil.isDefined(disabledUserAccountFlag)) {
            String usersAccountControl = LDAPUtility.getFirstAttributeValue(ldapUser, userAccountControlAttribute);
            if (!StringUtil.isDefined(usersAccountControl)) {
                usersAccountControl = "";
            }
            if (StringUtil.isLong(usersAccountControl)) {
                if (StringUtil.isLong(disabledUserAccountFlag)) {
                    long disabledUserAccountFlagAsLong;
                    long currentAccountControlFlags = Long.valueOf(usersAccountControl);
                    if ((currentAccountControlFlags & (disabledUserAccountFlagAsLong = Long.valueOf(disabledUserAccountFlag).longValue())) == disabledUserAccountFlagAsLong) {
                        silverpeasDistantUser.setState(UserState.DEACTIVATED);
                    } else {
                        silverpeasDistantUser.setState(UserState.VALID);
                    }
                }
            } else if (usersAccountControl.matches("(?i)(.*[ ;,|]+|)" + disabledUserAccountFlag + "([ ;,|]+.*|)")) {
                silverpeasDistantUser.setState(UserState.DEACTIVATED);
            } else {
                silverpeasDistantUser.setState(UserState.VALID);
            }
        }
    }

    private UserFull translateUserFull(String lds, LDAPEntry userEntry, int domainId) throws AdminException {
        UserFull userInfos = new UserFull(this.driverParent);
        String subUserDN = null;
        LDAPEntry subUserEntry = null;
        String[] keys = this.driverParent.getPropertiesNames();
        this.translateCommonUserData(userEntry, userInfos);
        for (int i = 0; i < keys.length; ++i) {
            DomainProperty curProp = this.driverParent.getProperty(keys[i]);
            if ("USERID".equals(curProp.getType())) {
                subUserDN = LDAPUtility.getFirstAttributeValue(userEntry, curProp.getMapParameter());
                if (subUserDN == null || subUserDN.length() <= 0) continue;
                try {
                    subUserEntry = LDAPUtility.getFirstEntryFromSearch(lds, subUserDN, 0, this.driverSettings.getUsersFullFilter(), this.driverSettings.getUserAttributes());
                }
                catch (AdminException e) {
                    SilverTrace.warn("admin", "LDAPUser.translateUser", "admin.EX_ERR_BOSS_NOT_FOUND", "subUserDN=" + subUserDN, e);
                    if (this.synchroInProcess) {
                        this.synchroReport.append("PB getting BOSS infos : ").append(subUserDN).append("\n");
                    }
                    subUserEntry = null;
                }
                if (subUserEntry == null) continue;
                String login = LDAPUtility.getFirstAttributeValue(subUserEntry, this.driverSettings.getUsersLoginField());
                AdminController admin = new AdminController(null);
                String anotherUserId = admin.getUserIdByLoginAndDomain(login, String.valueOf(domainId));
                userInfos.setValue(curProp.getName(), anotherUserId);
                continue;
            }
            if (StringUtil.isDefined(curProp.getRedirectOU()) && StringUtil.isDefined(curProp.getRedirectAttribute())) {
                String filter;
                String baseDN;
                String cn = LDAPUtility.getFirstAttributeValue(userEntry, curProp.getMapParameter());
                if (!StringUtil.isDefined(cn) || (subUserEntry = LDAPUtility.getFirstEntryFromSearch(lds, baseDN = curProp.getRedirectOU(), 2, filter = "(cn=" + cn + ")", this.driverSettings.getUserAttributes())) == null) continue;
                userInfos.setValue(curProp.getName(), LDAPUtility.getFirstAttributeValue(subUserEntry, curProp.getRedirectAttribute()));
                continue;
            }
            userInfos.setValue(curProp.getName(), LDAPUtility.getFirstAttributeValue(userEntry, curProp.getMapParameter()));
        }
        return userInfos;
    }

    public UserDetail translateUser(String lds, LDAPEntry userEntry) throws AdminException {
        UserDetail userInfos = new UserDetail();
        if (userEntry == null) {
            throw new AdminException("LDAPUser.translateUser", 4, "admin.EX_ERR_LDAP_USER_ENTRY_ISNULL");
        }
        this.translateCommonUserData(userEntry, userInfos);
        this.synchroCache.addUser(userEntry);
        return userInfos;
    }

    public AbstractLDAPTimeStamp getMaxTimeStamp(String lds, String minTimeStamp) throws AdminException {
        AbstractLDAPTimeStamp theTimeStamp = this.driverSettings.newLDAPTimeStamp(minTimeStamp);
        theTimeStamp.initFromServer(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getUsersLoginField());
        return theTimeStamp;
    }

    public String[] getUserAttributes() {
        ArrayList<String> lAttrs = new ArrayList<String>();
        String[] userAttributes = this.driverSettings.getUserAttributes();
        if (userAttributes != null) {
            lAttrs.addAll(Arrays.asList(userAttributes));
            if (this.driverParent.getMapParameters() != null) {
                lAttrs.addAll(Arrays.asList(this.driverParent.getMapParameters()));
            }
        }
        return lAttrs.toArray(new String[lAttrs.size()]);
    }
}

