/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationserver.xml;

import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationTag;
import com.stratelia.silverpeas.notificationserver.xml.TargetNameContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.TargetParamContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.TargetReceiptContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TargetContentHandler
extends DefaultHandler {
    private NotificationData data;
    private ContentHandler parent;
    private XMLReader parser;

    public TargetContentHandler(NotificationData data, ContentHandler parent, XMLReader parser) {
        this.data = data;
        this.parent = parent;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        DefaultHandler child = null;
        switch (tag) {
            case TARGET: {
                this.data.setTargetChannel(attributes.getValue(NotificationTag.CHANNEL.toString()));
                break;
            }
            case NAME: {
                child = new TargetNameContentHandler(this.data, this, this.parser);
                this.parser.setContentHandler(child);
                break;
            }
            case RECEIPT: {
                child = new TargetReceiptContentHandler(this.data, this, this.parser);
                this.parser.setContentHandler(child);
                break;
            }
            case PARAM: {
                child = new TargetParamContentHandler(this.data, this, this.parser);
                this.parser.setContentHandler(child);
            }
        }
        if (child != null) {
            this.parser.setContentHandler(child);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        if (tag == NotificationTag.TARGET) {
            this.parser.setContentHandler(this.parent);
        }
    }
}

