/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.admin.components.PasteDetail;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.admin.spaces.SpaceTemplate;
import com.silverpeas.util.ArrayUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminGroupInst;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.GroupProfileInst;
import com.stratelia.webactiv.beans.admin.GroupSynchronizationRule;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.RightAssignationContext;
import com.stratelia.webactiv.beans.admin.SpaceAndChildren;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.beans.admin.UserLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.quota.exception.QuotaException;

public class AdminController
implements Serializable {
    private static final long serialVersionUID = -1605341557688427460L;
    String m_UserId = null;

    public AdminController(String sUserId) {
        this.m_UserId = sUserId;
    }

    public void startServer() throws Exception {
        AdminReference.getAdminService().startServer();
    }

    public String getGeneralSpaceId() {
        SilverTrace.info("admin", "AdminController.getGeneralSpaceId", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGeneralSpaceId();
        }
        catch (Exception e) {
            SilverTrace.fatal("admin", "AdminController.getGeneralSpaceId", "admin.MSG_FATAL_GET_GENERAL_SPACE_ID", e);
            return "";
        }
    }

    public boolean isSpaceInstExist(String sClientSpaceId) {
        SilverTrace.info("admin", "AdminController.isSpaceInstExist", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().isSpaceInstExist(sClientSpaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isSpaceInstExist", "admin.MSG_ERR_IS_SPACE_EXIST", e);
            return false;
        }
    }

    public SpaceInst getSpaceInstById(String sSpaceId) {
        SilverTrace.info("admin", "AdminController.getSpaceInstById", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getSpaceInstById(sSpaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getSpaceInstById", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public SpaceInstLight getSpaceInstLight(String sSpaceId) {
        SilverTrace.info("admin", "AdminController.getSpaceInstLight", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getSpaceInstLightById(sSpaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getSpaceInstLight", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public Map<String, SpaceAndChildren> getTreeView(String userId, String spaceId) {
        SilverTrace.info("admin", "AdminController.getTreeView", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getTreeView(userId, spaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getTreeView", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public List<SpaceInstLight> getPathToComponent(String componentId) {
        SilverTrace.info("admin", "AdminController.getPathToComponent", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getPathToComponent(componentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getPathToComponent", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public List<SpaceInstLight> getPathToSpace(String spaceId, boolean includeTarget) {
        SilverTrace.info("admin", "AdminController.getPathToSpace", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getPathToSpace(spaceId, includeTarget);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getPathToSpace", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public String[] getUserManageableSpaceRootIds(String sUserId) {
        SilverTrace.info("admin", "AdminController.getUserManageableSpaceRootIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserManageableSpaceRootIds(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserManageableSpaceRootIds", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public String[] getUserManageableSubSpaceIds(String sUserId, String sParentSpace) {
        SilverTrace.info("admin", "AdminController.getUserManageableSubSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserManageableSubSpaceIds(sUserId, sParentSpace);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserManageableSubSpaceIds", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public String[] getUserManageableSpaceIds(String sUserId) {
        SilverTrace.info("admin", "AdminController.getUserManageableSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserManageableSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserManageableSpaceIds", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public String[] getUserManageableSpaceClientIds(String sUserId) {
        SilverTrace.info("admin", "AdminController.getUserManageableSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            UserDetail user = AdminReference.getAdminService().getUserDetail(sUserId);
            if (user.isAccessAdmin() || sUserId.equals("0")) {
                return AdminReference.getAdminService().getClientSpaceIds(AdminReference.getAdminService().getAllSpaceIds());
            }
            return AdminReference.getAdminService().getClientSpaceIds(AdminReference.getAdminService().getUserManageableSpaceIds(sUserId));
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserManageableSpaceClientIds", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public String addSpaceInst(SpaceInst spaceInst) {
        SilverTrace.info("admin", "AdminController.addSpaceInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addSpaceInst(this.m_UserId, spaceInst);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addSpaceInst", "admin.MSG_ERR_ADD_SPACE", e);
            return "";
        }
    }

    public String deleteSpaceInstById(String sSpaceInstId, boolean definitive) {
        SilverTrace.info("admin", "AdminController.deleteSpaceInstById", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteSpaceInstById(this.m_UserId, sSpaceInstId, definitive);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteSpaceInstById", "admin.MSG_ERR_DELETE_SPACE", e);
            return "";
        }
    }

    public String updateSpaceInst(SpaceInst spaceInstNew) {
        SilverTrace.info("admin", "AdminController.updateSpaceInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateSpaceInst(spaceInstNew);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateSpaceInst", "admin.MSG_ERR_UPDATE_SPACE", e);
            return "";
        }
    }

    public Map<String, SpaceTemplate> getAllSpaceTemplates() {
        return AdminReference.getAdminService().getAllSpaceTemplates();
    }

    public SpaceInst getSpaceInstFromTemplate(String templateName) {
        return AdminReference.getAdminService().getSpaceInstFromTemplate(templateName);
    }

    public String[] getAllRootSpaceIds() {
        SilverTrace.info("admin", "AdminController.getAllSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllRootSpaceIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllSpaceIds", "admin.MSG_ERR_GET_ALL_SPACE_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllSpaceIds() {
        SilverTrace.info("admin", "AdminController.getAllSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllSpaceIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllSpaceIds", "admin.MSG_ERR_GET_ALL_SPACE_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllSpaceIds(String userId) {
        SilverTrace.info("admin", "AdminController.getAllSpaceIds", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId);
        try {
            return AdminReference.getAdminService().getAllSpaceIds(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllSpaceIds", "admin.MSG_ERR_GET_ALL_SPACE_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllSubSpaceIds(String sDomainFatherId) {
        SilverTrace.info("admin", "AdminController.getAllSubSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllSubSpaceIds(sDomainFatherId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllSubSpaceIds", "admin.MSG_ERR_GET_SUBSPACE_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllSubSpaceIds(String sDomainFatherId, String userId) {
        SilverTrace.info("admin", "AdminController.getAllSubSpaceIds", "root.MSG_GEN_ENTER_METHOD", "sDomainFatherId = " + sDomainFatherId + ", userId = " + userId);
        try {
            return AdminReference.getAdminService().getAllSubSpaceIds(sDomainFatherId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllSubSpaceIds", "admin.MSG_ERR_GET_SUBSPACE_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getSpaceNames(String[] asSpaceIds) {
        SilverTrace.info("admin", "AdminController.getSpaceNames", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getSpaceNames(asSpaceIds);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getSpaceNames", "admin.MSG_ERR_GET_SPACE_NAMES", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public void updateSpaceOrderNum(String sSpaceId, int orderNum) {
        SilverTrace.info("admin", "AdminController.updateSpaceOrderNum", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().updateSpaceOrderNum(sSpaceId, orderNum);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateSpaceOrderNum", "admin.MSG_ERR_UPDATE_SPACE", e);
        }
    }

    public void indexSpace(int spaceId) {
        AdminReference.getAdminService().createSpaceIndex(spaceId);
    }

    public void moveSpace(String spaceId, String fatherId) throws AdminException {
        SilverTrace.info("admin", "AdminController.moveSpace", "root.MSG_GEN_ENTER_METHOD", "moving " + spaceId + " in space " + fatherId);
        AdminReference.getAdminService().moveSpace(spaceId, fatherId);
    }

    public Map<String, String> getAllComponentsNames() {
        SilverTrace.info("admin", "AdminController.getAllComponentsNames", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllComponentsNames();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllComponentsNames", "admin.MSG_ERR_GET_ALL_COMPONENT_NAMES", e);
            return new HashMap<String, String>();
        }
    }

    public Map<String, WAComponent> getAllComponents() {
        SilverTrace.info("admin", "AdminController.getAllComponents", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllComponents();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllComponents", "admin.MSG_ERR_GET_ALL_COMPONENTS", e);
            return new HashMap<String, WAComponent>();
        }
    }

    public ComponentInst getComponentInst(String sComponentId) {
        SilverTrace.info("admin", "AdminController.getComponentInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getComponentInst(sComponentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getComponentInst", "admin.MSG_ERR_GET_COMPONENT", e);
            return null;
        }
    }

    public ComponentInstLight getComponentInstLight(String sComponentId) {
        SilverTrace.info("admin", "AdminController.getComponentInstLight", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getComponentInstLight(sComponentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getComponentInstLight", "admin.MSG_ERR_GET_COMPONENT", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addComponentInst(ComponentInst componentInst) throws QuotaException {
        SilverTrace.info("admin", "AdminController.addComponentInst", "root.MSG_GEN_ENTER_METHOD");
        Exception exceptionCatched = null;
        try {
            String string = AdminReference.getAdminService().addComponentInst(this.m_UserId, componentInst);
            return string;
        }
        catch (QuotaException e) {
            exceptionCatched = e;
            throw e;
        }
        catch (Exception e) {
            exceptionCatched = e;
            String string = "";
            return string;
        }
        finally {
            if (exceptionCatched != null) {
                SilverTrace.error("admin", "AdminController.addComponentInst", "admin.MSG_ERR_ADD_COMPONENT", exceptionCatched);
            }
        }
    }

    public String addComponentInst(ComponentInst componentInst, String userId) throws QuotaException {
        SilverTrace.info("admin", "AdminController.addComponentInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addComponentInst(userId, componentInst);
        }
        catch (QuotaException e) {
            throw e;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addComponentInst", "admin.MSG_ERR_ADD_COMPONENT", e);
            return "";
        }
    }

    public String deleteComponentInst(String sComponentId, boolean definitive) {
        SilverTrace.info("admin", "AdminController.deleteComponentInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteComponentInst(this.m_UserId, sComponentId, definitive);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteComponentInst", "admin.MSG_ERR_DELETE_COMPONENT", e);
            return "";
        }
    }

    public String updateComponentInst(ComponentInst componentInst) {
        SilverTrace.info("admin", "AdminController.updateComponentInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateComponentInst(componentInst);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateComponentInst", "admin.MSG_ERR_UPDATE_COMPONENT", e);
            return "";
        }
    }

    public void moveComponentInst(String spaceId, String componentId, String idComponentBefore, ComponentInst[] componentInsts) throws AdminException {
        SilverTrace.info("admin", "AdminController.moveComponentInst", "root.MSG_GEN_ENTER_METHOD", "moving " + componentId + " in space " + spaceId);
        AdminReference.getAdminService().moveComponentInst(spaceId, componentId, idComponentBefore, componentInsts);
    }

    public String[] getAvailCompoIds(String sClientSpaceId, String sUserId) {
        SilverTrace.info("admin", "AdminController.getAvailCompoIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAvailCompoIds(sClientSpaceId, sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAvailCompoIds", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public boolean isComponentAvailable(String componentId, String userId) {
        SilverTrace.info("admin", "AdminController.isComponentAvailable", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().isComponentAvailable(componentId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isComponentAvailable", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT", e);
            return false;
        }
    }

    public boolean isSpaceAvailable(String userId, String spaceId) {
        SilverTrace.info("admin", "AdminController.isSpaceAvailable", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().isSpaceAvailable(userId, spaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isSpaceAvailable", "admin.MSG_ERR_GET_USER_AVAILABLE_COMPONENT", e);
            return false;
        }
    }

    public void updateComponentOrderNum(String sComponentId, int orderNum) {
        SilverTrace.info("admin", "AdminController.updateComponentOrderNum", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().updateComponentOrderNum(sComponentId, orderNum);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateComponentOrderNum", "admin.MSG_ERR_UPDATE_COMPONENT", e);
        }
    }

    public void indexComponent(String componentId) {
        AdminReference.getAdminService().createComponentIndex(componentId);
    }

    public List<SpaceInstLight> getRemovedSpaces() {
        try {
            return AdminReference.getAdminService().getRemovedSpaces();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getRemovedSpaces", "admin.MSG_ERR_GET_REMOVED_SPACES", e);
            return null;
        }
    }

    public List<ComponentInstLight> getRemovedComponents() {
        try {
            return AdminReference.getAdminService().getRemovedComponents();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getRemovedComponents", "admin.MSG_ERR_GET_REMOVED_COMPONENTS", e);
            return null;
        }
    }

    public void restoreSpaceFromBasket(String spaceId) {
        try {
            AdminReference.getAdminService().restoreSpaceFromBasket(spaceId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.restoreSpaceFromBasket", "admin.MSG_ERR_GET_RESTORE_SPACE_FROM_BASKET", e);
        }
    }

    public void restoreComponentFromBasket(String componentId) {
        try {
            AdminReference.getAdminService().restoreComponentFromBasket(componentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.restoreComponentFromBasket", "admin.MSG_ERR_GET_RESTORE_COMPONENT_FROM_BASKET", e);
        }
    }

    public String[] getAllProfilesNames(String sComponentName) {
        SilverTrace.info("admin", "AdminController.getAllProfilesNames", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllProfilesNames(sComponentName);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllProfilesNames", "admin.MSG_ERR_GET_ALL_PROFILE_NAMES", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public ProfileInst getProfileInst(String sProfileId) {
        SilverTrace.info("admin", "AdminController.getProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getProfileInst(sProfileId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getProfileInst", "admin.MSG_ERR_GET_PROFILE", e);
            return null;
        }
    }

    public List<ProfileInst> getProfilesByObject(String objectId, String objectType, String componentId) {
        SilverTrace.info("admin", "AdminController.getProfilesByObject", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getProfilesByObject(objectId, objectType, componentId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getProfilesByObject", "admin.MSG_ERR_GET_PROFILE", e);
            return null;
        }
    }

    public String[] getProfilesByObjectAndUserId(int objectId, String objectType, String componentId, String userId) {
        SilverTrace.info("admin", "AdminController.getProfilesByObjectAndUserId", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getProfilesByObjectAndUserId(objectId, objectType, componentId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isObjectAvailable", "admin.MSG_ERR_GET_PROFILE", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public boolean isObjectAvailable(int objectId, String objectType, String componentId, String userId) {
        SilverTrace.info("admin", "AdminController.isObjectAvailable", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().isObjectAvailable(componentId, objectId, objectType, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isObjectAvailable", "admin.MSG_ERR_GET_PROFILE", e);
            return false;
        }
    }

    public String addProfileInst(ProfileInst profileInst) {
        return this.addProfileInst(profileInst, null);
    }

    public String addProfileInst(ProfileInst profileInst, String userId) {
        SilverTrace.info("admin", "AdminController.addProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addProfileInst(profileInst, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addProfileInst", "admin.MSG_ERR_ADD_PROFILE", e);
            return "";
        }
    }

    public String deleteProfileInst(String sProfileId) {
        return this.deleteProfileInst(sProfileId, null);
    }

    public String deleteProfileInst(String sProfileId, String userId) {
        SilverTrace.info("admin", "AdminController.deleteProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteProfileInst(sProfileId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteProfileInst", "admin.MSG_ERR_DELETE_PROFILE", e);
            return "";
        }
    }

    public String updateProfileInst(ProfileInst profileInst) {
        return this.updateProfileInst(profileInst, null);
    }

    public String updateProfileInst(ProfileInst profileInst, String userId) {
        SilverTrace.info("admin", "AdminController.updateProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateProfileInst(profileInst, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateProfileInst", "admin.MSG_ERR_UPDATE_PROFILE", e);
            return "";
        }
    }

    public String getProfileLabelfromName(String sComponentName, String sProfileName, String lang) {
        SilverTrace.info("admin", "AdminController.getProfileLabelfromName", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getProfileLabelfromName(sComponentName, sProfileName, lang);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getProfileLabelfromName", "admin.MSG_ERR_GET_PROFILE_LABEL_FROM_NAME", "component name: " + sComponentName + ", profile name: " + sProfileName, e);
            return "";
        }
    }

    public String[] getProfileIds(String sUserId) {
        SilverTrace.info("admin", "AdminController.getProfileIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getProfileIds(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getProfileIds", "admin.MSG_ERR_GET_USERPROFILE", e);
            return null;
        }
    }

    public String[] getProfileIdsOfGroup(String sGroupId) {
        SilverTrace.info("admin", "AdminController.getProfileIdsOfGroup", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getProfileIdsOfGroup(sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getProfileIdsOfGroup", "admin.MSG_ERR_GET_USERPROFILE", e);
            return null;
        }
    }

    public void assignRightsFromUserToUser(RightAssignationContext.MODE operationMode, String sourceUserId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        SilverTrace.info("admin", "AdminController.assignRightsFromUserToUser", "root.MSG_GEN_ENTER_METHOD");
        AdminReference.getAdminService().assignRightsFromUserToUser(operationMode, sourceUserId, targetUserId, nodeAssignRights, authorId);
    }

    public void assignRightsFromUserToGroup(RightAssignationContext.MODE operationMode, String sourceUserId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        SilverTrace.info("admin", "AdminController.assignRightsFromUserToGroup", "root.MSG_GEN_ENTER_METHOD");
        AdminReference.getAdminService().assignRightsFromUserToGroup(operationMode, sourceUserId, targetGroupId, nodeAssignRights, authorId);
    }

    public void assignRightsFromGroupToUser(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        SilverTrace.info("admin", "AdminController.assignRightsFromGroupToUser", "root.MSG_GEN_ENTER_METHOD");
        AdminReference.getAdminService().assignRightsFromGroupToUser(operationMode, sourceGroupId, targetUserId, nodeAssignRights, authorId);
    }

    public void assignRightsFromGroupToGroup(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        SilverTrace.info("admin", "AdminController.assignRightsFromGroupToGroup", "root.MSG_GEN_ENTER_METHOD");
        AdminReference.getAdminService().assignRightsFromGroupToGroup(operationMode, sourceGroupId, targetGroupId, nodeAssignRights, authorId);
    }

    public String[] getDirectGroupsIdsOfUser(String userId) {
        SilverTrace.info("admin", "AdminController.getDirectGroupsIdsOfUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getDirectGroupsIdsOfUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getDirectGroupsIdsOfUser", "admin.MSG_ERR_GET_DOMAIN", "user id: " + userId, e);
            return null;
        }
    }

    public String addDomain(Domain theDomain) {
        SilverTrace.info("admin", "AdminController.addDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addDomain(theDomain);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addDomain", "admin.MSG_ERR_ADD_DOMAIN", e);
            return "";
        }
    }

    public String updateDomain(Domain theDomain) {
        SilverTrace.info("admin", "AdminController.updateDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateDomain(theDomain);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateDomain", "admin.EX_ERR_UPDATE_DOMAIN", e);
            return "";
        }
    }

    public String removeDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.removeDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().removeDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.removeDomain", "admin.MSG_ERR_DELETE_DOMAIN", e);
            return "";
        }
    }

    public Domain getDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.getDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getDomain", "admin.MSG_ERR_GET_DOMAIN", "domain id: " + domainId, e);
            return null;
        }
    }

    public long getDomainActions(String domainId) {
        SilverTrace.info("admin", "AdminController.getDomainActions", "root.MSG_GEN_ENTER_METHOD", "domainID = " + domainId);
        try {
            return AdminReference.getAdminService().getDomainActions(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getDomainActions", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return 0L;
        }
    }

    public Group[] getRootGroupsOfDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.getRootGroupsOfDomain", "root.MSG_GEN_ENTER_METHOD", "domainID = " + domainId);
        try {
            return AdminReference.getAdminService().getRootGroupsOfDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getRootGroupsOfDomain", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return ArrayUtil.EMPTY_GROUP_ARRAY;
        }
    }

    public String[] getRootGroupIdsOfDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.getRootGroupIdsOfDomain", "root.MSG_GEN_ENTER_METHOD", "domainID = " + domainId);
        try {
            return AdminReference.getAdminService().getRootGroupIdsOfDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getRootGroupIdsOfDomain", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public UserDetail[] getAllUsersOfGroup(String groupId) {
        SilverTrace.info("admin", "AdminController.getAllUsersOfGroup", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId);
        try {
            return AdminReference.getAdminService().getAllUsersOfGroup(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllUsersOfGroup", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
    }

    public UserDetail[] getUsersOfDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.getUsersOfDomain", "root.MSG_GEN_ENTER_METHOD", "domainID = " + domainId);
        try {
            return AdminReference.getAdminService().getUsersOfDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUsersOfDomain", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
    }

    public String[] getUserIdsOfDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.getUserIdsOfDomain", "root.MSG_GEN_ENTER_METHOD", "domainID = " + domainId);
        try {
            return AdminReference.getAdminService().getUserIdsOfDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserIdsOfDomain", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public int getUsersNumberOfDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.getUsersNumberOfDomain", "root.MSG_GEN_ENTER_METHOD", "domainID = " + domainId);
        try {
            return AdminReference.getAdminService().getUsersNumberOfDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUsersNumberOfDomain", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return 0;
        }
    }

    public Domain[] getAllDomains() {
        SilverTrace.info("admin", "AdminController.getAllDomains", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllDomains();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllDomains", "admin.MSG_ERR_GET_ALL_DOMAINS", e);
            return null;
        }
    }

    public SpaceProfileInst getSpaceProfileInst(String sSpaceProfileId) {
        SilverTrace.info("admin", "AdminController.getSpaceProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getSpaceProfileInst(sSpaceProfileId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getSpaceProfileInst", "admin.MSG_ERR_GET_SPACE_PROFILE", e);
            return null;
        }
    }

    public String addSpaceProfileInst(SpaceProfileInst spaceProfileInst, String userId) {
        SilverTrace.info("admin", "AdminController.addSpaceProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addSpaceProfileInst(spaceProfileInst, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addSpaceProfileInst", "admin.MSG_ERR_ADD_SPACE_PROFILE", e);
            return "";
        }
    }

    public String deleteSpaceProfileInst(String sSpaceProfileId, String userId) {
        SilverTrace.info("admin", "AdminController.deleteSpaceProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteSpaceProfileInst(sSpaceProfileId, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteSpaceProfileInst", "admin.MSG_ERR_DELETE_SPACE_PROFILE", e);
            return "";
        }
    }

    public String updateSpaceProfileInst(SpaceProfileInst spaceProfileInst, String userId) {
        SilverTrace.info("admin", "AdminController.updateSpaceProfileInst", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateSpaceProfileInst(spaceProfileInst, userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateSpaceProfileInst", "admin.MSG_ERR_UPDATE_SPACE_PROFILE", e);
            return "";
        }
    }

    public String[] getAllGroupsIds() {
        SilverTrace.info("admin", "AdminController.getAllGroupsIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllGroupIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllGroupIds", "admin.MSG_ERR_GET_ALL_GROUP_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllRootGroupIds() {
        SilverTrace.info("admin", "AdminController.getAllRootGroupsIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllRootGroupIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllRootGroupsIds", "admin.MSG_ERR_GET_ALL_GROUP_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllSubGroupIds(String groupId) {
        SilverTrace.info("admin", "AdminController.getDirectSubgroupIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllSubGroupIds(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getDirectSubgroupIds", "admin.MSG_ERR_GET_ALL_GROUP_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getAllSubGroupIdsRecursively(String groupId) {
        SilverTrace.info("admin", "AdminController.getAllSubGroupIdsRecursively", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllSubGroupIdsRecursively(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllSubGroupIdsRecursively", "admin.MSG_ERR_GET_ALL_GROUP_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getGroupNames(String[] asGroupIds) {
        SilverTrace.info("admin", "AdminController.getGroupNames", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGroupNames(asGroupIds);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getGroupNames", "admin.MSG_ERR_GET_GROUP_NAMES", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String getGroupName(String sGroupId) {
        SilverTrace.info("admin", "AdminController.getGroupName", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGroupName(sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getGroupName", "admin.MSG_ERR_GET_GROUP_NAME", "group id: " + sGroupId, e);
            return "";
        }
    }

    public String[] getAllUsersIds() {
        SilverTrace.info("admin", "AdminController.getAllUsersIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllUsersIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllUsersIds", "admin.MSG_ERR_GET_ALL_USER_IDS", e);
            return null;
        }
    }

    public String[] getGroupManageableSpaceIds(String sGroupId) {
        SilverTrace.info("admin", "AdminController.getGroupManageableSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGroupManageableSpaceIds(sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getGroupManageableSpaceIds", "admin.MSG_ERR_GET_SPACE", e);
            return null;
        }
    }

    public GroupProfileInst getGroupProfile(String groupId) {
        SilverTrace.info("admin", "AdminController.getGroupProfile", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGroupProfileInst(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getGroupProfile", "admin.MSG_ERR_GET_GROUP_PROFILE", e);
            return null;
        }
    }

    public String deleteGroupProfile(String groupId) {
        SilverTrace.info("admin", "AdminController.deleteGroupProfile", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteGroupProfileInst(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteGroupProfile", "admin.MSG_ERR_DELETE_GROUP_PROFILE", e);
            return "";
        }
    }

    public String updateGroupProfile(GroupProfileInst profile) {
        SilverTrace.info("admin", "AdminController.updateGroupProfile", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateGroupProfileInst(profile);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateGroupProfile", "admin.MSG_ERR_UPDATE_GROUP_PROFILE", e);
            return "";
        }
    }

    public String getDAPIGeneralAdminId() {
        SilverTrace.info("admin", "AdminController.getDAPIGeneralAdminId", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getDAPIGeneralAdminId();
        }
        catch (Exception e) {
            SilverTrace.fatal("admin", "AdminController.getDAPIGeneralAdminId", "admin.MSG_FATAL_GET_GENERAL_ADMIN_ID", e);
            return null;
        }
    }

    public UserDetail getUserDetail(String sId) {
        SilverTrace.info("admin", "AdminController.getUserDetail", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserDetail(sId);
        }
        catch (Exception e) {
            SilverTrace.warn("admin", "AdminController.getUserDetail", "admin.EX_ERR_GET_USER_DETAIL", "user id: " + sId, e);
            return null;
        }
    }

    public UserFull getUserFull(String sUserId) {
        SilverTrace.info("admin", "AdminController.getUserFull", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserFull(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserFull", "admin.EX_ERR_GET_USER_DETAIL", "user Id : '" + sUserId + "'", e);
            return null;
        }
    }

    public UserFull getUserFull(String domainId, String specificId) {
        SilverTrace.info("admin", "AdminController.getUserFull", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserFull(domainId, specificId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserFull", "admin.EX_ERR_GET_USER_DETAIL", "specificId = " + specificId, e);
            return null;
        }
    }

    public String getUserIdByLoginAndDomain(String sLogin, String sDomainId) {
        SilverTrace.info("admin", "AdminController.getUserIdByLoginAndDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserIdByLoginAndDomain(sLogin, sDomainId);
        }
        catch (Exception e) {
            SilverTrace.warn("admin", "AdminController.getUserIdByLoginAndDomain", "admin.EX_ERR_GET_USER_DETAIL", "sLogin : '" + sLogin + "' Domain = " + sDomainId, e);
            return null;
        }
    }

    public UserDetail[] getUserDetails(String[] asUserIds) {
        SilverTrace.info("admin", "AdminController.getUserDetails", "root.MSG_GEN_ENTER_METHOD");
        try {
            if (asUserIds != null) {
                return AdminReference.getAdminService().getUserDetails(asUserIds);
            }
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getUserDetails", "admin.EX_ERR_GET_USER_DETAILS", e);
            return null;
        }
    }

    public String addUser(UserDetail userDetail) {
        SilverTrace.info("admin", "AdminController.addUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addUser(userDetail);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addUser", "admin.EX_ERR_ADD_USER", e);
            return "";
        }
    }

    public void userAcceptsTermsOfService(String userId) {
        SilverTrace.info("admin", "AdminController.userAcceptsTermsOfService", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().userAcceptsTermsOfService(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.userAcceptsTermsOfService", "admin.EX_ERR_UPDATE_USER_TOS_ACCEPTANCE_DATE", e);
        }
    }

    public void blockUser(String userId) {
        SilverTrace.info("admin", "AdminController.blockUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().blockUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.blockUser", "admin.EX_ERR_BLOCK_USER", e);
        }
    }

    public void unblockUser(String userId) {
        SilverTrace.info("admin", "AdminController.unblockUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().unblockUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.unblockUser", "admin.EX_ERR_UNBLOCK_USER", e);
        }
    }

    public void deactivateUser(String userId) {
        SilverTrace.info("admin", "AdminController.deactivateUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().deactivateUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deactivateUser", "admin.EX_ERR_DEACTIVATE_USER", e);
        }
    }

    public void activateUser(String userId) {
        SilverTrace.info("admin", "AdminController.activateUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            AdminReference.getAdminService().activateUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.activateUser", "admin.EX_ERR_UNDEACTIVATE_USER", e);
        }
    }

    public String deleteUser(String sUserId) {
        SilverTrace.info("admin", "AdminController.deleteUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteUser(sUserId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteUser", "admin.EX_ERR_DELETE_USER", e);
            return "";
        }
    }

    public String updateUser(UserDetail userDetail) {
        SilverTrace.info("admin", "AdminController.updateUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateUser(userDetail);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateUser", "admin.EX_ERR_UPDATE_USER", e);
            return "";
        }
    }

    public String updateSynchronizedUser(UserDetail userDetail) {
        SilverTrace.info("admin", "AdminController.updateSynchronizedUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateUser(userDetail);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateSynchronizedUser", "admin.EX_ERR_UPDATE_USER", e);
            return "";
        }
    }

    public String updateUserFull(UserFull userFull) throws AdminException {
        SilverTrace.info("admin", "AdminController.updateUserFull", "root.MSG_GEN_ENTER_METHOD");
        return AdminReference.getAdminService().updateUserFull(userFull);
    }

    public String authenticate(String sKey, String sSessionId, boolean isAppInMaintenance) {
        try {
            return AdminReference.getAdminService().identify(sKey, sSessionId, isAppInMaintenance);
        }
        catch (Exception e) {
            return "-1";
        }
    }

    public void indexUsers(String domainId) {
        try {
            AdminReference.getAdminService().indexUsers(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.indexUsers", "admin.CANT_INDEX_USERS", "domainId = " + domainId, e);
        }
    }

    public void indexAllUsers() {
        try {
            AdminReference.getAdminService().indexAllUsers();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.indexAllUsers", "admin.CANT_INDEX_ALL_USERS", e);
        }
    }

    public String[] getAllGroupIds() {
        SilverTrace.info("admin", "AdminController.getAllGroupIds", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAllGroupIds();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAllGroupIds", "admin.EX_ERR_GET_ALL_GROUP_IDS", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public boolean isGroupExist(String sName) {
        SilverTrace.info("admin", "AdminController.isGroupExist", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().isGroupExist(sName);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isGroupExist", "admin.EX_ERR_IS_GROUP_EXIST", e);
            return false;
        }
    }

    public Group getGroupById(String sGroupId) {
        SilverTrace.info("admin", "AdminController.getGroupById", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGroup(sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getGroupById", "admin.EX_ERR_GET_GROUP", e);
            return null;
        }
    }

    public List<String> getPathToGroup(String groupId) {
        SilverTrace.info("admin", "AdminController.getPathToGroup", "root.MSG_GEN_ENTER_METHOD", "groupId =" + groupId);
        try {
            return AdminReference.getAdminService().getPathToGroup(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getPathToGroup", "admin.EX_ERR_GET_GROUP", e);
            return null;
        }
    }

    public Group getGroupByNameInDomain(String sGroupName, String sDomainFatherId) {
        SilverTrace.info("admin", "AdminController.getGroupByNameInDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getGroupByNameInDomain(sGroupName, sDomainFatherId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getGroupByNameInDomain", "admin.EX_ERR_GET_GROUP", e);
            return null;
        }
    }

    public String addGroup(Group group) {
        SilverTrace.info("admin", "AdminController.addGroup", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().addGroup(group);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addGroup", "admin.EX_ERR_ADD_GROUP", e);
            return "";
        }
    }

    public String deleteGroupById(String sGroupId) {
        SilverTrace.info("admin", "AdminController.deleteGroupById", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().deleteGroupById(sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.deleteGroupById", "admin.EX_ERR_DELETE_GROUP", e);
            return "";
        }
    }

    public String updateGroup(Group group) {
        SilverTrace.info("admin", "AdminController.updateGroup", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().updateGroup(group);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.updateGroup", "admin.EX_ERR_UPDATE_GROUP", e);
            return "";
        }
    }

    public AdminGroupInst[] getAdminOrganization() {
        SilverTrace.info("admin", "AdminController.getAdminOrganization", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAdminOrganization();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getAdminOrganization", "admin.EX_ERR_GET_ADMIN_ORGANIZATION", e);
            return null;
        }
    }

    public void indexGroups(String domainId) {
        try {
            AdminReference.getAdminService().indexGroups(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.indexGroups", "admin.CANT_INDEX_GROUPS", "domainId = " + domainId, e);
        }
    }

    public void indexAllGroups() {
        try {
            AdminReference.getAdminService().indexAllGroups();
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.indexAllGroups", "admin.CANT_INDEX_ALL_USERS", e);
        }
    }

    public UserLog[] getUserConnected() {
        SilverTrace.info("admin", "AdminController.getUserConnected", "root.MSG_GEN_ENTER_METHOD");
        return AdminReference.getAdminService().getUserConnected();
    }

    public String synchronizeSilverpeasWithDomain(String domainId) {
        SilverTrace.info("admin", "AdminController.synchronizeSilverpeasWithDomain", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeSilverpeasWithDomain(domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeSilverpeasWithDomain", "admin.MSG_ERR_SYNCHRONIZE_DOMAIN", e);
            return "Error has occurred";
        }
    }

    public String synchronizeUser(String userId) {
        SilverTrace.info("admin", "AdminController.synchronizeUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeUser(userId, true);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeUser", "admin.MSG_ERR_SYNCHRONIZE_USER", e);
            return "";
        }
    }

    public String synchronizeImportUser(String domainId, String userLogin) {
        SilverTrace.info("admin", "AdminController.synchronizeImportUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeImportUser(domainId, userLogin, true);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeImportUser", "admin.MSG_ERR_SYNCHRONIZE_USER", e);
            return "";
        }
    }

    public List<DomainProperty> getSpecificPropertiesToImportUsers(String domainId, String language) {
        SilverTrace.info("admin", "AdminController.getSpecificPropertiesToImportUsers", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getSpecificPropertiesToImportUsers(domainId, language);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.getSpecificPropertiesToImportUsers", "admin.MSG_ERR_SYNCHRONIZE_USER", e);
            return null;
        }
    }

    public List<UserDetail> searchUsers(String domainId, Map<String, String> query) {
        SilverTrace.info("admin", "AdminController.searchUsers", "root.MSG_GEN_ENTER_METHOD");
        try {
            return Arrays.asList(AdminReference.getAdminService().searchUsers(domainId, query));
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.searchUsers", "admin.MSG_ERR_SYNCHRONIZE_USER", e);
            return new ArrayList<UserDetail>();
        }
    }

    public String synchronizeRemoveUser(String userId) {
        SilverTrace.info("admin", "AdminController.synchronizeRemoveUser", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeRemoveUser(userId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeRemoveUser", "admin.MSG_ERR_SYNCHRONIZE_USER", e);
            return "";
        }
    }

    public String synchronizeGroup(String groupId) {
        SilverTrace.info("admin", "AdminController.synchronizeGroup", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeGroup(groupId, true);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeGroup", "admin.MSG_ERR_SYNCHRONIZE_GROUP", e);
            if (e instanceof AdminException && ((AdminException)e).getNested() instanceof GroupSynchronizationRule.Error) {
                GroupSynchronizationRule.Error error = (GroupSynchronizationRule.Error)((AdminException)e).getNested();
                if (error instanceof GroupSynchronizationRule.GroundRuleError) {
                    return error.getHandledMessage() + "|" + ((GroupSynchronizationRule.GroundRuleError)error).getBaseRulePart();
                }
                return error.getHandledMessage();
            }
            return "";
        }
    }

    public String synchronizeImportGroup(String domainId, String groupName) {
        SilverTrace.info("admin", "AdminController.synchronizeImportGroup", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeImportGroup(domainId, groupName, null, true, false);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeImportGroup", "admin.MSG_ERR_SYNCHRONIZE_GROUP", e);
            return "";
        }
    }

    public String synchronizeRemoveGroup(String groupId) {
        SilverTrace.info("admin", "AdminController.synchronizeRemoveGroup", "root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().synchronizeRemoveGroup(groupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.synchronizeRemoveGroup", "admin.MSG_ERR_SYNCHRONIZE_GROUP", e);
            return "";
        }
    }

    public void resetAllDBConnections(boolean isScheduled) {
        try {
            AdminReference.getAdminService().resetAllDBConnections(isScheduled);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.resetAllDBConnections", "admin.MSG_ERR_SYNCHRONIZE_GROUP", e);
        }
    }

    public void removeUserFromGroup(String sUserId, String sGroupId) {
        SilverTrace.info("admin", "AdminController.removeUserFromGroup", "root.MSG_GEN_ENTER_METHOD", "userId = " + sUserId + ", groupId = " + sGroupId);
        try {
            AdminReference.getAdminService().removeUserFromGroup(sUserId, sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.removeUserFromGroup", "admin.EX_ERR_REMOVE_USER_FROM_GROUP", e);
        }
    }

    public void addUserInGroup(String sUserId, String sGroupId) {
        SilverTrace.info("admin", "AdminController.addUserInGroup", "root.MSG_GEN_ENTER_METHOD", "userId = " + sUserId + ", groupId = " + sGroupId);
        try {
            AdminReference.getAdminService().addUserInGroup(sUserId, sGroupId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.addUserInGroup", "admin.EX_ERR_ADD_USER_IN_GROUP", e);
        }
    }

    public void reloadAdminCache() {
        AdminReference.getAdminService().reloadCache();
    }

    public String copyAndPasteComponent(PasteDetail pasteDetail) throws AdminException, QuotaException {
        return AdminReference.getAdminService().copyAndPasteComponent(pasteDetail);
    }

    public String copyAndPasteSpace(PasteDetail pasteDetail) throws AdminException, QuotaException {
        return AdminReference.getAdminService().copyAndPasteSpace(pasteDetail);
    }

    public boolean isDomainManagerUser(String userId, String domainId) {
        SilverTrace.info("admin", "AdminController.isDomainManagerUser", "userId = " + userId + ", domainId = " + domainId);
        try {
            return AdminReference.getAdminService().isDomainManagerUser(userId, domainId);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "AdminController.isDomainManagerUser", "Error inside admin service", e);
            return false;
        }
    }
}

