/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.DomainDriver;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.DomainDriverManagerFactory;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.GroupManager;
import com.stratelia.webactiv.beans.admin.SynchroGroupReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserManager;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.UserRow;
import com.stratelia.webactiv.util.exception.WithNested;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.util.BiFunction;
import org.silverpeas.util.Function;
import org.silverpeas.util.PrefixedNotationExpressionEngine;

class GroupSynchronizationRule {
    private static final Pattern ACCESSLEVEL_STANDARD_DATA_PATTERN = Pattern.compile("(?i)^\\s*ds_accesslevel\\s*=\\s*(\\S+)\\s*$");
    private static final Pattern DOMAIN_STANDARD_DATA_PATTERN = Pattern.compile("(?i)^\\s*ds_domain[s]?\\s*=\\s*(.+)\\s*$");
    private static final Pattern COMPLEMENTARY_DATA_PATTERN = Pattern.compile("(?i)^\\s*dc_(\\S+)\\s*=\\s*(.+)\\s*$");
    private static final Pattern GROUP_RULE_DATA_PATTERN = Pattern.compile("(?i)^\\s*dr_groups(withsubgroups)?\\s*=\\s*(.+)\\s*$");
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("(?i)^\\s*[(].+[)]\\s*$");
    private final Group group;
    private final boolean isSharedDomain;
    private List<String> cacheOfAllUserIds = null;

    public static GroupSynchronizationRule from(Group group) {
        return new GroupSynchronizationRule(group);
    }

    private GroupSynchronizationRule(Group group) {
        this.group = group;
        this.isSharedDomain = group.getDomainId() == null || "-1".equals(group.getDomainId());
    }

    public List<String> getUserIds() throws AdminException {
        List<String> userIds = this.evaluateCombinationRule(this.group.getRule());
        return userIds == null ? Collections.emptyList() : userIds;
    }

    private static String getRuleExpression(PrefixedNotationExpressionEngine<List<String>> combinationEngine, String combinationRule) {
        String rule = combinationRule != null ? combinationRule : "";
        Matcher matcher = EXPRESSION_PATTERN.matcher(rule);
        if (!(matcher.matches() || rule.contains("\\") || combinationEngine.detectOperator(rule))) {
            rule = rule.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)");
        }
        return rule;
    }

    private List<String> evaluateCombinationRule(String combinationRule) throws Error {
        PrefixedNotationExpressionEngine.OperatorFunction<List<String>> NEGATE_FUNCTION = new PrefixedNotationExpressionEngine.OperatorFunction<List<String>>("!", new BiFunction<List<String>, List<String>, List<String>>(){

            @Override
            public List<String> apply(List<String> computed, List<String> userIds) {
                try {
                    List<String> safeComputed = computed == null ? GroupSynchronizationRule.this.getCacheOfAllUserIds() : new ArrayList();
                    safeComputed.removeAll(userIds);
                    return safeComputed;
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        PrefixedNotationExpressionEngine.OperatorFunction<List<String>> AND_FUNCTION = new PrefixedNotationExpressionEngine.OperatorFunction<List<String>>("&", new BiFunction<List<String>, List<String>, List<String>>(){

            @Override
            public List<String> apply(List<String> computed, List<String> userIds) {
                List<String> safeComputed = computed == null ? userIds : computed;
                return CollectionUtil.intersection(safeComputed, userIds);
            }
        });
        PrefixedNotationExpressionEngine.OperatorFunction<List<String>> OR_FUNCTION = new PrefixedNotationExpressionEngine.OperatorFunction<List<String>>("|", new BiFunction<List<String>, List<String>, List<String>>(){

            @Override
            public List<String> apply(List<String> computed, List<String> userIds) {
                List<Object> safeComputed = computed == null ? Collections.emptyList() : computed;
                return CollectionUtil.union(safeComputed, userIds);
            }
        });
        Function<String, List<String>> simpleSilverpeasRuleToUserIds = new Function<String, List<String>>(){

            @Override
            public List<String> apply(String simpleSilverpeasRule) {
                try {
                    return GroupSynchronizationRule.this.evaluateSimpleSilverpeasRule(simpleSilverpeasRule);
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        PrefixedNotationExpressionEngine<List<String>> combinationEngine = PrefixedNotationExpressionEngine.from(simpleSilverpeasRuleToUserIds, NEGATE_FUNCTION, AND_FUNCTION, OR_FUNCTION);
        try {
            String expression = GroupSynchronizationRule.getRuleExpression(combinationEngine, combinationRule);
            return combinationEngine.evaluate(expression);
        }
        catch (Exception e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new Error(e);
        }
    }

    private List<String> evaluateSimpleSilverpeasRule(String simpleSilverpeasRule) throws AdminException {
        if (simpleSilverpeasRule == null) {
            return null;
        }
        Matcher matcher = ACCESSLEVEL_STANDARD_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            return this.getUserIdsByAccessLevel(matcher.group(1));
        }
        matcher = DOMAIN_STANDARD_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            List<String> domainIds = Arrays.asList(matcher.group(1).replaceAll("\\s", "").split(","));
            ArrayList<String> userIds = new ArrayList<String>();
            for (String domainId : domainIds) {
                userIds.addAll(this.getUserIdsByDomain(domainId));
            }
            return userIds;
        }
        matcher = GROUP_RULE_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            boolean withSubGroups = StringUtil.isDefined(matcher.group(1));
            String groupValues = matcher.group(2).replaceAll("\\s", "");
            List<String> groupIds = Arrays.asList(groupValues.split(","));
            return this.getUserIdsByGroups(groupIds, withSubGroups);
        }
        matcher = COMPLEMENTARY_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            String propertyName = matcher.group(1);
            String propertyValue = matcher.group(2);
            return this.getUserIdsBySpecificProperty(propertyName, propertyValue);
        }
        SilverTrace.error("admin", "Admin.synchronizeGroup", "admin.MSG_ERR_SYNCHRONIZE_GROUP", "ground rule '" + simpleSilverpeasRule + "' for groupId '" + this.group.getId() + "' is not correct !");
        throw new GroundRuleError(simpleSilverpeasRule);
    }

    private List<String> getUserIdsByGroups(List<String> groupIds, boolean withSubGroups) throws AdminException {
        HashSet<String> allGroupIds = new HashSet<String>();
        for (String currentGroupId : new HashSet<String>(groupIds)) {
            allGroupIds.add(currentGroupId);
            if (!withSubGroups) continue;
            allGroupIds.addAll(this.getGroupManager().getAllSubGroupIdsRecursively(currentGroupId));
        }
        return this.getUserManager().getAllUserIdsOfGroups(new ArrayList<String>(allGroupIds));
    }

    private List<String> getUserIdsByDomain(String domainId) throws AdminPersistenceException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        List<String> userIds = Collections.emptyList();
        if (this.isSharedDomain) {
            userIds = Arrays.asList(domainDriverManager.getOrganization().user.getUserIdsOfDomain(Integer.parseInt(domainId)));
        }
        return userIds;
    }

    private List<String> getUserIdsByAccessLevel(String accessLevel) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        List<String> userIds = "*".equalsIgnoreCase(accessLevel) ? (this.isSharedDomain ? Arrays.asList(this.getUserManager().getAllUsersIds(domainDriverManager)) : Arrays.asList(this.getUserManager().getUserIdsOfDomain(domainDriverManager, this.group.getDomainId()))) : (this.isSharedDomain ? Arrays.asList(domainDriverManager.getOrganization().user.getUserIdsByAccessLevel(UserAccessLevel.fromCode(accessLevel))) : Arrays.asList(this.getUserManager().getUserIdsOfDomainAndAccessLevel(domainDriverManager, this.group.getDomainId(), UserAccessLevel.fromCode(accessLevel))));
        return userIds;
    }

    private List<String> getUserIdsBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        ArrayList<String> userIds = new ArrayList();
        if (this.isSharedDomain) {
            Domain[] domains;
            for (Domain domain : domains = AdminReference.getAdminService().getAllDomains()) {
                userIds.addAll(this.getUserIdsBySpecificProperty(domain.getId(), propertyName, propertyValue));
            }
        } else {
            userIds = this.getUserIdsBySpecificProperty(this.group.getDomainId(), propertyName, propertyValue);
        }
        return userIds;
    }

    private List<String> getUserIdsBySpecificProperty(String domainId, String propertyName, String propertyValue) throws AdminException {
        int domainIdAsInteger = Integer.parseInt(domainId);
        UserDetail[] users = ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        DomainDriver domainDriver = null;
        try {
            domainDriver = domainDriverManager.getDomainDriver(domainIdAsInteger);
        }
        catch (Exception e) {
            this.reportInfo("admin.getUserIdsBySpecificProperty", "Erreur ! Domaine " + domainId + " inaccessible !");
        }
        if (domainDriver != null) {
            try {
                users = domainDriver.getUsersBySpecificProperty(propertyName, propertyValue);
                if (users == null) {
                    this.reportInfo("admin.getUserIdsBySpecificProperty", "La propri\u00e9t\u00e9 '" + propertyName + "' n'est pas d\u00e9finie dans le domaine " + domainId);
                }
            }
            catch (Exception e) {
                if (e instanceof AdminException) {
                    Exception cause = ((AdminException)e).getNested();
                    if (cause instanceof LDAPLocalException || cause instanceof org.ietf.ldap.LDAPLocalException) {
                        this.reportInfo("admin.getUserIdsBySpecificProperty", "Domain " + domainId + ": " + cause.toString());
                    }
                    throw (AdminException)e;
                }
                throw new AdminException("GroupSynchronizationRule.getUserIdsBySpecificProperty", 4, "admin.MSG_ERR_GET_ALL_USERS", e);
            }
        }
        ArrayList<String> specificIds = new ArrayList<String>();
        if (users != null) {
            for (UserDetail user : users) {
                specificIds.add(user.getSpecificId());
            }
        }
        UserRow[] usersInDomain = domainDriverManager.getOrganization().user.getUsersBySpecificIds(domainIdAsInteger, specificIds);
        ArrayList<String> userIds = new ArrayList<String>();
        if (usersInDomain != null) {
            for (UserRow userInDomain : usersInDomain) {
                userIds.add(Integer.toString(userInDomain.id));
            }
        }
        return userIds;
    }

    private List<String> getCacheOfAllUserIds() throws AdminException {
        if (this.cacheOfAllUserIds == null) {
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
            this.cacheOfAllUserIds = this.isSharedDomain ? Arrays.asList(this.getUserManager().getAllUsersIds(domainDriverManager)) : Arrays.asList(this.getUserManager().getUserIdsOfDomain(domainDriverManager, this.group.getDomainId()));
        }
        return new ArrayList<String>(this.cacheOfAllUserIds);
    }

    private void reportInfo(String clazz, String message) {
        SynchroGroupReport.info(clazz, message, null);
    }

    private UserManager getUserManager() {
        return UserManager.get();
    }

    private GroupManager getGroupManager() {
        return GroupManager.get();
    }

    public static class GroundRuleError
    extends Error {
        private static final long serialVersionUID = 4003102352897715610L;
        private final String baseRulePart;

        public GroundRuleError(String baseRulePart) {
            super(new IllegalArgumentException("expression.groundrule.unknown"));
            this.baseRulePart = baseRulePart;
        }

        public String getBaseRulePart() {
            return this.baseRulePart;
        }
    }

    public static class Error
    extends RuntimeException {
        private static final long serialVersionUID = -3732193660967552614L;

        public Error(Throwable cause) {
            super(cause);
        }

        public String getHandledMessage() {
            String message = "";
            Throwable exceptionSource = this.getCause();
            Throwable previousExceptionSource = null;
            while (exceptionSource != null && previousExceptionSource != exceptionSource) {
                previousExceptionSource = exceptionSource;
                if (StringUtil.isDefined(exceptionSource.getMessage()) && exceptionSource.getMessage().startsWith("expression.")) {
                    message = exceptionSource.getMessage();
                    break;
                }
                if (exceptionSource instanceof LDAPException || exceptionSource instanceof org.ietf.ldap.LDAPLocalException) {
                    message = exceptionSource.toString();
                    break;
                }
                if (exceptionSource instanceof WithNested) {
                    exceptionSource = ((WithNested)((Object)exceptionSource)).getNested();
                    continue;
                }
                exceptionSource = exceptionSource.getCause();
            }
            return message;
        }
    }
}

