/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.encryption;

import com.silverpeas.util.ArrayUtil;
import java.text.MessageFormat;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.Crypt;
import org.silverpeas.authentication.encryption.PasswordEncryption;
import org.silverpeas.util.Charsets;

public class UnixSHA512Encryption
implements PasswordEncryption {
    private static final String SALTCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890/.";
    private static final String ENCRYPTION_METHOD_ID = "$6$";

    @Override
    public String encrypt(String password) {
        String salt = UnixSHA512Encryption.computeRandomSalt();
        return Crypt.crypt((String)password, (String)salt);
    }

    @Override
    public String encrypt(String password, byte[] salt) {
        String enrichedSalt = ArrayUtil.isEmpty((byte[])salt) ? UnixSHA512Encryption.computeRandomSalt() : UnixSHA512Encryption.setUpSalt(salt);
        return Crypt.crypt((String)password, (String)enrichedSalt);
    }

    @Override
    public void check(String password, String digest) throws AssertionError {
        String encryptedPassword = this.encrypt(password, this.getSaltUsedInDigest(digest));
        if (!encryptedPassword.equals(digest)) {
            throw new AssertionError((Object)MessageFormat.format("The password \"{0}\" doesn''t match the digest \"{1}\"", password, digest));
        }
    }

    @Override
    public byte[] getSaltUsedInDigest(String digest) {
        String salt = "";
        if (this.doUnderstandDigest(digest)) {
            Pattern pattern = Pattern.compile("\\$[a-zA-Z0-9/.]{0,16}\\$");
            Matcher matcher = pattern.matcher(digest);
            matcher.find(1);
            salt = matcher.group();
            salt = salt.substring(1, salt.length() - 1);
        }
        return salt.getBytes(Charsets.UTF_8);
    }

    @Override
    public boolean doUnderstandDigest(String digest) {
        return digest.matches("\\$6\\$(rounds=[0-9]+\\$)?[a-zA-Z0-9/.]{0,16}\\$[a-zA-Z0-9/.]{86}");
    }

    private static final String computeRandomSalt() {
        Random random = new Random();
        StringBuilder saltBuf = new StringBuilder(ENCRYPTION_METHOD_ID);
        while (saltBuf.length() < 16) {
            int index = (int)(random.nextFloat() * (float)SALTCHARS.length());
            saltBuf.append(SALTCHARS.substring(index, index + 1));
        }
        return saltBuf.toString();
    }

    private static final String setUpSalt(byte[] salt) {
        return ENCRYPTION_METHOD_ID + new String(salt, Charsets.UTF_8);
    }
}

