/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.mail;

import com.silverpeas.util.StringUtil;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.silverpeas.util.Charsets;

public class MailContent {
    public static final MailContent EMPTY = new MailContent();
    private static final String DEFAULT_CONTENT_TYPE = "text/html; charset=\"UTF-8\"";
    private Object content = "";
    private String contentType = "text/html; charset=\"UTF-8\"";
    private boolean isHtml = true;

    public static MailContent of(String content) {
        MailContent mailContent = new MailContent();
        if (StringUtil.isDefined(content)) {
            mailContent.content = content;
        }
        return mailContent;
    }

    public static MailContent of(Multipart multipart) {
        MailContent mailContent = new MailContent();
        if (multipart != null) {
            mailContent.content = multipart;
        }
        return mailContent;
    }

    private MailContent() {
    }

    public MailContent notHtml() {
        this.isHtml = false;
        return this;
    }

    boolean isHtml() {
        return this.isHtml;
    }

    Object getValue() {
        return this.content;
    }

    String getContentType() {
        return this.contentType;
    }

    public MailContent withContentType(String contentType) {
        this.contentType = StringUtil.defaultStringIfNotDefined(contentType, DEFAULT_CONTENT_TYPE);
        return this;
    }

    public void applyOn(MimeMessage message) throws MessagingException {
        if (this.getValue() instanceof String) {
            String contentAsString = (String)this.getValue();
            if (!contentAsString.toLowerCase().contains("<html>") && !this.isHtml()) {
                message.setText(contentAsString, Charsets.UTF_8.name());
            } else {
                message.setContent((Object)contentAsString, this.getContentType());
            }
        } else {
            message.setContent((Multipart)this.getValue());
        }
    }

    public String toString() {
        return this.getValue().toString();
    }
}

