/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.mail.engine;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.mail.MailToSend;
import org.silverpeas.mail.engine.AddMailToSendRequest;
import org.silverpeas.mail.engine.Request;

public class MailSenderThread
extends Thread {
    private static final List<Request> requestList = new ArrayList<Request>();
    private static MailSenderThread mailSenderThread = null;
    private static Semaphore orderedOneByOneSemaphore = new Semaphore(1, true);

    private static void startIfNotAlreadyDone() {
        if (mailSenderThread == null) {
            mailSenderThread = new MailSenderThread();
            mailSenderThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMailToSend(MailToSend mailToSend) {
        AddMailToSendRequest addMailToSendRequest = new AddMailToSendRequest(mailToSend);
        if (mailToSend.isAsynchronous()) {
            List<Request> list = requestList;
            synchronized (list) {
                SilverTrace.debug("mailSenderEngine", "MailSenderThread", "mailSenderEngine.INFO_ADDS_ADD_REQUEST", mailToSend.toString());
                requestList.add(addMailToSendRequest);
                MailSenderThread.startIfNotAlreadyDone();
            }
        }
        try {
            addMailToSendRequest.process(orderedOneByOneSemaphore);
        }
        catch (Exception e) {
            e.printStackTrace();
            SilverTrace.error("mailSenderEngine", "MailSenderThread", "mailSenderEngine.UNEXPECTED_ERROR", e);
        }
    }

    private MailSenderThread() {
    }

    @Override
    public void run() {
        SilverTrace.info("mailSenderEngine", "MailSenderThread", "mailSenderEngine.INFO_STARTS_MAIL_SENDING_THREAD");
        Request currentRequest = this.nextRequest();
        while (currentRequest != null) {
            CacheServiceFactory.clearAllThreadCaches();
            try {
                currentRequest.process(orderedOneByOneSemaphore);
            }
            catch (Exception e) {
                e.printStackTrace();
                SilverTrace.error("mailSenderEngine", "MailSenderThread", "mailSenderEngine.UNEXPECTED_ERROR", e);
            }
            currentRequest = this.nextRequest();
        }
        SilverTrace.info("mailSenderEngine", "MailSenderThread", "mailSenderEngine.INFO_STOPS_MAIL_SENDING_THREAD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request nextRequest() {
        List<Request> list = requestList;
        synchronized (list) {
            Request nextRequest;
            if (!requestList.isEmpty()) {
                SilverTrace.info("mailSenderEngine", "MailSenderThread", "root.MSG_GEN_PARAM_VALUE", "# of mails to send = " + requestList.size());
                nextRequest = requestList.remove(0);
            } else {
                nextRequest = null;
                mailSenderThread = null;
            }
            return nextRequest;
        }
    }
}

