/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.persistence.repository.jpa;

import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import java.lang.reflect.ParameterizedType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.ejb.QueryImpl;
import org.silverpeas.persistence.model.Entity;
import org.silverpeas.persistence.model.EntityIdentifier;
import org.silverpeas.persistence.repository.EntityRepository;
import org.silverpeas.persistence.repository.OperationContext;
import org.silverpeas.persistence.repository.QueryCriteria;
import org.silverpeas.persistence.repository.jpa.NamedParameter;
import org.silverpeas.persistence.repository.jpa.NamedParameters;
import org.silverpeas.util.PaginationList;

public class SilverpeasJpaEntityManager<ENTITY extends Entity<ENTITY, ENTITY_IDENTIFIER_TYPE>, ENTITY_IDENTIFIER_TYPE extends EntityIdentifier>
implements EntityRepository<ENTITY, ENTITY_IDENTIFIER_TYPE> {
    private int maximumItemsInClause = 500;
    private Class<ENTITY> entityClass;
    private Class<ENTITY_IDENTIFIER_TYPE> entityIdentifierClass;
    @PersistenceContext
    private EntityManager em;

    protected Class<ENTITY> getEntityClass() {
        this.initializeEntityClasses();
        return this.entityClass;
    }

    protected Class<ENTITY_IDENTIFIER_TYPE> getEntityIdentifierClass() {
        this.initializeEntityClasses();
        return this.entityIdentifierClass;
    }

    private void initializeEntityClasses() {
        if (this.entityIdentifierClass == null) {
            try {
                this.entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                this.entityIdentifierClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ENTITY_IDENTIFIER_TYPE convertToEntityIdentifier(String idAsString) {
        try {
            EntityIdentifier identifier = (EntityIdentifier)this.getEntityIdentifierClass().newInstance();
            identifier.fromString(idAsString);
            return (ENTITY_IDENTIFIER_TYPE)identifier;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Collection<ENTITY_IDENTIFIER_TYPE> convertToEntityIdentifiers(String ... idsAsString) {
        return this.convertToEntityIdentifiers(idsAsString == null ? null : CollectionUtil.asList(idsAsString));
    }

    protected Collection<ENTITY_IDENTIFIER_TYPE> convertToEntityIdentifiers(Collection<String> idsAsString) {
        int size = idsAsString == null ? 0 : idsAsString.size();
        ArrayList<ENTITY_IDENTIFIER_TYPE> identifiers = new ArrayList<ENTITY_IDENTIFIER_TYPE>(size);
        if (size > 0) {
            for (String id : idsAsString) {
                identifiers.add(this.convertToEntityIdentifier(id));
            }
        }
        return identifiers;
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public List<ENTITY> findByNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.listFromNamedQuery(namedQuery, parameters);
    }

    public ENTITY findOneByNamedQuery(String namedQuery, NamedParameters parameters) {
        return (ENTITY)((Entity)this.unique(this.listFromNamedQuery(namedQuery, parameters)));
    }

    @Override
    public List<ENTITY> getAll() {
        return this.getEntityManager().createQuery("select a from " + this.getEntityClass().getSimpleName() + " a", this.getEntityClass()).getResultList();
    }

    @Override
    public ENTITY getById(String id) {
        return this.getByIdentifier(this.convertToEntityIdentifier(id));
    }

    @Override
    public List<ENTITY> getById(String ... ids) {
        return this.getByIdentifier(this.convertToEntityIdentifiers(ids));
    }

    @Override
    public List<ENTITY> getById(Collection<String> ids) {
        return this.getByIdentifier(this.convertToEntityIdentifiers(ids));
    }

    private ENTITY getByIdentifier(ENTITY_IDENTIFIER_TYPE id) {
        return (ENTITY)((Entity)this.getEntityManager().find(this.getEntityClass(), id));
    }

    private List<ENTITY> getByIdentifier(Collection<ENTITY_IDENTIFIER_TYPE> ids) {
        List entities = new ArrayList(ids.size());
        String selectQuery = "select a from " + this.getEntityClass().getName() + " a where a.id in :ids";
        for (Collection<ENTITY_IDENTIFIER_TYPE> entityIds : this.split(new HashSet<ENTITY_IDENTIFIER_TYPE>(ids))) {
            List tmp = this.newNamedParameters().add("ids", entityIds).applyTo(this.getEntityManager().createQuery(selectQuery, this.getEntityClass())).getResultList();
            if (entities.isEmpty()) {
                entities = tmp;
                continue;
            }
            entities.addAll(tmp);
        }
        return entities;
    }

    @Override
    public ENTITY save(OperationContext context, ENTITY entity) {
        return (ENTITY)((Entity)this.save(context, Collections.singletonList(entity)).get(0));
    }

    @Override
    public List<ENTITY> save(OperationContext context, ENTITY ... entities) {
        return this.save(context, CollectionUtil.asList(entities));
    }

    @Override
    public List<ENTITY> save(OperationContext context, List<ENTITY> entities) {
        context.putIntoCache();
        ArrayList<Object> savedEntities = new ArrayList<Object>(entities.size());
        for (Entity entity : entities) {
            if (entity.isPersisted()) {
                savedEntities.add(this.getEntityManager().merge((Object)entity));
                continue;
            }
            this.getEntityManager().persist((Object)entity);
            savedEntities.add(entity);
        }
        return savedEntities;
    }

    @Override
    public void delete(ENTITY ... entity) {
        this.delete(CollectionUtil.asList(entity));
    }

    @Override
    public void delete(List<ENTITY> entities) {
        for (Entity entity : entities) {
            if (!entity.isPersisted()) continue;
            this.getEntityManager().remove(this.getEntityManager().merge((Object)entity));
        }
    }

    @Override
    public long deleteById(String ... ids) {
        return this.deleteByIdentifier(this.convertToEntityIdentifiers(ids));
    }

    @Override
    public long deleteById(Collection<String> ids) {
        return this.deleteByIdentifier(this.convertToEntityIdentifiers(ids));
    }

    private long deleteByIdentifier(Collection<ENTITY_IDENTIFIER_TYPE> ids) {
        long nbDeletes = 0L;
        Query deleteQuery = this.getEntityManager().createQuery("delete from " + this.getEntityClass().getName() + " a where a.id in :ids");
        for (Collection<ENTITY_IDENTIFIER_TYPE> entityIds : this.split(ids)) {
            nbDeletes += (long)this.newNamedParameters().add("ids", entityIds).applyTo(deleteQuery).executeUpdate();
        }
        return nbDeletes;
    }

    public NamedParameters newNamedParameters() {
        return new NamedParameters();
    }

    protected ENTITY getFromJpqlString(String jpqlQuery, NamedParameters parameters) {
        return (ENTITY)((Entity)this.getFromJpqlString(jpqlQuery, parameters, this.getEntityClass()));
    }

    protected <AN_ENTITY> AN_ENTITY getFromJpqlString(String jpqlQuery, NamedParameters parameters, Class<AN_ENTITY> returnEntityType) {
        return this.unique(this.listFromQuery(this.getEntityManager().createQuery(jpqlQuery, returnEntityType), parameters));
    }

    protected List<ENTITY> listFromJpqlString(String jpqlQuery, NamedParameters parameters) {
        return this.listFromJpqlString(jpqlQuery, parameters, this.getEntityClass());
    }

    protected <AN_ENTITY> List<AN_ENTITY> listFromJpqlString(String jpqlQuery, NamedParameters parameters, Class<AN_ENTITY> returnEntityType) {
        return this.listFromQuery(this.getEntityManager().createQuery(jpqlQuery, returnEntityType), parameters);
    }

    public List<ENTITY> findByCriteria(QueryCriteria criteria) {
        String jpqlQuery = this.jpqlQueryFrom(criteria);
        NamedParameters parameters = (NamedParameters)criteria.clause().parameters();
        TypedQuery query = this.getEntityManager().createQuery(jpqlQuery, this.getEntityClass());
        long count = -1L;
        if (criteria.pagination().isDefined()) {
            String jpqlCountQuery = "select count(*) " + jpqlQuery.replaceFirst("order by.*", "");
            count = this.getFromJpqlString(jpqlCountQuery, parameters, Long.class);
            query.setFirstResult((criteria.pagination().getPageNumber() - 1) * criteria.pagination().getItemCount());
            query.setMaxResults(criteria.pagination().getItemCount());
        }
        List listOfEntities = this.listFromQuery(query, parameters);
        return count >= 1L ? PaginationList.from(listOfEntities, count) : listOfEntities;
    }

    private <AN_ENTITY> AN_ENTITY unique(List<AN_ENTITY> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return entities.get(0);
        }
        throw new IllegalArgumentException("wanted to get a unique entity from a list that contains more than one entity ...");
    }

    protected long updateFromJpqlQuery(String jpqlQuery, NamedParameters parameters) {
        return this.updateFromQuery(this.getEntityManager().createQuery(jpqlQuery), parameters);
    }

    protected long deleteFromJpqlQuery(String jpqlQuery, NamedParameters parameters) {
        return this.deleteFromQuery(this.getEntityManager().createQuery(jpqlQuery), parameters);
    }

    protected ENTITY getFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return (ENTITY)((Entity)this.getFromNamedQuery(namedQuery, parameters, this.getEntityClass()));
    }

    protected <AN_ENTITY> AN_ENTITY getFromNamedQuery(String namedQuery, NamedParameters parameters, Class<AN_ENTITY> returnEntityType) {
        return this.unique(this.listFromQuery(this.getEntityManager().createNamedQuery(namedQuery, returnEntityType), parameters));
    }

    protected List<ENTITY> listFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.listFromNamedQuery(namedQuery, parameters, this.getEntityClass());
    }

    protected <AN_ENTITY> List<AN_ENTITY> listFromNamedQuery(String namedQuery, NamedParameters parameters, Class<AN_ENTITY> returnEntityType) {
        return this.listFromQuery(this.getEntityManager().createNamedQuery(namedQuery, returnEntityType), parameters);
    }

    protected long updateFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.updateFromQuery(this.getEntityManager().createNamedQuery(namedQuery), parameters);
    }

    protected long deleteFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.deleteFromQuery(this.getEntityManager().createNamedQuery(namedQuery), parameters);
    }

    private <AN_ENTITY> List<AN_ENTITY> listFromQuery(TypedQuery<AN_ENTITY> query, NamedParameters parameters) {
        return parameters.applyTo(query).getResultList();
    }

    private long updateFromQuery(Query updateQuery, NamedParameters parameters) {
        parameters.add("lastUpdateDate", new Timestamp(new Date().getTime()));
        this.verify(updateQuery, parameters);
        return parameters.applyTo(updateQuery).executeUpdate();
    }

    private void verify(Query query, NamedParameters parameters) {
        String queryString = ((QueryImpl)query).getHibernateQuery().getQueryString();
        for (String requiredParameterName : new String[]{"lastUpdatedBy", "lastUpdateDate"}) {
            NamedParameter<?, ?> parameter;
            if (query.getParameter(requiredParameterName) != null && (parameter = parameters.namedParameters.get(requiredParameterName)) != null && StringUtil.isDefined(parameter.getValue().toString())) continue;
            throw new IllegalArgumentException("parameter '" + requiredParameterName + "' is missing from the query '" + queryString + "' or is missing from given parameters.");
        }
        if (!Pattern.compile("version.*=.*version[ ]*\\+[ ]*1").matcher(queryString).find()) {
            throw new IllegalArgumentException("version management is missing from the query '" + queryString + "' -> expected entity.version = (entity.version + 1)");
        }
    }

    private long deleteFromQuery(Query deleteQuery, NamedParameters parameters) {
        return parameters.applyTo(deleteQuery).executeUpdate();
    }

    private EntityManager getEntityManager() {
        return this.em;
    }

    protected <E> Collection<Collection<E>> split(Collection<E> collection) {
        return CollectionUtil.split(collection, this.getMaximumItemsInClause());
    }

    protected int getMaximumItemsInClause() {
        return this.maximumItemsInClause;
    }

    protected void setMaximumItemsInClause(int maximumItemsInClause) {
        this.maximumItemsInClause = maximumItemsInClause;
    }

    private String jpqlQueryFrom(QueryCriteria criteria) {
        String query = criteria.clause().text();
        String queryInLowerCase = query.toLowerCase();
        if (queryInLowerCase.startsWith("select")) {
            query = query.substring(queryInLowerCase.indexOf("from"));
        }
        if (!queryInLowerCase.startsWith("from ")) {
            query = "from " + this.getEntityClass().getSimpleName() + " where " + query;
        }
        return query;
    }
}

