/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.process.io.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.silverpeas.process.io.file.FileBasePath;
import org.silverpeas.process.io.file.FileHandler;

public class HandledFile {
    private final FileBasePath basePath;
    protected final FileHandler fileHandler;
    protected final File file;

    protected HandledFile(FileBasePath basePath, FileHandler fileHandler, File file) {
        this.basePath = basePath;
        this.fileHandler = fileHandler;
        this.file = file;
    }

    public FileBasePath getBasePath() {
        return this.basePath;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public String getRealPath() {
        return this.fileHandler.translateToRealPath(this.basePath, this.file).getPath();
    }

    public File getFile() {
        return this.fileHandler.getExistingFile(this.basePath, this.file);
    }

    public boolean exists(String ... names) {
        return this.fileHandler.exists(this.basePath, this.file, names);
    }

    public HandledFile getHandledFile(String ... names) {
        if (names == null) {
            return this;
        }
        return this.fileHandler.getHandledFile(this.basePath, this.file, names);
    }

    public HandledFile getParentHandledFile(String ... names) {
        return this.fileHandler.getHandledFile(this.basePath, this.file.getParentFile(), names);
    }

    public OutputStream openOutputStream() throws Exception {
        return this.openOutputStream(false);
    }

    public OutputStream openOutputStream(boolean append) throws Exception {
        return this.fileHandler.openOutputStream(this.basePath, this.file, append);
    }

    public InputStream openInputStream() throws Exception {
        return this.fileHandler.openInputStream(this.basePath, this.file);
    }

    public void touch(String ... names) throws Exception {
        this.fileHandler.touch(this.basePath, this.file, names);
    }

    public Collection<HandledFile> listFiles(String ... extensions) {
        return this.listFiles(true, extensions);
    }

    public Collection<HandledFile> listFiles(boolean recursive, String ... extensions) {
        return this.toIOFiles(this.fileHandler.listFiles(this.basePath, this.file, recursive, extensions));
    }

    public Collection<HandledFile> listFiles(IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return this.toIOFiles(this.fileHandler.listFiles(this.basePath, this.file, fileFilter, dirFilter));
    }

    private Collection<HandledFile> toIOFiles(Collection<File> files) {
        LinkedList<HandledFile> result = new LinkedList<HandledFile>();
        if (files != null) {
            for (File file : files) {
                result.add(new HandledFile(this.basePath, this.fileHandler, file));
            }
        }
        return result;
    }

    public boolean contentEquals(HandledFile otherFile) throws Exception {
        return this.fileHandler.contentEquals(this.basePath, this.file, otherFile.file);
    }

    public void copyFile(HandledFile destFile) throws Exception {
        this.fileHandler.copyFile(this.basePath, this.file, destFile.basePath, destFile.file);
    }

    public long copyFile(OutputStream output) throws Exception {
        return this.fileHandler.copyFile(this.basePath, this.file, output);
    }

    public void copyURLToFile(URL source) throws Exception {
        this.fileHandler.copyURLToFile(source, this.basePath, this.file);
    }

    public boolean delete() throws Exception {
        return this.fileHandler.delete(this.basePath, this.file);
    }

    public void cleanDirectory() throws Exception {
        this.fileHandler.cleanDirectory(this.basePath, this.file);
    }

    public boolean waitFor(int seconds) {
        return this.fileHandler.waitFor(this.basePath, this.file, seconds);
    }

    public String readFileToString() throws Exception {
        return this.readFileToString(null);
    }

    public String readFileToString(String encoding) throws Exception {
        return this.fileHandler.readFileToString(this.basePath, this.file, encoding);
    }

    public byte[] readFileToByteArray() throws Exception {
        return this.fileHandler.readFileToByteArray(this.basePath, this.file);
    }

    public List<String> readLines() throws Exception {
        return this.readLines(null);
    }

    public List<String> readLines(String encoding) throws Exception {
        return this.fileHandler.readLines(this.basePath, this.file, encoding);
    }

    public void writeStringToFile(String data) throws Exception {
        this.writeStringToFile(data, null, false);
    }

    public void writeStringToFile(String data, String encoding) throws Exception {
        this.writeStringToFile(data, encoding, false);
    }

    public void writeStringToFile(String data, boolean append) throws Exception {
        this.writeStringToFile(data, null, append);
    }

    public void writeStringToFile(String data, String encoding, boolean append) throws Exception {
        this.fileHandler.writeStringToFile(this.basePath, this.file, data, encoding, append);
    }

    public void write(CharSequence data) throws Exception {
        this.write(data, null, false);
    }

    public void write(CharSequence data, boolean append) throws Exception {
        this.write(data, null, append);
    }

    public void write(CharSequence data, String encoding) throws Exception {
        this.write(data, encoding, false);
    }

    public void write(CharSequence data, String encoding, boolean append) throws Exception {
        this.fileHandler.write(this.basePath, this.file, data, encoding, append);
    }

    public void writeByteArrayToFile(byte[] data) throws Exception {
        this.writeByteArrayToFile(data, false);
    }

    public void writeByteArrayToFile(byte[] data, boolean append) throws Exception {
        this.fileHandler.writeByteArrayToFile(this.basePath, this.file, data, append);
    }

    public void copyInputStreamToFile(InputStream inputStream) throws Exception {
        this.fileHandler.copyInputStreamToFile(this.basePath, this.file, inputStream, false);
    }

    public void writeLines(Collection<?> lines) throws Exception {
        this.writeLines(null, lines, null, false);
    }

    public void writeLines(Collection<?> lines, boolean append) throws Exception {
        this.writeLines(null, lines, null, append);
    }

    public void writeLines(Collection<?> lines, String lineEnding) throws Exception {
        this.writeLines(null, lines, lineEnding, false);
    }

    public void writeLines(Collection<?> lines, String lineEnding, boolean append) throws Exception {
        this.writeLines(null, lines, lineEnding, append);
    }

    public void writeLines(String encoding, Collection<?> lines) throws Exception {
        this.writeLines(encoding, lines, null, false);
    }

    public void writeLines(String encoding, Collection<?> lines, boolean append) throws Exception {
        this.writeLines(encoding, lines, null, append);
    }

    public void writeLines(String encoding, Collection<?> lines, String lineEnding) throws Exception {
        this.writeLines(encoding, lines, lineEnding, false);
    }

    public void writeLines(String encoding, Collection<?> lines, String lineEnding, boolean append) throws Exception {
        this.fileHandler.writeLines(this.basePath, this.file, encoding, lines, lineEnding, append);
    }

    public void moveFile(HandledFile destFile) throws Exception {
        this.fileHandler.moveFile(this.basePath, this.file, destFile.basePath, destFile.file);
    }

    public long size() {
        return this.fileHandler.sizeOf(this.basePath, this.file);
    }

    public boolean isFileNewer(HandledFile reference) {
        return this.isFileNewer(reference.file);
    }

    public boolean isFileNewer(File reference) {
        return this.fileHandler.isFileNewer(this.basePath, this.file, reference);
    }

    public boolean isFileNewer(Date date) {
        return this.fileHandler.isFileNewer(this.basePath, this.file, date);
    }

    public boolean isFileNewer(long timeMillis) {
        return this.fileHandler.isFileNewer(this.basePath, this.file, timeMillis);
    }

    public boolean isFileOlder(HandledFile reference) {
        return this.isFileOlder(reference.file);
    }

    public boolean isFileOlder(File reference) {
        return this.fileHandler.isFileOlder(this.basePath, this.file, reference);
    }

    public boolean isFileOlder(Date date) {
        return this.fileHandler.isFileOlder(this.basePath, this.file, date);
    }

    public boolean isFileOlder(long timeMillis) {
        return this.fileHandler.isFileOlder(this.basePath, this.file, timeMillis);
    }
}

