/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.token;

import org.silverpeas.token.Token;
import org.silverpeas.token.TokenGenerator;
import org.silverpeas.token.exception.TokenGenerationException;

public class TokenGeneratorProvider {
    public static TokenGenerator getTokenGenerator(Class<? extends Token> type) {
        org.silverpeas.token.annotation.TokenGenerator annotation = type.getAnnotation(org.silverpeas.token.annotation.TokenGenerator.class);
        try {
            Class<? extends TokenGenerator> generatorType = annotation.value();
            return generatorType.newInstance();
        }
        catch (InstantiationException ex) {
            throw new TokenGenerationException("Cannot instantiate the token generator mapped with the token type " + type.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new TokenGenerationException("Cannot access the default constructor of the token generator mapped with the token type " + type.getName(), ex);
        }
        catch (NullPointerException ex) {
            throw new TokenGenerationException("No token generator mapped with the token type " + type.getName(), ex);
        }
    }
}

