/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.components;

import com.silverpeas.admin.components.MultilangHashMapAdapter;
import com.silverpeas.admin.components.Option;
import com.silverpeas.admin.components.ParameterInputType;
import com.silverpeas.admin.components.ParameterUpdatableType;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.ui.DisplayI18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ParameterType", propOrder={"name", "label", "order", "mandatory", "value", "options", "type", "size", "updatable", "help", "warning", "personalSpaceValue"})
public class Parameter
implements Cloneable {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected HashMap<String, String> label;
    protected int order;
    protected boolean mandatory;
    @XmlElement(required=true)
    protected String value;
    @XmlElementWrapper(name="options")
    @XmlElement(name="option")
    protected List<Option> options;
    @XmlElement(required=true)
    protected String type;
    protected Integer size;
    @XmlElement(required=true)
    protected String updatable;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected HashMap<String, String> help;
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected HashMap<String, String> warning;
    protected String personalSpaceValue;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public HashMap<String, String> getLabel() {
        if (this.label == null) {
            this.label = new HashMap();
        }
        return this.label;
    }

    public void setLabel(HashMap<String, String> value) {
        this.label = value;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int value) {
        this.order = value;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean value) {
        this.mandatory = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Option> getOptions() {
        if (this.isXmlTemplate()) {
            this.loadXmlTemplates();
        } else if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer value) {
        this.size = value;
    }

    public String getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(String value) {
        this.updatable = value;
    }

    public HashMap<String, String> getHelp() {
        if (this.help == null) {
            this.help = new HashMap();
        }
        return this.help;
    }

    public void setHelp(HashMap<String, String> value) {
        this.help = value;
    }

    public HashMap<String, String> getWarning() {
        if (this.warning == null) {
            this.warning = new HashMap();
        }
        return this.warning;
    }

    public void setWarning(HashMap<String, String> value) {
        this.warning = value;
    }

    public String getPersonalSpaceValue() {
        return this.personalSpaceValue;
    }

    public void setPersonalSpaceValue(String value) {
        this.personalSpaceValue = value;
    }

    public boolean isVisible() {
        return !this.isNeverUpdatable() && !this.isHidden();
    }

    public boolean isHidden() {
        return ParameterUpdatableType.hidden == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isUpdatableOnCreationOnly() {
        return ParameterUpdatableType.creation == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isAlwaysUpdatable() {
        return ParameterUpdatableType.always == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isNeverUpdatable() {
        return ParameterUpdatableType.never == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isText() {
        return ParameterInputType.text == ParameterInputType.valueOf(this.getType());
    }

    public boolean isCheckbox() {
        return ParameterInputType.checkbox == ParameterInputType.valueOf(this.getType());
    }

    public boolean isRadio() {
        return ParameterInputType.radio == ParameterInputType.valueOf(this.getType());
    }

    public boolean isSelect() {
        return ParameterInputType.select == ParameterInputType.valueOf(this.getType());
    }

    public boolean isXmlTemplate() {
        return ParameterInputType.xmltemplates == ParameterInputType.valueOf(this.getType());
    }

    public Parameter clone() {
        Parameter param = new Parameter();
        param.setHelp((HashMap)this.getHelp().clone());
        param.setWarning((HashMap)this.getWarning().clone());
        param.setLabel((HashMap)this.getLabel().clone());
        param.setMandatory(this.mandatory);
        param.setName(this.name);
        if (this.options == null) {
            param.setOptions(new ArrayList<Option>());
        } else {
            ArrayList<Option> newOptions = new ArrayList<Option>(this.options.size());
            for (Option option : this.options) {
                newOptions.add(option.clone());
            }
            param.setOptions(newOptions);
        }
        param.setOrder(this.order);
        param.setPersonalSpaceValue(this.personalSpaceValue);
        param.setSize(this.size);
        param.setType(this.type);
        param.setUpdatable(this.updatable);
        param.setValue(this.value);
        return param;
    }

    private void loadXmlTemplates() {
        this.options = new ArrayList<Option>();
        try {
            List<PublicationTemplate> templates = PublicationTemplateManager.getInstance().getPublicationTemplates(true);
            for (PublicationTemplate template : templates) {
                Option option = new Option();
                for (String lang : DisplayI18NHelper.getLanguages()) {
                    option.getName().put(lang, template.getName());
                }
                option.setValue(template.getFileName());
                this.options.add(option);
            }
        }
        catch (PublicationTemplateException ex) {
            SilverTrace.error("admin", "Parameters.loadXmlTemplates", "root.EX_IGNORED", "ParameterName=" + this.name, ex);
        }
    }
}

