/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.calendar;

import com.silverpeas.calendar.Datable;
import com.silverpeas.calendar.Date;
import com.stratelia.webactiv.util.DateUtil;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateTime
extends java.util.Date
implements Datable<DateTime>,
Cloneable {
    private static final long serialVersionUID = -2562622075317046753L;
    private TimeZone timeZone = TimeZone.getDefault();

    public static DateTime now() {
        return new DateTime(new java.util.Date());
    }

    public static DateTime dateTimeAt(int ... timeParts) {
        if (timeParts.length < 3) {
            throw new IllegalArgumentException("The year, month and day must be set");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(timeParts[0], timeParts[1], timeParts[2], 0, 0, 0);
        calendar.set(14, 0);
        if (timeParts.length >= 4) {
            calendar.set(11, timeParts[3]);
            if (timeParts.length >= 5) {
                calendar.set(12, timeParts[4]);
                if (timeParts.length >= 6) {
                    calendar.set(13, timeParts[5]);
                    if (timeParts.length >= 7) {
                        calendar.set(14, timeParts[6]);
                    }
                }
            }
        }
        return new DateTime(calendar.getTime());
    }

    public DateTime(java.util.Date aDate) {
        super(aDate.getTime());
    }

    public DateTime(java.util.Date aDate, TimeZone timeZone) {
        super(aDate.getTime());
        this.timeZone = timeZone;
    }

    @Override
    public DateTime clone() {
        return new DateTime(new java.util.Date(this.getTime()), this.getTimeZone());
    }

    @Override
    public java.util.Date asDate() {
        return new java.util.Date(this.getTime());
    }

    @Override
    public String toISO8601() {
        FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZ", (TimeZone)this.getTimeZone());
        return formatter.format((java.util.Date)this);
    }

    @Override
    public String toShortISO8601() {
        FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mmZ", (TimeZone)this.getTimeZone());
        return formatter.format((java.util.Date)this);
    }

    @Override
    public String toICal() {
        return DateUtil.formatAsICalDate(this);
    }

    @Override
    public String toICalInUTC() {
        return DateUtil.formatAsICalUTCDate(this);
    }

    public DateTime inTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean isBefore(DateTime anotherDatable) {
        return super.before(anotherDatable);
    }

    @Override
    public boolean isAfter(DateTime anotherDatable) {
        return super.after(anotherDatable);
    }

    @Override
    public boolean isEqualTo(DateTime anotherDatable) {
        return super.equals(anotherDatable);
    }

    @Override
    public boolean equals(Object obj) {
        DateTime other;
        if (obj == null) {
            return false;
        }
        if (obj.getClass().getName().equals("java.util.Date")) {
            other = new DateTime((java.util.Date)obj);
        } else {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            other = (DateTime)obj;
        }
        return this.isEqualTo(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isBefore(Date otherDate) {
        return otherDate.isBefore(new Date(this));
    }

    @Override
    public boolean isAfter(Date otherDate) {
        return otherDate.isAfter(new Date(this));
    }

    @Override
    public boolean isEqualTo(Date otherDate) {
        return otherDate.isEqualTo(new Date(this));
    }

    public Date toDate() {
        return new Date(this);
    }
}

