/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export.ical.ical4j;

import com.silverpeas.calendar.CalendarEvent;
import com.silverpeas.calendar.CalendarEventRecurrence;
import com.silverpeas.calendar.Datable;
import com.silverpeas.export.EncodingException;
import com.silverpeas.export.ical.ICalCodec;
import com.silverpeas.export.ical.ical4j.ICal4JDateCodec;
import com.silverpeas.export.ical.ical4j.ICal4JRecurrenceCodec;
import com.silverpeas.export.ical.ical4j.OffLineInetAddressHostInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.HostInfo;
import net.fortuna.ical4j.util.UidGenerator;
import org.apache.tika.io.IOUtils;

@Named(value="iCalCodec")
public class ICal4JICalCodec
implements ICalCodec {
    private UidGenerator generator = new UidGenerator((HostInfo)new OffLineInetAddressHostInfo(), "UID");

    @Override
    public String encode(List<CalendarEvent> events) {
        if (events == null || events.isEmpty()) {
            throw new IllegalArgumentException("The calendar events must be defined to encode them");
        }
        Calendar calendarIcs = new Calendar();
        calendarIcs.getProperties().add((Property)new ProdId("-//Silverpeas//iCal4j 1.1//FR"));
        calendarIcs.getProperties().add((Property)Version.VERSION_2_0);
        calendarIcs.getProperties().add((Property)CalScale.GREGORIAN);
        ArrayList<VEvent> iCalEvents = new ArrayList<VEvent>();
        ByteArrayOutputStream output = new ByteArrayOutputStream(10240);
        for (CalendarEvent calendarEvent : events) {
            TextList categoryList;
            Date startDate = ICal4JDateCodec.anICal4JDateCodec().encode(calendarEvent.getStartDate());
            Date endDate = ICal4JDateCodec.anICal4JDateCodec().encode(calendarEvent.getEndDate());
            VEvent iCalEvent = calendarEvent.isOnAllDay() && startDate.equals((Object)endDate) ? new VEvent(startDate, calendarEvent.getTitle()) : new VEvent(startDate, endDate, calendarEvent.getTitle());
            iCalEvent.getProperties().add((Property)this.generator.generateUid());
            if (calendarEvent.isRecurring()) {
                CalendarEventRecurrence eventRecurrence = calendarEvent.getRecurrence();
                Recur recur = ICal4JRecurrenceCodec.anICal4JRecurrenceCodec().encode(eventRecurrence);
                iCalEvent.getProperties().add((Property)new RRule(recur));
                iCalEvent.getProperties().add((Property)this.exceptionDatesFrom(eventRecurrence));
            }
            iCalEvent.getProperties().add((Property)new Description(calendarEvent.getDescription()));
            iCalEvent.getProperties().add((Property)new Clazz(calendarEvent.getAccessLevel()));
            iCalEvent.getProperties().add((Property)new Priority(calendarEvent.getPriority()));
            if (!calendarEvent.getLocation().isEmpty()) {
                iCalEvent.getProperties().add((Property)new Location(calendarEvent.getLocation()));
            }
            if (calendarEvent.getUrl() != null) {
                try {
                    iCalEvent.getProperties().add((Property)new Url(calendarEvent.getUrl().toURI()));
                }
                catch (URISyntaxException ex) {
                    throw new EncodingException(ex.getMessage(), ex);
                }
            }
            if (!(categoryList = new TextList(calendarEvent.getCategories().asArray())).isEmpty()) {
                iCalEvent.getProperties().add((Property)new Categories(categoryList));
            }
            for (String attendee : calendarEvent.getAttendees().asList()) {
                try {
                    iCalEvent.getProperties().add((Property)new Attendee(attendee));
                }
                catch (URISyntaxException ex) {
                    throw new EncodingException("Malformed attendee URI: " + attendee, ex);
                }
            }
            iCalEvents.add(iCalEvent);
        }
        calendarIcs.getComponents().addAll(iCalEvents);
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            outputter.output(calendarIcs, (OutputStream)output);
            String string = output.toString("UTF-8");
            return string;
        }
        catch (Exception exception) {
            throw new EncodingException("The encoding of the events in iCal formatted text has failed!", exception);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    private ExDate exceptionDatesFrom(CalendarEventRecurrence recurrence) {
        List<Datable<?>> exceptionDates = recurrence.getExceptionDates();
        DateList exDatesList = new DateList();
        ICal4JDateCodec dateCodec = ICal4JDateCodec.anICal4JDateCodec();
        for (Datable<?> anExceptionDate : exceptionDates) {
            exDatesList.add(dateCodec.encode(anExceptionDate));
        }
        return new ExDate(exDatesList);
    }
}

