/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export.ical.ical4j;

import com.silverpeas.calendar.CalendarEventRecurrence;
import com.silverpeas.calendar.DayOfWeekOccurrence;
import com.silverpeas.calendar.RecurrencePeriod;
import com.silverpeas.export.EncodingException;
import com.silverpeas.export.ical.ical4j.ICal4JDateCodec;
import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;

public class ICal4JRecurrenceCodec {
    private static final ICal4JRecurrenceCodec instance = new ICal4JRecurrenceCodec();

    public static ICal4JRecurrenceCodec anICal4JRecurrenceCodec() {
        return instance;
    }

    public Recur encode(CalendarEventRecurrence eventRecurrence) throws EncodingException {
        if (eventRecurrence == CalendarEventRecurrence.NO_RECURRENCE) {
            throw new IllegalArgumentException("Event recurrence missing!");
        }
        try {
            Recur recur = new Recur(this.asICal4JFrequency(eventRecurrence.getFrequency()));
            if (eventRecurrence.getFrequency().getInterval() > 1) {
                recur.setInterval(eventRecurrence.getFrequency().getInterval());
            }
            if (eventRecurrence.getRecurrenceCount() != 0) {
                recur.setCount(eventRecurrence.getRecurrenceCount());
            } else if (eventRecurrence.getEndDate() != CalendarEventRecurrence.NO_RECURRENCE_END_DATE) {
                Date endDate = ICal4JDateCodec.anICal4JDateCodec().encodeInUTC(eventRecurrence.getEndDate());
                recur.setUntil(endDate);
            }
            for (DayOfWeekOccurrence dayOfWeekOccurrence : eventRecurrence.getDaysOfWeek()) {
                recur.getDayList().add(this.asICal4JWeekOfDay(dayOfWeekOccurrence));
            }
            return recur;
        }
        catch (ParseException ex) {
            throw new EncodingException(ex.getMessage(), ex);
        }
    }

    private String asICal4JFrequency(RecurrencePeriod period) {
        String freq = "FREQ=";
        switch (period.getUnit()) {
            case SECOND: {
                freq = freq + "SECONDLY";
                break;
            }
            case MINUTE: {
                freq = freq + "MINUTELY";
                break;
            }
            case HOUR: {
                freq = freq + "HOURLY";
                break;
            }
            case DAY: {
                freq = freq + "DAILY";
                break;
            }
            case WEEK: {
                freq = freq + "WEEKLY";
                break;
            }
            case MONTH: {
                freq = freq + "MONTHLY";
                break;
            }
            case YEAR: {
                freq = freq + "YEARLY";
            }
        }
        return freq;
    }

    private WeekDay asICal4JWeekOfDay(DayOfWeekOccurrence dayOfWeekOccurrence) {
        WeekDay weekday = null;
        switch (dayOfWeekOccurrence.dayOfWeek()) {
            case MONDAY: {
                weekday = WeekDay.MO;
                break;
            }
            case TUESDAY: {
                weekday = WeekDay.TU;
                break;
            }
            case WEDNESDAY: {
                weekday = WeekDay.WE;
                break;
            }
            case THURSDAY: {
                weekday = WeekDay.TH;
                break;
            }
            case FRIDAY: {
                weekday = WeekDay.FR;
                break;
            }
            case SATURDAY: {
                weekday = WeekDay.SA;
                break;
            }
            case SUNDAY: {
                weekday = WeekDay.SU;
            }
        }
        if (dayOfWeekOccurrence.nth() != 0) {
            weekday = new WeekDay(weekday, dayOfWeekOccurrence.nth());
        }
        return weekday;
    }
}

