/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.Form;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.Util;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public abstract class AbstractForm
implements Form {
    private List<FieldTemplate> fieldTemplates;
    private String title = "";
    private String name = "";
    public static final String CONTEXT_FORM_FILE = "Images";
    public static final String CONTEXT_FORM_IMAGE = "XMLFormImages";

    public AbstractForm(RecordTemplate template) throws FormException {
        this.fieldTemplates = template != null ? Arrays.asList(template.getFieldTemplates()) : new ArrayList<FieldTemplate>();
    }

    public List<FieldTemplate> getFieldTemplates() {
        return this.fieldTemplates;
    }

    @Override
    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void displayScripts(JspWriter jw, PagesContext pagesContext) {
        try {
            FieldTemplate fieldTemplate;
            ComponentInstLight component;
            String language = pagesContext.getLanguage();
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)sw, true);
            boolean jsAdded = false;
            if (StringUtil.isDefined(pagesContext.getComponentId()) && StringUtil.isDefined(this.getName()) && (component = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(pagesContext.getComponentId())) != null && component.isWorkflow()) {
                out.append("<script type=\"text/javascript\" src=\"/weblib/workflows/").append(component.getName()).append("/").append(this.getName()).append(".js\"></script>\n");
                jsAdded = true;
            }
            if (!jsAdded && !this.fieldTemplates.isEmpty() && StringUtil.isDefined((fieldTemplate = this.fieldTemplates.get(0)).getTemplateName())) {
                out.append("<script type=\"text/javascript\" src=\"/weblib/xmlForms/").append(fieldTemplate.getTemplateName()).append(".js\"></script>\n");
            }
            PagesContext pc = new PagesContext(pagesContext);
            pc.incCurrentFieldIndex(1);
            out.append(Util.getJavascriptIncludes(language)).append("\n<script type=\"text/javascript\">\n").append("\tvar errorNb = 0;\n").append("\tvar errorMsg = \"\";\n").append("function addXMLError(message) {\n").append("\terrorMsg+=\"  - \"+message+\"\\n\";\n").append("\terrorNb++;\n").append("}\n").append("function getXMLField(fieldName) {\n").append("\treturn document.getElementById(fieldName);\n").append("}\n").append("function isCorrectForm() {\n").append("\terrorMsg = \"\";\n").append("\terrorNb = 0;\n").append("\tvar field;\n").append("\t\n\n");
            for (FieldTemplate fieldTemplate2 : this.fieldTemplates) {
                if (fieldTemplate2 == null) continue;
                String fieldDisplayerName = fieldTemplate2.getDisplayerName();
                String fieldType = fieldTemplate2.getTypeName();
                FieldDisplayer fieldDisplayer = null;
                try {
                    if (fieldDisplayerName == null || fieldDisplayerName.isEmpty()) {
                        fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                    }
                    if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                    out.append("\tfield = document.getElementById(\"").append(fieldTemplate2.getFieldName()).append("\");\n");
                    out.append("\tif (field == null) {\n");
                    out.append("  field = $(\"input[name=").append(fieldTemplate2.getFieldName()).append("]\");\n");
                    out.println("}");
                    out.append(" if (field != null) {\n");
                    fieldDisplayer.displayScripts(out, fieldTemplate2, pc);
                    out.println("}");
                    pc.incCurrentFieldIndex(fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate2, pc));
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "AbstractForm.display", "form.EXP_UNKNOWN_FIELD", null, fe);
                }
            }
            out.append("\t\n\n").append("\tswitch(errorNb)\n").append("\t{\n").append("\tcase 0 :\n").append("\t\tresult = true;\n").append("\t\tbreak;\n").append("\tcase 1 :\n").append("\t\terrorMsg = \"").append(Util.getString("GML.ThisFormContains", language)).append(" 1 ").append(Util.getString("GML.error", language)).append(" : \\n \" + errorMsg;\n").append("\t\twindow.alert(errorMsg);\n").append("\t\tresult = false;\n").append("\t\tbreak;\n").append("\tdefault :\n").append("\t\terrorMsg = \"").append(Util.getString("GML.ThisFormContains", language)).append("\" + errorNb + \" ").append(Util.getString("GML.errors", language)).append(" :\\n \" + errorMsg;\n").append("\t\twindow.alert(errorMsg);\n").append("\t\tresult = false;\n").append("\t\tbreak;\n").append("\t}\n").append("\treturn result;\n").append("}\n").append("\t\n\n").append("</script>\n");
            out.flush();
            jw.write(sw.toString());
        }
        catch (IOException fe) {
            SilverTrace.error("form", "AbstractForm.display", "form.EXP_CANT_WRITE", null, fe);
        }
    }

    @Override
    public abstract void display(JspWriter var1, PagesContext var2, DataRecord var3);

    @Override
    public List<String> update(List<FileItem> items, DataRecord record, PagesContext pagesContext) {
        return this.update(items, record, pagesContext, true);
    }

    @Override
    public List<String> update(List<FileItem> items, DataRecord record, PagesContext pagesContext, boolean updateWysiwyg) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        for (FieldTemplate fieldTemplate : this.fieldTemplates) {
            FieldDisplayer fieldDisplayer = null;
            if (!fieldTemplate.isReadOnly()) {
                if (fieldTemplate == null) continue;
                String fieldName = fieldTemplate.getFieldName();
                String fieldType = fieldTemplate.getTypeName();
                String fieldDisplayerName = fieldTemplate.getDisplayerName();
                try {
                    if (fieldDisplayerName == null || fieldDisplayerName.isEmpty()) {
                        fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                    }
                    if ("wysiwyg".equals(fieldDisplayerName) && !updateWysiwyg || (fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                    attachmentIds.addAll(fieldDisplayer.update(items, record.getField(fieldName), fieldTemplate, pagesContext));
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, fe);
                }
                catch (Exception e) {
                    SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, e);
                }
                continue;
            }
            SilverTrace.info("form", "AbstractForm.update", "root.MSG_GEN_PARAM_VALUE", fieldTemplate.getFieldName() + " : field value is ignored as field is read only");
        }
        return attachmentIds;
    }

    @Override
    public List<String> updateWysiwyg(List<FileItem> items, DataRecord record, PagesContext pagesContext) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        for (FieldTemplate fieldTemplate : this.fieldTemplates) {
            FieldDisplayer fieldDisplayer = null;
            if (fieldTemplate == null) continue;
            String fieldName = fieldTemplate.getFieldName();
            String fieldType = fieldTemplate.getTypeName();
            String fieldDisplayerName = fieldTemplate.getDisplayerName();
            try {
                if (fieldDisplayerName == null || fieldDisplayerName.isEmpty()) {
                    fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                }
                if (!"wysiwyg".equals(fieldDisplayerName) || (fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                attachmentIds.addAll(fieldDisplayer.update(items, record.getField(fieldName), fieldTemplate, pagesContext));
            }
            catch (FormException fe) {
                SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, fe);
            }
            catch (Exception e) {
                SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, e);
            }
        }
        return attachmentIds;
    }

    @Override
    public boolean isEmpty(List<FileItem> items, DataRecord record, PagesContext pagesContext) {
        boolean isEmpty = true;
        for (FieldTemplate fieldTemplate : this.fieldTemplates) {
            FieldDisplayer fieldDisplayer = null;
            if (fieldTemplate != null) {
                String fieldType = fieldTemplate.getTypeName();
                String fieldDisplayerName = fieldTemplate.getDisplayerName();
                try {
                    if (!StringUtil.isDefined(fieldDisplayerName)) {
                        fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                    }
                    if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) != null) {
                        String itemValue;
                        String itemName = fieldTemplate.getFieldName();
                        FileItem item = this.getParameter(items, itemName);
                        isEmpty = item != null && !item.isFormField() && StringUtil.isDefined(item.getName()) ? false : !StringUtil.isDefined(itemValue = this.getParameterValue(items, itemName, pagesContext.getEncoding()));
                    }
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "AbstractForm.isEmpty", "form.EXP_UNKNOWN_FIELD", null, fe);
                }
                catch (Exception e) {
                    SilverTrace.error("form", "AbstractForm.isEmpty", "form.EXP_UNKNOWN_FIELD", null, e);
                }
            }
            if (isEmpty) continue;
            break;
        }
        return isEmpty;
    }

    private String getParameterValue(List<FileItem> items, String parameterName, String encoding) throws UnsupportedEncodingException {
        SilverTrace.debug("form", "AbstractForm.getParameterValue", "root.MSG_GEN_ENTER_METHOD", "parameterName = " + parameterName);
        FileItem item = this.getParameter(items, parameterName);
        if (item != null && item.isFormField()) {
            SilverTrace.debug("form", "AbstractForm.getParameterValue", "root.MSG_GEN_EXIT_METHOD", "parameterValue = " + item.getString());
            return item.getString(encoding);
        }
        return null;
    }

    private FileItem getParameter(List<FileItem> items, String parameterName) {
        FileItem fileItem = null;
        for (FileItem item : items) {
            if (!parameterName.equals(item.getFieldName())) continue;
            fileItem = item;
            break;
        }
        return fileItem;
    }

    private TypeManager getTypeManager() {
        return TypeManager.getInstance();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

