/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form;

import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FormException;
import com.silverpeas.form.FormFatalException;
import com.silverpeas.util.ArrayUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

public class TypeManager {
    private static final TypeManager instance = new TypeManager();
    private final Map<String, Class<?>> implementations = new HashMap();
    private final Map<String, List<String>> typeName2displayerNames = new HashMap<String, List<String>>();
    private final Map<String, Class<?>> displayerId2displayerClass = new HashMap();

    private TypeManager() {
        try {
            this.init();
        }
        catch (FormException e) {
            SilverTrace.fatal("form", "TypeManager.initialization", "form.EXP_INITIALIZATION_FAILED", e);
        }
    }

    public static TypeManager getInstance() {
        return instance;
    }

    public String[] getTypeNames() {
        Set<String> keys = this.implementations.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public Class<?> getFieldImplementation(String typeName) throws FormException {
        if (!this.implementations.containsKey(typeName)) {
            SilverTrace.fatal("form", "TypeManager.getFieldImplementation", "form.EXP_UNKNOWN_TYPE", typeName);
            throw new FormException("TypeManager", "form.EXP_UNKNOWN_TYPE", typeName);
        }
        return this.implementations.get(typeName);
    }

    public String getDisplayerName(String typeName) throws FormException {
        List<String> displayerNames = this.typeName2displayerNames.get(typeName);
        if (displayerNames == null || displayerNames.isEmpty()) {
            SilverTrace.fatal("form", "TypeManager.getDisplayerName", "form.EXP_UNKNOWN_TYPE", typeName);
            throw new FormException("TypeManager", "form.EXP_UNKNOWN_TYPE", typeName);
        }
        return displayerNames.get(0);
    }

    public String[] getDisplayerNames(String typeName) throws FormException {
        List<String> displayerNames = this.typeName2displayerNames.get(typeName);
        if (displayerNames == null || displayerNames.isEmpty()) {
            throw new FormException("TypeManager", "form.EXP_UNKNOWN_TYPE", typeName);
        }
        return displayerNames.toArray(new String[displayerNames.size()]);
    }

    public FieldDisplayer getDisplayer(String typeName, String displayerName) throws FormException {
        String displayerId = this.getDisplayerId(typeName, displayerName);
        Class<?> displayerClass = this.displayerId2displayerClass.get(displayerId);
        if (displayerClass == null) {
            List<String> displayerNames = this.typeName2displayerNames.get(typeName);
            if (displayerNames == null || displayerNames.isEmpty()) {
                throw new FormException("TypeManager", "form.EXP_UNKNOWN_TYPE", typeName);
            }
            throw new FormException("TypeManager", "form.EXP_UNKNOWN_DISPLAYER", displayerName);
        }
        return this.constructDisplayer(displayerClass);
    }

    public void setFieldImplementation(String fieldClassName, String typeName) throws FormException {
        Class<?> fieldImplementation = this.getFieldClass(fieldClassName);
        this.implementations.put(typeName, fieldImplementation);
    }

    public void setDisplayer(String displayerClassName, String typeName, String displayerName, boolean defaultDisplayer) throws FormException {
        Class<?> displayerClass = this.getDisplayerClass(displayerClassName);
        String displayerId = this.getDisplayerId(typeName, displayerName);
        List<String> displayerNames = this.typeName2displayerNames.get(typeName);
        if (displayerNames == null) {
            displayerNames = new ArrayList<String>();
            displayerNames.add(displayerName);
            this.typeName2displayerNames.put(typeName, displayerNames);
        } else if (defaultDisplayer) {
            displayerNames.add(0, displayerName);
        } else {
            displayerNames.add(displayerName);
        }
        this.displayerId2displayerClass.put(displayerId, displayerClass);
    }

    private String getDisplayerId(String typeName, String displayerName) {
        return typeName + '.' + displayerName;
    }

    private String extractTypeName(String identifier) {
        int dot = identifier.indexOf(46);
        if (dot <= 0) {
            return identifier.trim();
        }
        return identifier.substring(0, dot).trim();
    }

    private String extractClassKind(String identifier) {
        int dot = identifier.indexOf(46);
        if (dot == -1 || dot + 1 == identifier.length()) {
            return "";
        }
        String afterFirstDot = identifier.substring(dot + 1);
        if ((dot = afterFirstDot.indexOf(46)) == -1) {
            return afterFirstDot.trim();
        }
        return afterFirstDot.substring(0, dot).trim();
    }

    private String extractDisplayerName(String identifier) {
        int dot = identifier.indexOf(46);
        if (dot == -1 || dot + 1 == identifier.length()) {
            return "";
        }
        String afterFirstDot = identifier.substring(dot + 1);
        if ((dot = afterFirstDot.indexOf(46)) == -1 || dot + 1 == afterFirstDot.length()) {
            return "default";
        }
        return afterFirstDot.substring(dot + 1).trim();
    }

    private Field constructField(Class<?> fieldClass) throws FormException {
        try {
            Class[] noParameterClass = new Class[]{};
            Constructor<?> constructor = fieldClass.getConstructor(noParameterClass);
            return (Field)constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException e) {
            throw new FormFatalException("TypeManager", "form.EXP_MISSING_EMPTY_CONSTRUCTOR", fieldClass.getName(), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new FormFatalException("TypeManager", "form.EXP_NOT_A_FIELD", fieldClass.getName(), (Exception)e);
        }
        catch (Exception e) {
            throw new FormFatalException("TypeManager", "form.EXP_FIELD_CONSTRUCTION_FAILED", fieldClass.getName(), e);
        }
    }

    private FieldDisplayer constructDisplayer(Class<?> displayerClass) throws FormException {
        try {
            Class[] noParameterClass = new Class[]{};
            Constructor<?> constructor = displayerClass.getConstructor(noParameterClass);
            return (FieldDisplayer)constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException e) {
            throw new FormFatalException("TypeManager", "form.EXP_MISSING_EMPTY_CONSTRUCTOR", displayerClass.getName(), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new FormFatalException("TypeManager", "form.EXP_NOT_A_DISPLAYER", displayerClass.getName(), (Exception)e);
        }
        catch (Exception e) {
            throw new FormFatalException("TypeManager", "form.EXP_DISPLAYER_CONSTRUCTION_FAILED", displayerClass.getName(), e);
        }
    }

    private Class<?> getFieldClass(String fieldClassName) throws FormException {
        try {
            Class<?> fieldClass = Class.forName(fieldClassName);
            this.constructField(fieldClass);
            return fieldClass;
        }
        catch (ClassNotFoundException e) {
            throw new FormFatalException("TypeManager", "form.EXP_UNKNOWN_CLASS", fieldClassName, (Exception)e);
        }
    }

    private Class<?> getDisplayerClass(String displayerClassName) throws FormException {
        try {
            Class<?> displayerClass = Class.forName(displayerClassName);
            this.constructDisplayer(displayerClass);
            return displayerClass;
        }
        catch (ClassNotFoundException e) {
            throw new FormFatalException("TypeManager", "form.EXP_UNKNOWN_CLASS", displayerClassName, (Exception)e);
        }
    }

    private void init() throws FormException {
        try {
            ResourceLocator properties = new ResourceLocator("com.silverpeas.form.settings.types", "");
            Enumeration<String> binds = properties.getKeys();
            while (binds.hasMoreElements()) {
                String identifier = binds.nextElement();
                SilverTrace.info("form", "TypeManager.init", "root.MSG_GEN_PARAM_VALUE", "identifier=" + identifier);
                String className = properties.getString(identifier);
                SilverTrace.info("form", "TypeManager.init", "root.MSG_GEN_PARAM_VALUE", "className=" + className);
                String typeName = this.extractTypeName(identifier);
                String classKind = this.extractClassKind(identifier);
                String displayerName = this.extractDisplayerName(identifier);
                if ("implementation".equals(classKind)) {
                    this.setFieldImplementation(className, typeName);
                    continue;
                }
                if (!"displayer".equals(classKind)) continue;
                this.setDisplayer(className, typeName, displayerName, "default".equals(displayerName));
            }
        }
        catch (MissingResourceException e) {
            throw new FormFatalException("TypeManager", "form.EXP_MISSING_DISPLAYER_PROPERTIES", "com.silverpeas.form.settings.types", (Exception)e);
        }
    }
}

