/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.fileupload.FileItem;

public class CheckBoxDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        String[] s = new String[]{"text"};
        return s;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println(" var checked = false;\n");
            out.println(" for (var i = 0; i < " + this.getNbHtmlObjectsDisplayed(template, pagesContext) + "; i++) {\n");
            out.println("   if (document.getElementsByName('" + fieldName + "')[i].checked) {\n");
            out.println("     checked = true;\n");
            out.println("   }\n");
            out.println(" }\n");
            out.println(" if(checked == false) {\n");
            out.println("   errorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("   errorNb++;");
            out.println(" }");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        String selectedValues = "";
        ArrayList<String> valuesFromDB = new ArrayList<String>();
        String keys = "";
        String values = "";
        StringBuilder html = new StringBuilder();
        int cols = 1;
        String language = PagesContext2.getLanguage();
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        if (!field.isNull()) {
            selectedValues = field.getValue(language);
        }
        StringTokenizer st = new StringTokenizer(selectedValues, "##");
        while (st.hasMoreTokens()) {
            valuesFromDB.add(st.nextToken());
        }
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        if (parameters.containsKey("values")) {
            values = parameters.get("values");
        }
        String cssClass = null;
        if (parameters.containsKey("class") && StringUtil.isDefined(cssClass = parameters.get("class"))) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        try {
            if (parameters.containsKey("cols")) {
                cols = Integer.valueOf(parameters.get("cols"));
            }
        }
        catch (NumberFormatException nfe) {
            SilverTrace.error("form", "CheckBoxDisplayer.display", "form.EX_ERR_ILLEGAL_PARAMETER_COL", parameters.get("cols"));
            cols = 1;
        }
        if ("".equals(keys) && !"".equals(values)) {
            keys = values;
        }
        if ("".equals(values) && !"".equals(keys)) {
            values = keys;
        }
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        StringTokenizer stValues = new StringTokenizer(values, "##");
        int nbTokens = this.getNbHtmlObjectsDisplayed(template, PagesContext2);
        if (stKeys.countTokens() != stValues.countTokens()) {
            SilverTrace.error("form", "CheckBoxDisplayer.display", "form.EX_ERR_ILLEGAL_PARAMETERS", "Nb keys=" + stKeys.countTokens() + " & Nb values=" + stValues.countTokens());
        } else {
            html.append("<table border=\"0\">");
            int col = 0;
            for (int i = 0; i < nbTokens; ++i) {
                if (col == 0) {
                    html.append("<tr>");
                }
                ++col;
                html.append("<td>");
                String optKey = stKeys.nextToken();
                String optValue = stValues.nextToken();
                html.append("<input type=\"checkbox\" id=\"").append(fieldName).append("_").append(i);
                html.append("\" name=\"").append(fieldName).append("\" value=\"").append(optKey).append("\" ");
                if (StringUtil.isDefined(cssClass)) {
                    html.append(cssClass);
                }
                if (template.isDisabled() || template.isReadOnly()) {
                    html.append(" disabled=\"disabled\" ");
                }
                if (valuesFromDB.contains(optKey)) {
                    html.append(" checked=\"checked\" ");
                }
                html.append("/>&nbsp;").append(optValue);
                if (i == nbTokens - 1 && template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && PagesContext2.useMandatory()) {
                    html.append(Util.getMandatorySnippet());
                }
                html.append("</td>");
                html.append("\n");
                if (col != cols) continue;
                html.append("</tr>");
                col = 0;
            }
            if (col != 0) {
                html.append("</tr>");
            }
            html.append("</table>");
        }
        out.println(html);
    }

    @Override
    public List<String> update(List<FileItem> items, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        SilverTrace.debug("form", "AbstractForm.getParameterValues", "root.MSG_GEN_ENTER_METHOD", "parameterName = " + template.getFieldName());
        String value = "";
        Iterator<FileItem> iter = items.iterator();
        String parameterName = template.getFieldName();
        while (iter.hasNext()) {
            FileItem item = iter.next();
            if (!parameterName.equals(item.getFieldName())) continue;
            value = value + item.getString();
            if (!iter.hasNext()) continue;
            value = value + "##";
        }
        SilverTrace.debug("form", "AbstractForm.getParameterValues", "root.MSG_GEN_EXIT_METHOD", "parameterValue = " + value);
        if (pageContext.getUpdatePolicy() == 1 && !StringUtil.isDefined(value)) {
            return new ArrayList<String>();
        }
        return this.update(value, field, template, pageContext);
    }

    @Override
    public List<String> update(String values, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("CheckBoxDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        String valuesToInsert = values;
        if (!field.acceptValue(valuesToInsert, PagesContext2.getLanguage())) {
            throw new FormException("CheckBoxDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(valuesToInsert, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        String keys = "";
        String values = "";
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        if (parameters.containsKey("values")) {
            values = parameters.get("values");
        }
        if (keys.equals("") && !values.equals("")) {
            keys = values;
        }
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        return stKeys.countTokens();
    }
}

