/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.GroupField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.web.servlet.FileUploadUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;

public class GroupFieldDisplayer
extends AbstractFieldDisplayer<GroupField> {
    public String[] getManagedTypes() {
        return new String[]{"group"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
        String language = PagesContext2.getLanguage();
        if (!"group".equals(template.getTypeName())) {
            SilverTrace.info("form", "GroupFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "group");
        }
        if (template.isMandatory() && PagesContext2.useMandatory()) {
            out.println("   if (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("      errorMsg+=\"  - '" + EncodeHelper.javaStringToJsString(template.getLabel(language)) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("      errorNb++;");
            out.println("   }");
        }
        Util.getJavascriptChecker(template.getFieldName(), PagesContext2, out);
    }

    @Override
    public void display(PrintWriter out, GroupField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        SilverTrace.info("form", "GroupFieldDisplayer.display", "root.MSG_GEN_ENTER_METHOD", "fieldName = " + template.getFieldName() + ", value = " + field.getValue() + ", fieldType = " + field.getTypeName());
        String language = pageContext.getLanguage();
        String selectGroupImg = Util.getIcon("groupPanel");
        String selectGroupLab = Util.getString("groupPanel", language);
        String deleteImg = Util.getIcon("delete");
        String deleteLab = Util.getString("clearGroup", language);
        String groupName = "";
        String groupId = "";
        StringBuilder html = new StringBuilder();
        String fieldName = template.getFieldName();
        if (!"group".equals(field.getTypeName())) {
            SilverTrace.info("form", "GroupFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "group");
        } else {
            groupId = field.getGroupId();
        }
        if (!field.isNull()) {
            groupName = field.getValue();
        }
        html.append("<input type=\"hidden\" id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\" value=\"").append(EncodeHelper.javaStringToHtmlString(groupId)).append("\" />");
        if (!template.isHidden()) {
            html.append("<input type=\"text\" disabled=\"disabled\" size=\"50\"  id=\"").append(fieldName).append("_name\" name=\"").append(fieldName).append("$$name\" value=\"").append(EncodeHelper.javaStringToHtmlString(groupName)).append("\" />");
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            boolean groupsOfInstanceOnly = StringUtil.getBooleanValue(parameters.get("groupsOfInstanceOnly"));
            String roles = parameters.get("roles");
            if (StringUtil.isDefined(roles)) {
                groupsOfInstanceOnly = true;
            }
            html.append("&nbsp;<a href=\"#\" onclick=\"javascript:SP_openWindow('").append(URLManager.getApplicationURL()).append("/RselectionPeasWrapper/jsp/open?formName=").append(pageContext.getFormName()).append("&elementId=").append(fieldName).append("&elementName=").append(fieldName).append("_name").append("&selectable=").append(1).append("&selectedGroup=").append(groupId == null ? "" : groupId).append(groupsOfInstanceOnly ? "&instanceId=" + pageContext.getComponentId() : "").append(StringUtil.isDefined(roles) ? "&roles=" + roles : "").append("','selectGroup',800,600,'');\" >");
            html.append("<img src=\"").append(selectGroupImg).append("\" width=\"15\" height=\"15\" border=\"0\" alt=\"").append(selectGroupLab).append("\" align=\"top\" title=\"").append(selectGroupLab).append("\"/></a>");
            html.append("&nbsp;<a href=\"#\" onclick=\"javascript:document.").append(pageContext.getFormName()).append(".").append(fieldName).append(".value='';document.").append(pageContext.getFormName()).append(".").append(fieldName).append("$$name.value='';\">");
            html.append("<img src=\"").append(deleteImg).append("\" width=\"15\" height=\"15\" border=\"0\" alt=\"").append(deleteLab).append("\" align=\"top\" title=\"").append(deleteLab).append("\"/></a>");
            if (template.isMandatory() && pageContext.useMandatory()) {
                html.append(Util.getMandatorySnippet());
            }
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newId, GroupField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (field.getTypeName().equals("group")) {
            if (!StringUtil.isDefined(newId)) {
                field.setNull();
            } else {
                field.setGroupId(newId);
            }
        } else {
            throw new FormException("GroupFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "group");
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }

    @Override
    public List<String> update(List<FileItem> items, GroupField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String itemName = template.getFieldName();
        String value = FileUploadUtil.getParameter(items, itemName);
        if (pageContext.getUpdatePolicy() == 1 && !StringUtil.isDefined(value)) {
            return new ArrayList<String>();
        }
        return this.update(value, field, template, pageContext);
    }
}

