/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.GalleryHelper;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RenderingContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFileFieldDisplayer;
import com.silverpeas.form.fieldType.FileField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ImageUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.web.servlet.FileUploadUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.FileServerUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.wysiwyg.control.WysiwygController;

public class ImageFieldDisplayer
extends AbstractFileFieldDisplayer {
    public static final String CONTEXT_FORM_IMAGE = "XMLFormImages";

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) throws IOException {
        String language = pageContext.getLanguage();
        String fieldName = template.getFieldName();
        if (template.isMandatory() && pageContext.useMandatory()) {
            out.println("\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\tvar " + fieldName + "Value = document.getElementById('" + fieldName + "_id" + "').value;");
            out.println("\t\tif (" + fieldName + "Value=='' || " + fieldName + "Value.substring(0,7)==\"remove_\") {");
            out.println("\t\t\terrorMsg+=\"  - '" + EncodeHelper.javaStringToJsString(template.getLabel(language)) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("\t\t\terrorNb++;");
            out.println("\t\t}");
            out.println("\t}");
        }
        Util.includeFileNameLengthChecker(template, pageContext, out);
        Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
    }

    @Override
    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        this.display(out, field, template, pagesContext, FileServerUtils.getApplicationContext());
    }

    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pagesContext, String webContext) throws FormException {
        SimpleDocumentPK attachmentPk;
        SilverTrace.info("form", "ImageFieldDisplayer.display", "root.MSG_GEN_ENTER_METHOD", "fieldName = " + template.getFieldName() + ", value = " + field.getValue() + ", fieldType = " + field.getTypeName());
        String fieldName = template.getFieldName();
        String language = pagesContext.getLanguage();
        String componentId = pagesContext.getComponentId();
        String attachmentId = field.getValue();
        if (StringUtil.isLong(attachmentId)) {
            attachmentPk = new SimpleDocumentPK(null, componentId);
            attachmentPk.setOldSilverpeasId(Long.parseLong(attachmentId));
        } else {
            attachmentPk = new SimpleDocumentPK(attachmentId, componentId);
        }
        SimpleDocument attachment = null;
        String imageURL = null;
        if (StringUtil.isDefined(attachmentId)) {
            if (attachmentId.startsWith("/")) {
                imageURL = attachmentId;
            } else {
                attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(attachmentPk, language);
                if (attachment != null) {
                    imageURL = pagesContext.getRenderingContext() == RenderingContext.EXPORT ? "file:" + attachment.getAttachmentPath() : webContext + attachment.getAttachmentURL();
                }
            }
        } else {
            attachmentId = "";
        }
        Map<String, String> parameters = template.getParameters(language);
        if (template.isReadOnly() && !template.isHidden()) {
            if (imageURL != null) {
                String height = parameters.containsKey("height") ? parameters.get("height") : "";
                String width = parameters.containsKey("width") ? parameters.get("width") : "";
                String paramHeight = "";
                String paramWidth = "";
                if (StringUtil.isDefined(width) && StringUtil.isDefined(height)) {
                    paramWidth = " width=\"" + width + "\" ";
                    paramHeight = " height=\"" + height + "\" ";
                } else {
                    String[] paramSize;
                    if (StringUtil.isDefined(width) && attachment != null) {
                        paramSize = ImageUtil.getWidthAndHeightByWidth(new File(attachment.getAttachmentPath()), Integer.parseInt(width));
                        if (StringUtil.isDefined(paramSize[0])) {
                            paramWidth = " width=\"" + paramSize[0] + "\" ";
                        }
                        if (StringUtil.isDefined(paramSize[1])) {
                            paramHeight = " height=\"" + paramSize[1] + "\" ";
                        }
                    }
                    if (StringUtil.isDefined(height) && attachment != null) {
                        paramSize = ImageUtil.getWidthAndHeightByHeight(new File(attachment.getAttachmentPath()), Integer.parseInt(height));
                        if (StringUtil.isDefined(paramSize[0])) {
                            paramWidth = " width=\"" + paramSize[0] + "\" ";
                        }
                        if (StringUtil.isDefined(paramSize[1])) {
                            paramHeight = " height=\"" + paramSize[1] + "\" ";
                        }
                    }
                }
                out.print("<img alt=\"\" src=\"");
                out.print(imageURL);
                out.print("\"");
                out.print(paramHeight);
                out.print(paramWidth);
                out.print("/>");
            }
        } else if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            List<ComponentInstLight> galleries;
            String displayCSS = "display:none";
            if (imageURL != null) {
                displayCSS = "display:block";
            }
            String deleteImg = Util.getIcon("delete");
            String deleteLab = Util.getString("removeImage", language);
            out.println("<div id=\"" + fieldName + "ThumbnailArea\" style=\"" + displayCSS + "\">");
            out.println("<a id=\"" + fieldName + "ThumbnailLink\" href=\"" + imageURL + "\" target=\"_blank\">");
            out.println("<img alt=\"\" align=\"top\" src=\"" + imageURL + "\" height=\"50\" id=\"" + fieldName + "Thumbnail\"/>&nbsp;");
            out.println("</a>");
            out.println("&nbsp;<a href=\"#\" onclick=\"javascript:document.getElementById('" + fieldName + "ThumbnailArea').style.display='none';" + "document." + pagesContext.getFormName() + "." + fieldName + "$$id" + ".value='remove_" + attachmentId + "';" + "\">");
            out.println("<img src=\"" + deleteImg + "\" width=\"15\" height=\"15\" alt=\"" + deleteLab + "\" align=\"top\" title=\"" + deleteLab + "\"/></a>");
            out.println("</div>");
            out.println("<div id=\"" + fieldName + "SelectionArea\">");
            out.print("<input type=\"file\" size=\"50\" id=\"");
            out.print(fieldName);
            out.print("\" name=\"");
            out.print(fieldName);
            out.println("\"/>");
            out.println("<input type=\"hidden\" name=\"" + fieldName + "$$id" + "\" id=\"" + fieldName + "_id" + "\" value=\"" + attachmentId + "\"/>");
            boolean useGalleries = Util.getBooleanValue(parameters, "galleries");
            String fieldNameFunction = FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'));
            if (useGalleries && (galleries = WysiwygController.getGalleries()) != null && !galleries.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" ").append(Util.getString("GML.or", language)).append(" ");
                stringBuilder.append("<select id=\"galleryFile_").append(fieldName).append("\" name=\"componentId\" onchange=\"openGalleryFileManager").append(fieldNameFunction).append("();this.selectedIndex=0\">");
                stringBuilder.append("<option value=\"\">");
                stringBuilder.append(Util.getString("GML.galleries", language));
                stringBuilder.append("</option>");
                for (ComponentInstLight component : galleries) {
                    stringBuilder.append("<option value=\"").append(component.getId()).append("\">").append(component.getLabel(language)).append("</option>");
                }
                stringBuilder.append("</select>");
                out.println(stringBuilder.toString());
            }
            if (template.isMandatory() && pagesContext.useMandatory()) {
                out.println(Util.getMandatorySnippet());
            }
            out.println("</div>");
            out.println("<script type=\"text/javascript\">");
            GalleryHelper.getJavaScript(fieldNameFunction, fieldName, language, out);
            out.println("function choixImageInGallery" + fieldNameFunction + "(url){");
            out.println("$(\"#" + fieldName + "ThumbnailArea\").css(\"display\", \"block\");");
            out.println("$(\"#" + fieldName + "Thumbnail\").attr(\"src\", url);");
            out.println("$(\"#" + fieldName + "ThumbnailLink\").attr(\"href\", url);");
            out.println("$(\"#" + fieldName + "_id" + "\").attr(\"value\", url);");
            out.println("}");
            out.println("</script>");
        }
    }

    @Override
    public List<String> update(String attachmentId, FileField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        if ("file".equals(field.getTypeName())) {
            if (!StringUtil.isDefined(attachmentId)) {
                field.setNull();
            } else {
                field.setAttachmentId(attachmentId);
                attachmentIds.add(attachmentId);
            }
        } else {
            throw new FormException("ImageFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "file");
        }
        return attachmentIds;
    }

    @Override
    public List<String> update(List<FileItem> items, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        String itemName = template.getFieldName();
        try {
            String value = this.processUploadedImage(items, itemName, pageContext);
            String param = FileUploadUtil.getParameter(items, itemName + "$$id");
            if (param != null && !pageContext.isCreation()) {
                if (param.startsWith("remove_")) {
                    String attachmentId = field.getAttachmentId();
                    if (!attachmentId.startsWith("/")) {
                        this.deleteAttachment(attachmentId, pageContext);
                    } else {
                        value = null;
                    }
                } else if (value != null && StringUtil.isInteger(param)) {
                    this.deleteAttachment(param, pageContext);
                } else if (value == null) {
                    if (param.startsWith("/")) {
                        value = param;
                    } else {
                        return attachmentIds;
                    }
                }
            }
            if (pageContext.getUpdatePolicy() == 1 && !StringUtil.isDefined(value)) {
                return attachmentIds;
            }
            attachmentIds.addAll(this.update(value, field, template, pageContext));
        }
        catch (IOException e) {
            SilverTrace.error("form", "ImageFieldDisplayer.update", "form.EXP_UNKNOWN_FIELD", null, e);
        }
        return attachmentIds;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }

    private String processUploadedImage(List<FileItem> items, String parameterName, PagesContext pagesContext) throws IOException {
        String attachmentId = null;
        FileItem item = FileUploadUtil.getFile(items, parameterName);
        if (item != null && !item.isFormField()) {
            String componentId = pagesContext.getComponentId();
            String userId = pagesContext.getUserId();
            String objectId = pagesContext.getObjectId();
            if (StringUtil.isDefined(item.getName())) {
                String fileName = FileUtil.getFilename(item.getName());
                long size = item.getSize();
                if (size > 0L) {
                    SimpleDocument document = this.createSimpleDocument(objectId, componentId, item, fileName, userId);
                    attachmentId = document.getId();
                }
            }
        }
        return attachmentId;
    }
}

