/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.JdbcField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DBUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JdbcFieldDisplayer
extends AbstractFieldDisplayer<JdbcField> {
    private static final String[] MANAGED_TYPES = new String[]{"jdbc"};
    private static final String mandatoryImg = Util.getIcon("mandatoryField");

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println("\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("\t\terrorNb++;");
            out.println("\t}");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(PrintWriter out, JdbcField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String currentUserId = pagesContext.getUserId();
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        String value = "";
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        String valueFieldType = "1";
        if (parameters.containsKey("valueFieldType")) {
            valueFieldType = parameters.get("valueFieldType");
        }
        Collection<String> listRes = null;
        if (field != null) {
            Connection jdbcConnection = null;
            try {
                jdbcConnection = field.connectJdbc(parameters.get("driverName"), parameters.get("url"), parameters.get("login"), parameters.get("password"));
                listRes = field.selectSql(jdbcConnection, parameters.get("query"), currentUserId);
            }
            catch (Throwable throwable) {
                DBUtil.close(jdbcConnection);
                throw throwable;
            }
            DBUtil.close(jdbcConnection);
        }
        StringBuilder html = new StringBuilder(10000);
        if (listRes != null && !listRes.isEmpty()) {
            String displayer = parameters.get("displayer");
            if (!StringUtil.isDefined(displayer)) {
                displayer = "autocomplete";
            }
            if ("autocomplete".equals(displayer)) {
                this.getAutocompleteFragment(template, value, valueFieldType, listRes, pagesContext, html);
            } else {
                this.getListboxFragment(template, value, valueFieldType, listRes, pagesContext, html);
            }
        } else {
            if ("1".equals(valueFieldType)) {
                html.append("<select name=\"").append(fieldName).append("\"");
                if (template.isDisabled() || template.isReadOnly()) {
                    html.append(" disabled");
                }
                html.append(" >\n");
                html.append("</select>\n");
            } else {
                html.append("<input type=\"text\" name=\"").append(fieldName).append("\"");
                if (template.isDisabled() || template.isReadOnly()) {
                    html.append(" disabled=\"disabled\"");
                }
                html.append(" />\n");
            }
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden()) {
                html.append("&nbsp;<img src=\"").append(mandatoryImg).append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\"/>&nbsp;\n");
            }
        }
        out.println(html.toString());
    }

    private void getAutocompleteFragment(FieldTemplate template, String fieldValue, String valueFieldType, Collection<String> entries, PagesContext pageContext, StringBuilder html) {
        String fieldName = template.getFieldName();
        int zindex = (pageContext.getLastFieldIndex() - Integer.parseInt(pageContext.getCurrentFieldIndex())) * 9000;
        html.append("<style type=\"text/css\">\n").append(" #listAutocomplete").append(fieldName).append(" {\n");
        html.append("  width:15em;\n");
        html.append("  padding-bottom:2em;\n");
        html.append(" }\n");
        html.append(" #listAutocomplete").append(fieldName).append(" {\n");
        html.append("  z-index:").append(zindex).append("; /* z-index needed on top instance for ie & sf absolute inside relative issue */\n");
        html.append(" }\n");
        html.append(" #").append(fieldName).append(" {\n");
        html.append("  _position:absolute; /* abs pos needed for ie quirks */\n");
        html.append(" }\n");
        html.append("</style>\n");
        html.append("<div id=\"listAutocomplete").append(fieldName).append("\">\n");
        html.append("<input id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\" type=\"text\"");
        if (fieldValue != null) {
            html.append(" value=\"").append(fieldValue).append("\"");
        }
        if (template.isDisabled() || template.isReadOnly()) {
            html.append(" disabled");
        }
        html.append("/>\n");
        html.append("<div id=\"container").append(fieldName).append("\"/>\n");
        html.append("</div>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            html.append("<img src=\"").append(mandatoryImg).append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\" style=\"position:absolute;left:16em;top:5px\"/>\n");
        }
        html.append("<script type=\"text/javascript\">\n");
        html.append("listArray").append(fieldName).append(" = [\n");
        Iterator<String> itRes = entries.iterator();
        while (itRes.hasNext()) {
            html.append("\"").append(EncodeHelper.javaStringToJsString(itRes.next())).append("\"");
            if (!itRes.hasNext()) continue;
            html.append(",\n");
        }
        html.append("];\n");
        html.append("</script>\n");
        html.append("<script type=\"text/javascript\">\n");
        html.append(" this.oACDS").append(fieldName).append(" = new YAHOO.util.LocalDataSource(listArray").append(fieldName).append(");\n");
        html.append(" this.oAutoComp").append(fieldName).append(" = new YAHOO.widget.AutoComplete('").append(fieldName).append("','container").append(fieldName).append("', this.oACDS").append(fieldName).append(");\n");
        html.append(" this.oAutoComp").append(fieldName).append(".prehighlightClassName = \"yui-ac-prehighlight\";\n");
        html.append(" this.oAutoComp").append(fieldName).append(".typeAhead = true;\n");
        html.append(" this.oAutoComp").append(fieldName).append(".useShadow = true;\n");
        html.append(" this.oAutoComp").append(fieldName).append(".minQueryLength = 0;\n");
        if ("1".equals(valueFieldType)) {
            html.append(" this.oAutoComp").append(fieldName).append(".forceSelection = true;\n");
        }
        html.append(" this.oAutoComp").append(fieldName).append(".textboxFocusEvent.subscribe(function(){\n");
        html.append("  var sInputValue = YAHOO.util.Dom.get('").append(fieldName).append("').value;\n");
        html.append("  if(sInputValue.length == 0) {\n");
        html.append("   var oSelf = this;\n");
        html.append("   setTimeout(function(){oSelf.sendQuery(sInputValue);},0);\n");
        html.append("  }\n");
        html.append(" });\n");
        html.append("</script>\n");
    }

    private void getListboxFragment(FieldTemplate template, String fieldValue, String valueFieldType, Collection<String> entries, PagesContext pageContext, StringBuilder html) {
        html.append("<select name=\"").append(template.getFieldName()).append("\"");
        if (template.isDisabled() || template.isReadOnly()) {
            html.append(" disabled=\"disabled\"");
        }
        html.append(" >\n");
        html.append("<option></option>");
        for (String entry : entries) {
            html.append("<option");
            if (entry.equals(fieldValue)) {
                html.append(" selected=\"selected\"");
            }
            html.append(" value=\"").append(entry).append("\">").append(entry).append("</option>\n");
        }
        html.append("</select>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            html.append(Util.getMandatorySnippet());
        }
    }

    @Override
    public List<String> update(String newValue, JdbcField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"jdbc".equals(field.getTypeName())) {
            throw new FormException("JdbcFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "jdbc");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("JdbcFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "jdbc");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

