/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ListBoxFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
        String language = PagesContext2.getLanguage();
        if (!"text".equals(template.getTypeName())) {
            SilverTrace.info("form", "TextAreaFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (template.isMandatory() && PagesContext2.useMandatory()) {
            out.println("\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("\t\terrorNb++;");
            out.println("\t}");
        }
        Util.getJavascriptChecker(template.getFieldName(), PagesContext2, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        String value = "";
        String keys = "";
        String html = "";
        String language = PagesContext2.getLanguage();
        String cssClass = null;
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        if (!"text".equals(field.getTypeName())) {
            SilverTrace.info("form", "ListBoxFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        if (parameters.containsKey("class") && StringUtil.isDefined(cssClass = parameters.get("class"))) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        html = StringUtil.isDefined(cssClass) ? html + "<select " + cssClass + " id=\"" + fieldName + "\" name=\"" + fieldName + "\"" : html + "<select id=\"" + fieldName + "\" name=\"" + fieldName + "\"";
        if (template.isDisabled() || template.isReadOnly()) {
            html = html + " disabled";
        }
        html = html + " >\n";
        html = html + "<option value=\"\"></option>\n";
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        String values = parameters.containsKey("values") ? parameters.get("values") : keys;
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        StringTokenizer stValues = new StringTokenizer(values, "##");
        int nbTokens = stKeys.countTokens();
        if (stKeys.countTokens() != stValues.countTokens()) {
            SilverTrace.error("form", "ListBoxFieldDisplayer.display", "form.EX_ERR_ILLEGAL_PARAMETERS", "Nb keys=" + stKeys.countTokens() + " & Nb values=" + stValues.countTokens());
        } else {
            for (int i = 0; i < nbTokens; ++i) {
                String optKey = stKeys.nextToken();
                String optValue = stValues.nextToken();
                html = html + "<option ";
                if (optKey.equals(value)) {
                    html = html + "selected=\"selected\" ";
                }
                html = html + "value=\"" + optKey + "\">" + optValue + "</option>\n";
            }
        }
        html = html + "</select>\n";
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && PagesContext2.useMandatory()) {
            html = html + Util.getMandatorySnippet();
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("TextAreaFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("TextAreaFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

