/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class RadioButtonDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        String[] s = new String[]{};
        s[0] = "text";
        return s;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        if (!"text".equals(template.getTypeName())) {
            SilverTrace.info("form", "RadioButtonDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println(" var checked = $('input[type=radio][name=" + fieldName + "]:checked').length == 1;\n");
            out.println(" if(checked == false) {");
            out.println("   errorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\";");
            out.println("   errorNb++;");
            out.println(" }");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value = "";
        String keys = "";
        String values = "";
        String html = "";
        int cols = 1;
        String defaultValue = "";
        String language = pageContext.getLanguage();
        String cssClass = null;
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        if (!"text".equals(field.getTypeName())) {
            SilverTrace.info("form", "RadioButtonDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        if (parameters.containsKey("values")) {
            values = parameters.get("values");
        }
        if (parameters.containsKey("class") && StringUtil.isDefined(cssClass = parameters.get("class"))) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        try {
            if (parameters.containsKey("cols")) {
                cols = Integer.valueOf(parameters.get("cols"));
            }
        }
        catch (NumberFormatException nfe) {
            SilverTrace.error("form", "RadioButtonDisplayer.display", "form.EX_ERR_ILLEGAL_PARAMETER_COL", parameters.get("cols"));
            cols = 1;
        }
        if (parameters.containsKey("default") && !pageContext.isIgnoreDefaultValues()) {
            defaultValue = parameters.get("default");
        }
        if (!StringUtil.isDefined(value)) {
            value = defaultValue;
        }
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (keys.equals("") && !values.equals("")) {
            keys = values;
        }
        if (values.equals("") && !keys.equals("")) {
            values = keys;
        }
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        StringTokenizer stValues = new StringTokenizer(values, "##");
        int nbTokens = this.getNbHtmlObjectsDisplayed(template, pageContext);
        if (stKeys.countTokens() != stValues.countTokens()) {
            SilverTrace.error("form", "RadioButtonDisplayer.display", "form.EX_ERR_ILLEGAL_PARAMETERS", "Nb keys=" + stKeys.countTokens() + " & Nb values=" + stValues.countTokens());
        } else {
            html = html + "<table border=\"0\">";
            int col = 0;
            for (int i = 0; i < nbTokens; ++i) {
                if (col == 0) {
                    html = html + "<tr>";
                }
                ++col;
                html = html + "<td>";
                String optKey = stKeys.nextToken();
                String optValue = stValues.nextToken();
                if (StringUtil.isDefined(cssClass)) {
                    html = html + "<span " + cssClass + ">";
                }
                html = html + "<input type=\"radio\" id=\"" + fieldName + "_" + i + "\" name=\"" + fieldName + "\" value=\"" + optKey + "\" ";
                if (template.isDisabled() || template.isReadOnly()) {
                    html = html + " disabled=\"disabled\" ";
                }
                if (optKey.equals(value)) {
                    html = html + " checked=\"checked\" ";
                }
                html = html + "/>&nbsp;" + optValue;
                if (StringUtil.isDefined(cssClass)) {
                    html = html + "</span>";
                }
                if (i == nbTokens - 1 && template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
                    html = html + Util.getMandatorySnippet();
                }
                html = html + "</td>";
                if (col != cols) continue;
                html = html + "</tr>";
                col = 0;
            }
            if (col != 0) {
                html = html + "</tr>";
            }
            html = html + "</table>";
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("TextAreaFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("TextAreaFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        String keys = "";
        String values = "";
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        if (parameters.containsKey("values")) {
            values = parameters.get("values");
        }
        if (keys.equals("") && !values.equals("")) {
            keys = values;
        }
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        return stKeys.countTokens();
    }
}

