/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextAreaFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public static final String PARAM_ROWS = "rows";
    public static final String PARAM_COLS = "cols";

    public String[] getManagedTypes() {
        String[] s = new String[]{};
        s[0] = "text";
        return s;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) throws IOException {
        String language = pageContext.getLanguage();
        if (!"text".equals(template.getTypeName())) {
            SilverTrace.info("form", "TextAreaFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (template.isMandatory() && pageContext.useMandatory()) {
            out.println("\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("\t\terrorNb++;");
            out.println("\t}");
        }
        String maxLength = this.getMaxLength(template, pageContext);
        out.println("\tif (! isValidText(field, " + maxLength + ")) {");
        out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("ContainsTooLargeText", language) + maxLength + " " + Util.getString("Characters", language) + "\\n \";");
        out.println("\t\terrorNb++;");
        out.println("\t}");
        Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
    }

    private String getMaxLength(FieldTemplate fieldTemplate, PagesContext pageContext) {
        String value;
        Map<String, String> parameters = fieldTemplate.getParameters(pageContext.getLanguage());
        if (parameters.containsKey("maxLength") && StringUtil.isInteger(value = parameters.get("maxLength"))) {
            return value;
        }
        return Util.getSetting("nbMaxCar");
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        String value = "";
        String rows = "8";
        String cols = "100";
        String html = "";
        String cssClass = null;
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(PagesContext2.getLanguage());
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextAreaFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (!field.isNull()) {
            value = field.getValue(PagesContext2.getLanguage());
        }
        if (parameters.containsKey("class") && StringUtil.isDefined(cssClass = parameters.get("class"))) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        if (StringUtil.isDefined(cssClass)) {
            html = html + "<span " + cssClass + ">";
        }
        html = html + "<textarea id=\"" + fieldName + "\" name=\"" + fieldName + "\"";
        if (parameters.containsKey(PARAM_ROWS)) {
            rows = parameters.get(PARAM_ROWS);
        }
        html = html + " rows=\"" + rows + "\"";
        if (parameters.containsKey(PARAM_COLS)) {
            cols = parameters.get(PARAM_COLS);
        }
        html = html + " cols=\"" + cols + "\"";
        if (template.isDisabled()) {
            html = html + " disabled=\"disabled\"";
        } else if (template.isReadOnly()) {
            html = html + " readonly=\"readonly\"";
        }
        html = html + " >" + EncodeHelper.javaStringToHtmlString(value) + "</textarea>";
        if (StringUtil.isDefined(cssClass)) {
            html = html + "</span>";
        }
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && PagesContext2.useMandatory()) {
            html = html + Util.getMandatorySnippet();
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("TextAreaFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("TextAreaFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

