/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TextDisplayer
extends AbstractFieldDisplayer<Field> {
    public String[] getManagedTypes() {
        String[] s = new String[]{"text", "date"};
        return s;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
    }

    @Override
    public void display(PrintWriter out, Field field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        StringBuilder html = new StringBuilder(10000);
        String language = pagesContext.getLanguage();
        Map<String, String> parameters = template.getParameters(language);
        String value = "";
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        if (field.getTypeName().equals("date")) {
            try {
                value = DateUtil.getOutputDate(field.getValue(), pagesContext.getLanguage());
            }
            catch (Exception e) {
                SilverTrace.error("form", "TextDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "value = " + field.getValue(), e);
            }
        }
        String classe = null;
        if (parameters.containsKey("class") && (classe = parameters.get("class")) != null) {
            classe = "class=" + classe;
        }
        if (parameters.containsKey("values") || parameters.containsKey("keys")) {
            Map<String, String> keyValuePairs = ((GenericFieldTemplate)template).getKeyValuePairs(language);
            String newValue = "";
            if (StringUtil.isDefined(value)) {
                if (value.contains("##")) {
                    StringTokenizer tokenizer = new StringTokenizer(value, "##");
                    String t = null;
                    while (tokenizer.hasMoreTokens()) {
                        t = tokenizer.nextToken();
                        t = keyValuePairs.get(t);
                        newValue = newValue + t;
                        if (!tokenizer.hasMoreTokens()) continue;
                        newValue = newValue + ", ";
                    }
                } else {
                    newValue = keyValuePairs.get(value);
                }
            }
            value = newValue;
        }
        if (StringUtil.isDefined(classe)) {
            html.append("<span ").append(classe).append(">");
        }
        if (parameters.containsKey("fontSize") || parameters.containsKey("fontColor") || parameters.containsKey("fontFace")) {
            html.append("<font");
        }
        String size = "";
        if (parameters.containsKey("fontSize")) {
            size = parameters.get("fontSize");
            html.append(" size=\"").append(size).append("\"");
        }
        String color = "";
        if (parameters.containsKey("fontColor")) {
            color = parameters.get("fontColor");
            html.append(" color=\"").append(color).append("\"");
        }
        String face = "";
        if (parameters.containsKey("fontFace")) {
            face = parameters.get("fontFace");
            html.append(" face=\"").append(face).append("\"");
        }
        if (StringUtil.isDefined(size) || StringUtil.isDefined(color) || StringUtil.isDefined(face)) {
            html.append(">");
        }
        String bold = "";
        if (parameters.containsKey("bold") && "true".equals(bold = parameters.get("bold"))) {
            html.append("<b>");
        }
        html.append(EncodeHelper.javaStringToHtmlParagraphe(value));
        if (StringUtil.isDefined(bold)) {
            html.append("</b>");
        }
        if (StringUtil.isDefined(size) || StringUtil.isDefined(color) || StringUtil.isDefined(face)) {
            html.append("</font>");
        }
        if (StringUtil.isDefined(classe)) {
            html.append("</span>");
        }
        out.println(html.toString());
    }

    @Override
    public List<String> update(String newValue, Field field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return false;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 0;
    }
}

