/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.form.fieldType.TextFieldImpl;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class TextFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    private static final String[] MANAGED_TYPES = new String[]{"text"};

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        Map<String, String> parameters;
        String contentType;
        String language = pagesContext.getLanguage();
        String label = template.getLabel(language);
        if (!template.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        StringBuilder script = new StringBuilder(10000);
        if (template.isMandatory() && pagesContext.useMandatory()) {
            script.append("\t\tif (isWhitespace(stripInitialWhitespace(field.value))) {\n");
            script.append("\t\t\terrorMsg+=\"  - '").append(label).append("' ").append(Util.getString("GML.MustBeFilled", language)).append("\\n\";\n");
            script.append("\t\t\terrorNb++;\n");
            script.append("\t\t}\n");
        }
        if ((contentType = (parameters = template.getParameters(pagesContext.getLanguage())).get("contentType")) != null) {
            if (contentType.equals("int")) {
                script.append("\t\tif (field.value != \"\" && !(/^-?\\d+$/.test(field.value))) {\n");
                script.append("\t\t\terrorMsg+=\"  - '").append(label).append("' ").append(Util.getString("GML.MustContainsNumber", language)).append("\\n\";\n");
                script.append("\t\t\terrorNb++;\n");
                script.append("\t\t}\n");
            } else if (contentType.equals("float")) {
                script.append("\t\tfield.value = field.value.replace(\",\", \".\")\n");
                script.append("\t\tif (field.value != \"\" && !(/^([+-]?(((\\d+(\\.)?)|(\\d*\\.\\d+))");
                script.append("([eE][+-]?\\d+)?))$/.test(field.value))) {\n");
                script.append("\t\t\terrorMsg+=\"  - '").append(label).append("' ");
                script.append(Util.getString("GML.MustContainsFloat", language)).append("\\n\";\n");
                script.append("\t\t\terrorNb++;\n");
                script.append("\t\t}\n");
            }
        }
        String nbMaxCar = parameters.containsKey("maxLength") ? parameters.get("maxLength") : Util.getSetting("nbMaxCar");
        script.append("\t\tif (! isValidText(field, ").append(nbMaxCar).append(")) {\n");
        script.append("\t\t\terrorMsg+=\"  - '").append(label).append("' ").append(Util.getString("ContainsTooLargeText", language)).append(nbMaxCar).append(" ").append(Util.getString("Characters", language)).append("\\n\";\n");
        script.append("\t\t\terrorNb++;\n");
        script.append("\t\t}\n");
        out.print(script.toString());
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        String defaultValue;
        if (field == null) {
            return;
        }
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String paramSuggestions = parameters.containsKey("suggestions") ? parameters.get("suggestions") : "false";
        boolean useSuggestions = Boolean.valueOf(paramSuggestions);
        List<String> suggestions = null;
        if (useSuggestions) {
            TextFieldImpl textField = (TextFieldImpl)field;
            suggestions = textField.getSuggestions(fieldName, template.getTemplateName(), pageContext.getComponentId());
        }
        String cssClass = null;
        if (parameters.containsKey("class") && (cssClass = parameters.get("class")) != null) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        String string = defaultValue = parameters.containsKey("default") ? parameters.get("default") : "";
        if (pageContext.isIgnoreDefaultValues()) {
            defaultValue = "";
        }
        String string2 = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        input textInput = new input();
        textInput.setName(template.getFieldName());
        textInput.setID(template.getFieldName());
        textInput.setValue(EncodeHelper.javaStringToHtmlString(value));
        textInput.setType(template.isHidden() ? "hidden" : "text");
        textInput.setMaxlength(parameters.containsKey("maxLength") ? parameters.get("maxLength") : "1000");
        textInput.setSize(parameters.containsKey("size") ? parameters.get("size") : "50");
        if (parameters.containsKey("border")) {
            textInput.setBorder(Integer.parseInt(parameters.get("border")));
        }
        if (template.isDisabled()) {
            textInput.setDisabled(true);
        } else if (template.isReadOnly()) {
            textInput.setReadOnly(true);
        }
        if (StringUtil.isDefined(cssClass)) {
            textInput.setClass(cssClass);
        }
        img image = null;
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            image = new img();
            image.setSrc(Util.getIcon("mandatoryField"));
            image.setWidth(5);
            image.setHeight(5);
            image.setBorder(0);
        }
        if (suggestions != null && suggestions.size() > 0) {
            TextFieldImpl.printSuggestionsIncludes(pageContext, fieldName, out);
            out.println("<div id=\"listAutocomplete" + fieldName + "\">\n");
            out.println(textInput.toString());
            out.println("<div id=\"container" + fieldName + "\"/>\n");
            out.println("</div>\n");
            if (image != null) {
                image.setStyle("position:absolute;left:16em;top:5px");
                out.println(image.toString());
            }
            TextFieldImpl.printSuggestionsScripts(pageContext, fieldName, suggestions, out);
        } else if (image != null) {
            ElementContainer container = new ElementContainer();
            container.addElement((Element)textInput);
            container.addElement("&nbsp;");
            container.addElement((Element)image);
            out.println(container.toString());
        } else {
            out.println(textInput.toString());
        }
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("TextFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("TextFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

