/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ecs.html.Input;

public class UniqueIdFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        if (!template.getTypeName().equals("text")) {
            SilverTrace.info("form", "UniqueIdFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        if (field == null) {
            return;
        }
        if (!"text".equals(field.getTypeName())) {
            SilverTrace.info("form", "UniqueIdFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String defaultValue = Long.toString(new Date().getTime());
        String suffix = parameters.get("suffix");
        if ("userid".equalsIgnoreCase(suffix)) {
            defaultValue = defaultValue + "-" + pageContext.getUserId();
        }
        String string = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        Input input2 = new Input();
        input2.setName(fieldName);
        input2.setID(fieldName);
        input2.setValue(EncodeHelper.javaStringToHtmlString(value));
        input2.setType(template.isHidden() ? "hidden" : "text");
        input2.setSize(parameters.containsKey("size") ? parameters.get("size") : "50");
        input2.setReadOnly(true);
        out.println(input2.toString());
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("UniqueIdFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("UniqueIdFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

