/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.form.fieldType.TextFieldImpl;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class UrlFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        String[] s = new String[]{};
        s[0] = "text";
        return s;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
        String language = PagesContext2.getLanguage();
        if (!"text".equals(template.getTypeName())) {
            SilverTrace.info("form", "UrlFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (template.isMandatory() && PagesContext2.useMandatory()) {
            out.println("\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("\t\terrorNb++;");
            out.println("\t}");
        }
        out.println("\tif (! isValidText(field, " + Util.getSetting("nbMaxCar") + ")) {");
        out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("ContainsTooLargeText", language) + Util.getSetting("nbMaxCar") + " " + Util.getString("Characters", language) + "\\n \";");
        out.println("\t\terrorNb++;");
        out.println("\t}");
        Util.getJavascriptChecker(template.getFieldName(), PagesContext2, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        String defaultValue;
        String html = "";
        String fieldName = template.getFieldName();
        SilverTrace.info("form", "UrlFieldDisplayer.display", "root.MSG_GEN_PARAM_VALUE", "fieldName=" + fieldName);
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        if (field == null) {
            return;
        }
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "UrlFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String string = defaultValue = parameters.containsKey("default") ? parameters.get("default") : "";
        if (pageContext.isIgnoreDefaultValues()) {
            defaultValue = "";
        }
        String string2 = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (template.isReadOnly() && !template.isHidden()) {
            if (StringUtil.isDefined(value)) {
                if (!(value.startsWith("http") || value.startsWith("ftp:") || value.startsWith("/"))) {
                    value = "http://" + value;
                }
                html = "<a target=\"_blank\" href=\"" + value + "\">" + EncodeHelper.javaStringToHtmlString(value) + "</a>";
            }
        } else {
            String paramSuggestions = parameters.containsKey("suggestions") ? parameters.get("suggestions") : "false";
            boolean useSuggestions = Boolean.valueOf(paramSuggestions);
            List<String> suggestions = null;
            if (useSuggestions) {
                TextFieldImpl textField = (TextFieldImpl)field;
                suggestions = textField.getSuggestions(fieldName, template.getTemplateName(), pageContext.getComponentId());
            }
            input inputField = new input();
            inputField.setName(template.getFieldName());
            inputField.setID(template.getFieldName());
            inputField.setValue(EncodeHelper.javaStringToHtmlString(value));
            inputField.setType(template.isHidden() ? "hidden" : "text");
            inputField.setMaxlength(parameters.containsKey("maxLength") ? parameters.get("maxLength") : "1000");
            inputField.setSize(parameters.containsKey("size") ? parameters.get("size") : "50");
            if (parameters.containsKey("border")) {
                inputField.setBorder(Integer.parseInt(parameters.get("border")));
            }
            if (template.isDisabled()) {
                inputField.setDisabled(true);
            } else if (template.isReadOnly()) {
                inputField.setReadOnly(true);
            }
            img image = null;
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
                image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
            }
            if (suggestions != null && suggestions.size() > 0) {
                TextFieldImpl.printSuggestionsIncludes(pageContext, fieldName, out);
                out.println("<div id=\"listAutocomplete" + fieldName + "\">\n");
                out.println(inputField.toString());
                out.println("<div id=\"container" + fieldName + "\"/>\n");
                out.println("</div>\n");
                if (image != null) {
                    image.setStyle("position:absolute;left:16em;top:5px");
                    out.println(image.toString());
                }
                TextFieldImpl.printSuggestionsScripts(pageContext, fieldName, suggestions, out);
            } else if (image != null) {
                ElementContainer container = new ElementContainer();
                container.addElement((Element)inputField);
                container.addElement("&nbsp;");
                container.addElement((Element)image);
                out.println(container.toString());
            } else {
                out.println(inputField.toString());
            }
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("UrlFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("UrlFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

