/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFileFieldDisplayer;
import com.silverpeas.form.displayers.VideoPlayer;
import com.silverpeas.form.fieldType.FileField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.web.servlet.FileUploadUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileServerUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;

public class VideoFieldDisplayer
extends AbstractFileFieldDisplayer {
    public static final String DEFAULT_WIDTH = "425";
    public static final String DEFAULT_HEIGHT = "300";
    public static final boolean DEFAULT_AUTOPLAY = true;
    public static final String PARAMETER_WIDTH = "width";
    public static final String PARAMETER_HEIGHT = "height";
    public static final String PARAMETER_AUTOPLAY = "autoplay";
    public static final String CONTEXT_FORM_VIDEO = "XMLFormVideo";
    private static final String OPERATION_KEY = "Operation";
    private static final int DISPLAYED_HTML_OBJECTS = 2;

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) throws IOException {
        this.checkFieldType(template.getTypeName(), "VideoFieldDisplayer.displayScripts");
        String language = pageContext.getLanguage();
        String fieldName = template.getFieldName();
        if (template.isMandatory() && pageContext.useMandatory()) {
            out.append("\tif (isWhitespace(stripInitialWhitespace(field.value))) {\n").append("\t\tvar ").append(fieldName).append("Value = document.getElementById('").append(fieldName).append("$$id").append("').value;\n").append("   var ").append(fieldName).append("Operation = document.").append(pageContext.getFormName()).append(".").append(fieldName).append(OPERATION_KEY).append(".value;\n").append("\t\tif (").append(fieldName).append("Value=='' || ").append(fieldName).append("Operation=='").append(Operation.DELETION.name()).append("') {\n").append("\t\t\terrorMsg+=\"  - '").append(EncodeHelper.javaStringToJsString(template.getLabel(language))).append("' ").append(Util.getString("GML.MustBeFilled", language)).append("\\n \";\n").append("\t\t\terrorNb++;\n").append("\t\t}\n").append("\t}\n");
        }
        Util.includeFileNameLengthChecker(template, pageContext, out);
        Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
    }

    @Override
    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        this.checkFieldType(template.getTypeName(), "VideoFieldDisplayer.display");
        String attachmentId = field.getValue();
        if (!StringUtil.isDefined(attachmentId)) {
            attachmentId = "";
        }
        if (!template.isHidden()) {
            ElementContainer xhtmlcontainer = new ElementContainer();
            VideoPlayer videoPlayer = new VideoPlayer();
            videoPlayer.init((ConcreteElement)xhtmlcontainer);
            if (template.isReadOnly()) {
                this.displayVideo(videoPlayer, attachmentId, template, xhtmlcontainer, pagesContext);
            } else if (!template.isDisabled()) {
                this.displayVideoFormInput(videoPlayer, attachmentId, template, xhtmlcontainer, pagesContext);
            }
            out.println(xhtmlcontainer.toString());
        }
    }

    @Override
    public List<String> update(String attachmentId, FileField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        this.checkFieldType(field.getTypeName(), "VideoFieldDisplayer.update");
        ArrayList<String> attachmentIds = new ArrayList<String>();
        if (!StringUtil.isDefined(attachmentId)) {
            field.setNull();
        } else {
            field.setAttachmentId(attachmentId);
            attachmentIds.add(attachmentId);
        }
        return attachmentIds;
    }

    @Override
    public List<String> update(List<FileItem> items, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        try {
            String fieldName = template.getFieldName();
            String attachmentId = this.uploadVideoFile(items, fieldName, pageContext);
            Operation operation = Operation.valueOf(FileUploadUtil.getParameter(items, fieldName + OPERATION_KEY));
            String currentAttachmentId = field.getAttachmentId();
            if ((this.isDeletion(operation, currentAttachmentId) || this.isUpdate(operation, attachmentId)) && !pageContext.isCreation()) {
                this.deleteAttachment(currentAttachmentId, pageContext);
            }
            if (StringUtil.isDefined(attachmentId)) {
                attachmentIds.addAll(this.update(attachmentId, field, template, pageContext));
            }
        }
        catch (IOException ex) {
            SilverTrace.error("form", "VideoFieldDisplayer.update", "form.EXP_UNKNOWN_FIELD", null, ex);
        }
        return attachmentIds;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }

    private void checkFieldType(String typeName, String contextCall) {
        if (!"file".equals(typeName)) {
            SilverTrace.info("form", contextCall, "form.INFO_NOT_CORRECT_TYPE", "file");
        }
    }

    private String computeVideoURL(String attachmentId, PagesContext pageContext) {
        String videoURL = "";
        if (StringUtil.isDefined(attachmentId)) {
            if (attachmentId.startsWith("/")) {
                videoURL = attachmentId;
            } else {
                SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId, pageContext.getComponentId()), pageContext.getContentLanguage());
                if (attachment != null) {
                    String webContext = FileServerUtils.getApplicationContext();
                    videoURL = webContext + attachment.getAttachmentURL();
                }
            }
        }
        return videoURL;
    }

    private void displayVideo(VideoPlayer videoPlayer, String attachmentId, FieldTemplate template, ElementContainer xhtmlContainer, PagesContext pagesContext) {
        String videoURL = this.computeVideoURL(attachmentId, pagesContext);
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        this.initVideoPlayer(videoPlayer, videoURL, parameters);
        videoPlayer.renderIn((ConcreteElement)xhtmlContainer);
    }

    private void displayVideoFormInput(VideoPlayer videoPlayer, String attachmentId, FieldTemplate template, ElementContainer xhtmlContainer, PagesContext pagesContext) {
        String fieldName = template.getFieldName();
        String language = pagesContext.getLanguage();
        String deletionIcon = Util.getIcon("delete");
        String deletionLab = Util.getString("removeFile", language);
        String videoURL = this.computeVideoURL(attachmentId, pagesContext);
        Operation defaultOperation = Operation.ADD;
        if (!videoURL.isEmpty()) {
            defaultOperation = Operation.UPDATE;
            Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
            parameters.remove(PARAMETER_WIDTH);
            parameters.remove(PARAMETER_HEIGHT);
            this.initVideoPlayer(videoPlayer, videoURL, parameters);
            img deletionImage = new img();
            deletionImage.setAlt(deletionLab).setSrc(deletionIcon).setWidth(15).setHeight(15).setAlt(deletionLab).setTitle(deletionLab);
            a removeLink = new a();
            removeLink.setHref("#").addElement((Element)deletionImage).setOnClick("javascript: document.getElementById('" + fieldName + "Video').style.display='none'; document." + pagesContext.getFormName() + "." + fieldName + OPERATION_KEY + ".value='" + Operation.DELETION.name() + "';");
            div videoDiv = new div();
            videoDiv.setID(fieldName + "Video");
            videoDiv.setClass("video");
            videoPlayer.renderIn((ConcreteElement)videoDiv);
            videoDiv.addElement("&nbsp;");
            videoDiv.addElement((Element)removeLink);
            xhtmlContainer.addElement((Element)videoDiv);
        }
        input fileInput = new input();
        fileInput.setID(fieldName);
        fileInput.setType("file");
        fileInput.setSize(50);
        fileInput.setName(fieldName);
        input attachmentInput = new input();
        attachmentInput.setType("hidden").setName(fieldName + "$$id").setValue(attachmentId).setID(fieldName + "$$id");
        input operationInput = new input();
        operationInput.setType("hidden").setName(fieldName + OPERATION_KEY).setValue(defaultOperation.name()).setID(fieldName + OPERATION_KEY);
        div selectionDiv = new div();
        selectionDiv.setID(fieldName + "Selection");
        selectionDiv.addElement((Element)fileInput);
        selectionDiv.addElement((Element)attachmentInput);
        selectionDiv.addElement((Element)operationInput);
        if (template.isMandatory() && pagesContext.useMandatory()) {
            selectionDiv.addElement(Util.getMandatorySnippet());
        }
        xhtmlContainer.addElement((Element)selectionDiv);
    }

    private void initVideoPlayer(VideoPlayer videoPlayer, String videoURL, Map<String, String> parameters) {
        String width = (parameters.containsKey(PARAMETER_WIDTH) ? parameters.get(PARAMETER_WIDTH) : DEFAULT_WIDTH) + "px";
        String height = (parameters.containsKey(PARAMETER_HEIGHT) ? parameters.get(PARAMETER_HEIGHT) : DEFAULT_HEIGHT) + "px";
        boolean autoplay = parameters.containsKey(PARAMETER_AUTOPLAY) ? Boolean.valueOf(parameters.get(PARAMETER_AUTOPLAY)) : false;
        videoPlayer.setVideoURL(videoURL);
        videoPlayer.setAutoplay(autoplay);
        videoPlayer.setWidth(width);
        videoPlayer.setHeight(height);
    }

    private String uploadVideoFile(List<FileItem> items, String itemKey, PagesContext pageContext) throws IOException {
        String attachmentId = "";
        FileItem item = FileUploadUtil.getFile(items, itemKey);
        if (!item.isFormField()) {
            String componentId = pageContext.getComponentId();
            String userId = pageContext.getUserId();
            String objectId = pageContext.getObjectId();
            String logicalName = item.getName();
            if (StringUtil.isDefined(logicalName)) {
                logicalName = FileUtil.getFilename(logicalName);
                SimpleDocument document = this.createSimpleDocument(objectId, componentId, item, logicalName, userId);
                attachmentId = document.getId();
            }
        }
        return attachmentId;
    }

    private boolean isDeletion(Operation operation, String attachmentId) {
        return StringUtil.isDefined(attachmentId) && operation == Operation.DELETION;
    }

    private boolean isUpdate(Operation operation, String attachmentId) {
        return StringUtil.isDefined(attachmentId) && operation == Operation.UPDATE;
    }

    private static enum Operation {
        ADD,
        UPDATE,
        DELETION;

    }
}

