/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.silverpeas.form.Field;
import com.silverpeas.form.FormException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import java.text.ParseException;

public abstract class DateField
implements Field {
    private static final long serialVersionUID = -885405651541562611L;
    public static final String TYPE = "date";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public abstract boolean isReadOnly();

    @Override
    public String getValue() {
        return this.getStringValue();
    }

    @Override
    public String getValue(String language) {
        return this.formatClient(this.getStringValue(), language);
    }

    @Override
    public void setValue(String value) throws FormException {
        this.setStringValue(value);
    }

    @Override
    public void setValue(String value, String language) throws FormException {
        this.setStringValue(this.formatBD(value, language));
    }

    private String formatClient(String value, String language) {
        if (value != null && !value.equals("")) {
            try {
                value = DateUtil.getInputDate(value, language);
            }
            catch (ParseException pe) {
                SilverTrace.error("form", "DateField", "form.EX_CANT_PARSE_DATE", "typeName = [" + this.getTypeName() + "]", pe);
            }
        }
        return value;
    }

    private String formatBD(String newValue, String language) {
        String dateBD = null;
        try {
            dateBD = DateUtil.date2SQLDate(newValue, language);
        }
        catch (ParseException pe) {
            SilverTrace.error("form", "DateField", "form.EX_CANT_PARSE_DATE", "typeName = [" + this.getTypeName() + "]", pe);
        }
        return dateBD;
    }

    @Override
    public boolean acceptValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return !this.isReadOnly();
    }

    @Override
    public Object getObjectValue() {
        return this.getStringValue();
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof String) {
            this.setStringValue((String)value);
        } else {
            if (value != null) {
                throw new FormException("DateField.setObjectValue", "form.EXP_NOT_A_STRING");
            }
            this.setNull();
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        if (value instanceof String) {
            return !this.isReadOnly();
        }
        return false;
    }

    @Override
    public boolean isNull() {
        return this.getStringValue() == null || this.getStringValue().trim().equals("");
    }

    @Override
    public void setNull() throws FormException {
        this.setStringValue(null);
    }

    public boolean equals(Object o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof DateField) {
            String t = ((DateField)o).getStringValue();
            if (t == null) {
                t = "";
            }
            return s.equals(t);
        }
        return false;
    }

    public int compareTo(Object o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof DateField) {
            String t = ((DateField)o).getStringValue();
            if (t == null) {
                t = "";
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getStringValue();
        return ("" + s).hashCode();
    }
}

