/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.silverpeas.form.Field;
import com.silverpeas.form.FormException;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class MultipleUserField
implements Field {
    private static final long serialVersionUID = 1412147782354556460L;
    public static final String TYPE = "multipleUser";
    private String[] userIds = null;

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String[] currentUserIds) {
        SilverTrace.info("form", "MultipleUserField.setUserIds", "root.MSG_GEN_ENTER_METHOD", "userIds = " + Arrays.toString(currentUserIds));
        this.userIds = currentUserIds != null ? Arrays.copyOf(currentUserIds, currentUserIds.length) : null;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getValue() {
        SilverTrace.info("form", "MultipleUserField.getValue", "root.MSG_GEN_PARAM_VALUE", "userIds = " + Arrays.toString(this.getUserIds()));
        if (this.userIds == null) {
            return null;
        }
        if (this.userIds.length == 0) {
            return "";
        }
        StringBuilder value = new StringBuilder();
        UserDetail[] users = OrganisationControllerFactory.getOrganisationController().getUserDetails(this.getUserIds());
        for (int i = 0; i < users.length; ++i) {
            if (i > 0) {
                value.append("\n");
            }
            if (users[i] == null) {
                value.append("user(").append(this.userIds[i]).append(")");
                continue;
            }
            value.append(users[i].getFirstName()).append(" ").append(users[i].getLastName());
        }
        return value.toString();
    }

    @Override
    public String getValue(String language) {
        return this.getValue();
    }

    @Override
    public void setValue(String value) throws FormException {
    }

    @Override
    public void setValue(String value, String language) throws FormException {
    }

    @Override
    public boolean acceptValue(String value) {
        return false;
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return false;
    }

    @Override
    public Object getObjectValue() {
        if (this.userIds == null || this.userIds.length == 0) {
            return null;
        }
        return OrganisationControllerFactory.getOrganisationController().getUserDetails(this.getUserIds());
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof UserDetail[]) {
            UserDetail[] values = (UserDetail[])value;
            this.userIds = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.userIds[i] = values[i] == null ? "" : values[i].getId();
            }
        } else if (value == null) {
            this.userIds = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            throw new FormException("MultipleUserField.setObjectValue", "form.EXP_NOT_AN_USERS_ARRAY");
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        if (value instanceof UserDetail[]) {
            return !this.isReadOnly();
        }
        return false;
    }

    @Override
    public String getStringValue() {
        if (this.userIds == null) {
            return "";
        }
        return StringUtil.join((Object[])this.userIds, (char)',');
    }

    @Override
    public void setStringValue(String value) {
        SilverTrace.info("form", "MultipleUserField.setStringValue", "root.MSG_GEN_ENTER_METHOD", "value = " + value);
        if (value == null) {
            this.setUserIds(null);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            ArrayList<String> extractedIds = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                extractedIds.add(tokenizer.nextToken());
            }
            this.setUserIds(extractedIds.toArray(new String[extractedIds.size()]));
        }
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.userIds == null;
    }

    @Override
    public void setNull() throws FormException {
        this.userIds = null;
    }

    public boolean equals(Object o) {
        Object[] usersMine = this.getUserIds();
        if (o instanceof MultipleUserField) {
            Object[] usersYours = ((MultipleUserField)o).getUserIds();
            if (usersMine.length != usersYours.length) {
                return false;
            }
            Arrays.sort(usersMine);
            Arrays.sort(usersYours);
            for (int i = 0; i < usersMine.length; ++i) {
                if (((String)usersMine[i]).equals(usersYours[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public int hashCode() {
        return ("" + Arrays.toString(this.userIds)).hashCode();
    }
}

